/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.Formatter;
import java.text.NumberFormat;
import java.util.Locale;

public class QuantityFormatter
implements Formatter<Long> {
    @Nonnull
    private static final char[] UNIT_PREFIX_SI = new char[]{'k', 'M', 'G', 'T', 'P', 'E', 'Z', 'Y'};
    @Nonnull
    private static final char[] UNIT_PREFIX_IEC = new char[]{'K', 'M', 'G', 'T', 'P', 'E', 'Z', 'Y'};
    @Nonnull
    private char[] prefix = UNIT_PREFIX_SI;
    @Nonnull
    private String unit = "";
    private boolean si = true;
    private int base = 1000;
    @Nonnull
    private NumberFormat formatter;

    public QuantityFormatter() {
        this.formatter = NumberFormat.getIntegerInstance();
        this.formatter.setMaximumFractionDigits(4);
        this.formatter.setGroupingUsed(false);
    }

    public QuantityFormatter(@Nonnull Locale locale) {
        this.formatter = NumberFormat.getIntegerInstance(locale);
        this.formatter.setMaximumFractionDigits(4);
        this.formatter.setGroupingUsed(false);
    }

    @Nonnull
    public QuantityFormatter setSI() {
        this.si = true;
        this.prefix = UNIT_PREFIX_SI;
        this.base = 1000;
        return this;
    }

    @Nonnull
    public QuantityFormatter setUnit(@Nonnull String unit) {
        this.unit = unit;
        return this;
    }

    @Nonnull
    public QuantityFormatter setIEC() {
        this.si = false;
        this.prefix = UNIT_PREFIX_IEC;
        this.base = 1024;
        return this;
    }

    @Nonnull
    public QuantityFormatter setPrecise() {
        this.formatter.setMaximumFractionDigits(340);
        return this;
    }

    @Nonnull
    public NumberFormat getNumberFormatter() {
        return this.formatter;
    }

    @Nonnull
    public QuantityFormatter setNumberFormatter(@Nonnull NumberFormat formatter) {
        this.formatter = formatter;
        return this;
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull Long data) {
        long absValue;
        StringBuilder sb = new StringBuilder();
        long value = data;
        long l = absValue = value < 0L ? -value : value;
        if (absValue < (long)this.base) {
            sb.append(this.formatter.format(value));
            if (!this.unit.isEmpty()) {
                sb.append(' ');
            }
        } else {
            int exp = (int)(Math.log(absValue) / Math.log(this.base));
            double d = (double)absValue / Math.pow(this.base, exp);
            sb.append(this.formatter.format(value < 0L ? -d : d));
            sb.append(' ');
            sb.append(this.prefix[exp - 1]);
            if (!this.si) {
                sb.append('i');
            }
        }
        sb.append(this.unit);
        return sb.toString();
    }
}

