/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.LineSeparator;
import com.android.sched.util.codec.CharsetCodec;
import com.android.sched.util.codec.CheckingException;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.FileCodec;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.StandardOutputKind;
import com.android.sched.util.file.WriterFile;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.Location;
import java.nio.charset.Charset;

public class WriterFileCodec
extends FileCodec<WriterFile> {
    private boolean append = false;
    @Nonnull
    private LineSeparator lineSeparator = LineSeparator.SYSTEM;
    @Nonnegative
    private int bufferSize = 8192;

    public WriterFileCodec(@Nonnull FileOrDirectory.Existence existence) {
        super(existence, 2);
    }

    @Nonnull
    public WriterFileCodec allowStandardOutputOrError() {
        this.allowStandardIO = true;
        this.allowStandardError = true;
        return this;
    }

    @Nonnull
    public WriterFileCodec allowStandardOutput() {
        this.allowStandardIO = true;
        return this;
    }

    @Nonnull
    public WriterFileCodec allowStandardError() {
        this.allowStandardError = true;
        return this;
    }

    @Nonnull
    public WriterFileCodec makeAppendable() {
        this.append = true;
        return this;
    }

    @Nonnull
    public WriterFileCodec withLineSeparator(@Nonnull LineSeparator lineSeparator) {
        this.lineSeparator = lineSeparator;
        return this;
    }

    @Nonnull
    public WriterFileCodec withBuffer(@Nonnegative int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    @Nonnull
    public WriterFileCodec withoutBuffer() {
        this.bufferSize = 0;
        return this;
    }

    @Nonnull
    public WriterFileCodec allowCharset() {
        this.charsetCodec = new CharsetCodec().withMinCharsetToDisplay(5).forEncoder();
        return this;
    }

    @Nonnull
    public WriterFileCodec allowCharset(@Nonnull CharsetCodec codec) {
        this.charsetCodec = codec;
        return this;
    }

    @Nonnull
    public WriterFileCodec withDefaultCharset(@Nonnull Charset defaultCharset) {
        this.defaultCharset = defaultCharset;
        return this;
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull WriterFile writer) {
        String string;
        if (writer.isStandard()) {
            if (writer.getLocation().equals(StandardOutputKind.STANDARD_OUTPUT.getLocation())) {
                string = "-";
            } else {
                assert (writer.getLocation().equals(StandardOutputKind.STANDARD_ERROR.getLocation()));
                string = "--";
            }
        } else {
            string = writer.getPath();
        }
        if (this.charsetCodec != null) {
            string = string + "[" + writer.getCharset().displayName() + "]";
        }
        return string;
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull WriterFile writer) throws CheckingException {
        Location location = writer.getLocation();
        if (location.equals(StandardOutputKind.STANDARD_OUTPUT.getLocation()) && !this.allowStandardIO) {
            throw new CheckingException("Standard output is not allowed");
        }
        if (location.equals(StandardOutputKind.STANDARD_ERROR.getLocation()) && !this.allowStandardError) {
            throw new CheckingException("Standard error is not allowed");
        }
    }

    @Override
    @Nonnull
    public WriterFile parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @Nonnull
    public WriterFile checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        Charset localCharset = this.parseCharset(context, string);
        if (localCharset != null) {
            string = string.substring(0, string.lastIndexOf(91));
        }
        if (string.equals("-")) {
            if (!this.allowStandardIO) {
                throw new ParsingException("Standard input can not be used");
            }
            return new WriterFile(context.getStandardOutput(), this.getCharset(context, localCharset), this.lineSeparator, this.bufferSize, StandardOutputKind.STANDARD_OUTPUT.getLocation());
        }
        if (string.equals("--")) {
            if (!this.allowStandardError) {
                throw new ParsingException("Standard error can not be used");
            }
            return new WriterFile(context.getStandardError(), this.getCharset(context, localCharset), this.lineSeparator, this.bufferSize, StandardOutputKind.STANDARD_ERROR.getLocation());
        }
        try {
            return new WriterFile(context.getWorkingDirectory(), string, this.getCharset(context, localCharset), this.lineSeparator, this.bufferSize, context.getRunnableHooks(), this.existence, this.change, this.append);
        }
        catch (CannotChangePermissionException | CannotCreateFileException | FileAlreadyExistsException | NoSuchFileException | NotFileException | WrongPermissionException e) {
            throw new ParsingException(e.getMessage(), e);
        }
    }
}

