/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.reflections.ReflectionManager;
import com.android.sched.util.RunnableHooks;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.config.AsapConfigBuilder;
import com.android.sched.util.config.ChainedException;
import com.android.sched.util.config.Config;
import com.android.sched.util.config.ConfigurationException;
import com.android.sched.util.config.PropertyIdException;
import com.android.sched.util.config.UnknownPropertyIdException;
import com.android.sched.util.config.UnknownPropertyNameException;
import com.android.sched.util.config.category.Category;
import com.android.sched.util.config.id.KeyId;
import com.android.sched.util.config.id.ObjectId;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.location.Location;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;

public class GatherConfigBuilder {
    @Nonnull
    private final AsapConfigBuilder builder;
    @Nonnull
    private final ChainedException.ChainedExceptionBuilder<ConfigurationException> exceptions = new ChainedException.ChainedExceptionBuilder();

    public GatherConfigBuilder(boolean debug, @Nonnull ReflectionManager reflectionManager) {
        this.builder = new AsapConfigBuilder(debug, reflectionManager);
    }

    public GatherConfigBuilder(boolean debug) {
        this.builder = new AsapConfigBuilder(debug);
    }

    @Nonnull
    public GatherConfigBuilder load(@Nonnull InputStream is, @Nonnull Location location) throws IOException {
        try {
            this.builder.load(is, location);
        }
        catch (ConfigurationException e) {
            this.exceptions.appendException(e);
        }
        return this;
    }

    @Nonnull
    public GatherConfigBuilder setString(@Nonnull String name, @Nonnull String value) {
        try {
            this.builder.setString(name, value);
        }
        catch (PropertyIdException e) {
            this.exceptions.appendException(e);
        }
        catch (UnknownPropertyNameException e) {
            this.exceptions.appendException(e);
        }
        return this;
    }

    @Nonnull
    public <T> GatherConfigBuilder set(@Nonnull String name, @Nonnull T value) {
        try {
            this.builder.set(name, value);
        }
        catch (PropertyIdException e) {
            this.exceptions.appendException(e);
        }
        catch (UnknownPropertyNameException e) {
            this.exceptions.appendException(e);
        }
        return this;
    }

    @Nonnull
    public GatherConfigBuilder setString(@Nonnull String name, @Nonnull String value, @Nonnull Location location) {
        try {
            this.builder.setString(name, value, location);
        }
        catch (UnknownPropertyNameException e) {
            this.exceptions.appendException(e);
        }
        catch (PropertyIdException e) {
            this.exceptions.appendException(e);
        }
        return this;
    }

    @Nonnull
    public <T> GatherConfigBuilder set(@Nonnull String name, @Nonnull T value, @Nonnull Location location) {
        try {
            this.builder.set(name, value, location);
        }
        catch (UnknownPropertyNameException e) {
            this.exceptions.appendException(e);
        }
        catch (PropertyIdException e) {
            this.exceptions.appendException(e);
        }
        return this;
    }

    @Nonnull
    public GatherConfigBuilder setString(@Nonnull PropertyId<?> propertyId, @Nonnull String value) {
        try {
            this.builder.setString(propertyId, value);
        }
        catch (UnknownPropertyIdException e) {
            this.exceptions.appendException(e);
        }
        catch (PropertyIdException e) {
            this.exceptions.appendException(e);
        }
        return this;
    }

    @Nonnull
    public <T> GatherConfigBuilder set(@Nonnull PropertyId<T> propertyId, @Nonnull T value) {
        try {
            this.builder.set(propertyId, value);
        }
        catch (UnknownPropertyIdException e) {
            this.exceptions.appendException(e);
        }
        catch (PropertyIdException e) {
            this.exceptions.appendException(e);
        }
        return this;
    }

    @Nonnull
    public GatherConfigBuilder setString(@Nonnull PropertyId<?> propertyId, @Nonnull String value, @Nonnull Location location) {
        try {
            this.builder.setString(propertyId, value, location);
        }
        catch (UnknownPropertyIdException e) {
            this.exceptions.appendException(e);
        }
        catch (PropertyIdException e) {
            this.exceptions.appendException(e);
        }
        return this;
    }

    @Nonnull
    public <T> GatherConfigBuilder set(@Nonnull PropertyId<T> propertyId, @Nonnull T value, @Nonnull Location location) {
        try {
            this.builder.set(propertyId, value, location);
        }
        catch (UnknownPropertyIdException e) {
            this.exceptions.appendException(e);
        }
        catch (PropertyIdException e) {
            this.exceptions.appendException(e);
        }
        return this;
    }

    @Nonnull
    public <T> GatherConfigBuilder set(@Nonnull ObjectId<T> objectId, @Nonnull T value) {
        this.builder.set(objectId, value);
        return this;
    }

    @Nonnull
    public <T> GatherConfigBuilder set(@Nonnull ObjectId<T> objectId, @Nonnull T value, @Nonnull Location location) {
        this.builder.set(objectId, value, location);
        return this;
    }

    @Nonnull
    public CodecContext getCodecContext() {
        return this.builder.getCodecContext();
    }

    @Nonnull
    public GatherConfigBuilder setCodecContext(@Nonnull CodecContext context) {
        this.builder.setCodecContext(context);
        return this;
    }

    @Nonnull
    public GatherConfigBuilder setStrictMode() {
        this.builder.setStrictMode();
        return this;
    }

    @Nonnull
    public GatherConfigBuilder setName(@Nonnull String name) {
        this.builder.setName(name);
        return this;
    }

    @Nonnull
    public GatherConfigBuilder setHooks(@Nonnull RunnableHooks hooks) {
        this.builder.setHooks(hooks);
        return this;
    }

    @Nonnull
    public Config build() throws ConfigurationException {
        Config config;
        try {
            config = this.builder.build();
        }
        catch (ConfigurationException e) {
            this.exceptions.appendException(e);
            throw this.exceptions.getException();
        }
        this.exceptions.throwIfNecessary();
        return config;
    }

    @Nonnull
    public Collection<PropertyId<?>> getPropertyIds() {
        return this.builder.getPropertyIds(Category.class);
    }

    @Nonnull
    public Collection<PropertyId<?>> getPropertyIds(@Nonnull Class<? extends Category> category) {
        return this.builder.getPropertyIds(category);
    }

    @CheckForNull
    public String getDefaultValue(@Nonnull PropertyId<?> propertyId) {
        return this.builder.getDefaultValue(propertyId);
    }

    @Nonnull
    public Location getLocation(@Nonnull KeyId<?, ?> keyId) {
        return this.builder.getLocation(keyId);
    }

    @Nonnull
    public GatherConfigBuilder processEnvironmentVariables(@Nonnull String envPrefix) {
        try {
            this.builder.processEnvironmentVariables(envPrefix);
        }
        catch (ConfigurationException e) {
            this.exceptions.appendException(e);
        }
        return this;
    }

    public void pushDefaultLocation(@Nonnull Location location) {
        this.builder.pushDefaultLocation(location);
    }

    public void popDefaultLocation() {
        this.builder.popDefaultLocation();
    }

    @Nonnull
    public GatherConfigBuilder set(@Nonnull PropertyId<Boolean> propertyId, boolean value) {
        this.set((PropertyId)propertyId, (Object)value);
        return this;
    }

    @Nonnull
    public GatherConfigBuilder set(@Nonnull PropertyId<Boolean> propertyId, boolean value, @Nonnull Location location) {
        this.set((PropertyId)propertyId, (Object)value, location);
        return this;
    }

    @Nonnull
    public GatherConfigBuilder set(@Nonnull PropertyId<Byte> propertyId, byte value) {
        this.set((PropertyId)propertyId, (Object)value);
        return this;
    }

    @Nonnull
    public GatherConfigBuilder set(@Nonnull PropertyId<Byte> propertyId, byte value, @Nonnull Location location) {
        this.set((PropertyId)propertyId, (Object)value, location);
        return this;
    }

    @Nonnull
    public GatherConfigBuilder set(@Nonnull PropertyId<Short> propertyId, short value) {
        this.set((PropertyId)propertyId, (Object)value);
        return this;
    }

    @Nonnull
    public GatherConfigBuilder set(@Nonnull PropertyId<Short> propertyId, short value, @Nonnull Location location) {
        this.set((PropertyId)propertyId, (Object)value, location);
        return this;
    }

    @Nonnull
    public GatherConfigBuilder set(@Nonnull PropertyId<Character> propertyId, char value) {
        this.set((PropertyId)propertyId, (Object)Character.valueOf(value));
        return this;
    }

    @Nonnull
    public GatherConfigBuilder set(@Nonnull PropertyId<Character> propertyId, char value, @Nonnull Location location) {
        this.set((PropertyId)propertyId, (Object)Character.valueOf(value), location);
        return this;
    }

    @Nonnull
    public GatherConfigBuilder set(@Nonnull PropertyId<Integer> propertyId, int value) {
        this.set((PropertyId)propertyId, (Object)value);
        return this;
    }

    @Nonnull
    public GatherConfigBuilder set(@Nonnull PropertyId<Integer> propertyId, int value, @Nonnull Location location) {
        this.set((PropertyId)propertyId, (Object)value, location);
        return this;
    }

    @Nonnull
    public GatherConfigBuilder set(@Nonnull PropertyId<Long> propertyId, long value) {
        this.set((PropertyId)propertyId, (Object)value);
        return this;
    }

    @Nonnull
    public GatherConfigBuilder set(@Nonnull PropertyId<Long> propertyId, long value, @Nonnull Location location) {
        this.set((PropertyId)propertyId, (Object)value, location);
        return this;
    }

    @Nonnull
    public GatherConfigBuilder set(@Nonnull PropertyId<Float> propertyId, float value) {
        this.set((PropertyId)propertyId, (Object)Float.valueOf(value));
        return this;
    }

    @Nonnull
    public GatherConfigBuilder set(@Nonnull PropertyId<Float> propertyId, float value, @Nonnull Location location) {
        this.set((PropertyId)propertyId, (Object)Float.valueOf(value), location);
        return this;
    }

    @Nonnull
    public GatherConfigBuilder set(@Nonnull PropertyId<Double> propertyId, double value) {
        this.set((PropertyId)propertyId, (Object)value);
        return this;
    }

    @Nonnull
    public GatherConfigBuilder set(@Nonnull PropertyId<Double> propertyId, double value, @Nonnull Location location) {
        this.set((PropertyId)propertyId, (Object)value, location);
        return this;
    }
}

