/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.config.Config;
import com.android.sched.util.config.ConfigPrinter;
import com.android.sched.util.config.ConfigPrinterFactory;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.file.WriterFile;
import com.android.sched.util.stream.CustomPrintWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;

@ImplementationName(iface=ConfigPrinter.class, name="properties-file")
public class PropertiesConfigPrinter
implements ConfigPrinter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printConfig(@Nonnull Config config) {
        WriterFile stream = ThreadConfig.get(ConfigPrinterFactory.CONFIG_PRINTER_FILE);
        try (CustomPrintWriter printer = stream.getPrintWriter();){
            ((PrintWriter)printer).println("#");
            ((PrintWriter)printer).println("# Generated by " + PropertiesConfigPrinter.class.getSimpleName());
            ((PrintWriter)printer).println("# on " + new Date().toString());
            ((PrintWriter)printer).println("#");
            Collection<PropertyId<?>> collec = config.getPropertyIds();
            PropertyId[] properties = collec.toArray(new PropertyId[collec.size()]);
            Arrays.sort(properties, new Comparator<PropertyId<?>>(){

                @Override
                public int compare(PropertyId<?> o1, PropertyId<?> o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (PropertyId property : properties) {
                if (!config.hasValue(property)) continue;
                ((PrintWriter)printer).println(property.getName() + " = " + config.getAsString(property));
            }
        }
    }
}

