/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.config.ChainedException;
import com.android.sched.util.config.ConfigurationException;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.location.HasLocation;
import com.android.sched.util.location.Location;
import com.android.sched.util.location.NoLocation;
import java.util.Iterator;

public class PropertyIdException
extends ConfigurationException
implements HasLocation {
    private static final long serialVersionUID = 1L;
    @Nonnull
    protected static final Location NO_LOCATION = new NoLocation();
    @Nonnull
    private final Location location;
    @Nonnull
    private final PropertyId<?> propertyId;

    public PropertyIdException(@Nonnull PropertyId<?> propertyId, @Nonnull Location location, @Nonnull String message) {
        super(message);
        this.propertyId = propertyId;
        this.location = location;
    }

    public PropertyIdException(@Nonnull PropertyId<?> propertyId, @Nonnull Location location, @Nonnull ChainedException causes) {
        this(propertyId, location, (Throwable)causes);
        Iterator<ChainedException> iter = causes.iterator();
        iter.next();
        while (iter.hasNext()) {
            new PropertyIdException(propertyId, location, (Throwable)iter.next()).putAsLastExceptionOf(this);
        }
    }

    public PropertyIdException(@Nonnull PropertyId<?> propertyId, @Nonnull Location location, @Nonnull Throwable cause) {
        super("", cause);
        this.propertyId = propertyId;
        this.location = location;
        this.setMessage("Property '" + propertyId.getName() + "'" + this.getDetails(location) + ": " + cause.getMessage());
    }

    public PropertyIdException(@Nonnull PropertyId<?> propertyId, @Nonnull Location location, @Nonnull String message, @Nonnull ChainedException causes) {
        this(propertyId, location, message, (Throwable)causes);
        Iterator<ChainedException> iter = causes.iterator();
        iter.next();
        while (iter.hasNext()) {
            new PropertyIdException(propertyId, location, message, iter.next()).putAsLastExceptionOf(this);
        }
    }

    public PropertyIdException(@Nonnull PropertyId<?> propertyId, @Nonnull Location location, @Nonnull String message, @Nonnull Throwable cause) {
        super(message, cause);
        this.propertyId = propertyId;
        this.location = location;
    }

    @Nonnull
    private String getDetails(@Nonnull Location location) {
        String result = location.getDescription();
        if (!result.isEmpty()) {
            result = " (in " + result + ")";
        }
        return result;
    }

    @Nonnull
    public PropertyId<?> getPropertyId() {
        return this.propertyId;
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return this.location;
    }
}

