/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config.id;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.ImplementationSelector;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.Selector;
import com.android.sched.util.config.ConfigChecker;
import com.android.sched.util.config.MissingPropertyException;
import com.android.sched.util.config.PropertyIdException;
import com.android.sched.util.config.category.Category;
import com.android.sched.util.config.expression.BooleanExpression;
import com.android.sched.util.config.expression.ClassExpression;
import com.android.sched.util.config.id.PropertyId;

public class ImplementationPropertyId<T>
extends PropertyId<T> {
    @Nonnull
    public static <T> ImplementationPropertyId<T> create(@Nonnull String name, @Nonnull String description, @Nonnull Class<T> type) {
        return new ImplementationPropertyId<T>(name, description, new ImplementationSelector<T>(type));
    }

    protected ImplementationPropertyId(@Nonnull String name, @Nonnull String description, @Nonnull ImplementationSelector<T> parser) {
        super(name, description, parser);
    }

    @Override
    @Nonnull
    public ImplementationPropertyId<T> addDefaultValue(@Nonnull String defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Override
    @Nonnull
    public ImplementationPropertyId<T> addCategory(@Nonnull Class<? extends Category> category) {
        super.addCategory((Class)category);
        return this;
    }

    @Override
    @Nonnull
    public ImplementationPropertyId<T> addCategory(@Nonnull Category category) {
        super.addCategory(category);
        return this;
    }

    @Nonnull
    public ImplementationPropertyId<T> bypassAccessibility() {
        ((ImplementationSelector)this.getCodec()).bypassAccessibility();
        return this;
    }

    @Override
    @Nonnull
    public ImplementationPropertyId<T> requiredIf(@Nonnull BooleanExpression expression) {
        super.requiredIf(expression);
        return this;
    }

    @Override
    @Nonnull
    public ImplementationSelector<T> getCodec() {
        return (ImplementationSelector)super.getCodec();
    }

    @Nonnull
    public ClassExpression<T> getClazz() {
        return new ClassExpression<T>((Selector)((Object)this.getCodec())){

            @Override
            public Class<? extends T> eval(@Nonnull ConfigChecker checker) throws PropertyIdException, MissingPropertyException {
                if (!ImplementationPropertyId.this.isRequired(checker)) {
                    throw new MissingPropertyException(ImplementationPropertyId.this);
                }
                try {
                    return ((Selector)((Object)ImplementationPropertyId.this.getCodec())).getClass(checker.getRawValue(ImplementationPropertyId.this));
                }
                catch (ParsingException e) {
                    throw new PropertyIdException(ImplementationPropertyId.this, checker.getLocation(ImplementationPropertyId.this), e);
                }
            }

            @Override
            @Nonnull
            public String getDescription() {
                return this.formatPropertyName(ImplementationPropertyId.this);
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) {
                return this.formatPropertyName(checker, ImplementationPropertyId.this);
            }
        };
    }
}

