/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config.id;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.InputStreamCodec;
import com.android.sched.util.config.category.Category;
import com.android.sched.util.config.expression.BooleanExpression;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.file.InputStreamFile;
import com.android.sched.util.file.StreamFileStatus;
import com.android.sched.util.log.LoggerFactory;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InputStreamFilePropertyId
extends PropertyId<InputStreamFile> {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();

    @Nonnull
    public static InputStreamFilePropertyId create(@Nonnull String name, @Nonnull String description, @Nonnull InputStreamCodec codec) {
        return new InputStreamFilePropertyId(name, description, codec);
    }

    protected InputStreamFilePropertyId(@Nonnull String name, @Nonnull String description, @Nonnull InputStreamCodec codec) {
        super(name, description, codec);
        this.withAutoCheck();
    }

    @Nonnull
    public InputStreamFilePropertyId withAutoClose() {
        this.setShutdownHook(new PropertyId.ShutdownRunnable<InputStreamFile>(){

            @Override
            public void run(InputStreamFile file) {
                if (file.getStatus() == StreamFileStatus.OPEN) {
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "Failed to close '" + file.getPath() + "' from property '" + InputStreamFilePropertyId.this.getName() + "'", e);
                    }
                }
            }
        });
        return this;
    }

    @Nonnull
    public InputStreamFilePropertyId withAutoCheck() {
        this.setShutdownHook(new PropertyId.ShutdownRunnable<InputStreamFile>(){

            @Override
            public void run(InputStreamFile file) {
                if (file.getStatus() == StreamFileStatus.OPEN) {
                    throw new AssertionError((Object)("File '" + file.getPath() + "' from property '" + InputStreamFilePropertyId.this.getName() + "' is not closed"));
                }
            }
        });
        return this;
    }

    @Nonnull
    public InputStreamFilePropertyId withoutAutoAction() {
        this.removeShutdownHook();
        return this;
    }

    @Nonnull
    public InputStreamFilePropertyId addDefaultValue(@Nonnull String defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Nonnull
    public InputStreamFilePropertyId addDefaultValue(@Nonnull InputStreamFile defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Override
    @Nonnull
    public InputStreamFilePropertyId requiredIf(@Nonnull BooleanExpression expression) {
        super.requiredIf(expression);
        return this;
    }

    @Nonnull
    public InputStreamCodec getCodec() {
        return (InputStreamCodec)super.getCodec();
    }

    @Nonnull
    public InputStreamFilePropertyId addCategory(@Nonnull Class<? extends Category> category) {
        super.addCategory((Class)category);
        return this;
    }

    @Override
    @Nonnull
    public InputStreamFilePropertyId addCategory(@Nonnull Category category) {
        super.addCategory(category);
        return this;
    }
}

