/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config.id;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.DoubleCodec;
import com.android.sched.util.config.category.Category;
import com.android.sched.util.config.expression.BooleanExpression;
import com.android.sched.util.config.id.DoublePropertyId;

public class ProbabilityPropertyId
extends DoublePropertyId {
    @Nonnull
    public static ProbabilityPropertyId create(@Nonnull String name, @Nonnull String description) {
        return new ProbabilityPropertyId(name, description, new ProbabilityCodec());
    }

    protected ProbabilityPropertyId(@Nonnull String name, @Nonnull String description, @Nonnull ProbabilityCodec parser) {
        super(name, description, parser);
    }

    @Override
    @Nonnull
    public ProbabilityPropertyId addDefaultValue(@Nonnull String defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Override
    @Nonnull
    public ProbabilityPropertyId addDefaultValue(@Nonnull Double defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Override
    @Nonnull
    public ProbabilityPropertyId addDefaultValue(@Nonnull double defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Override
    @Nonnull
    public ProbabilityPropertyId requiredIf(@Nonnull BooleanExpression expression) {
        super.requiredIf(expression);
        return this;
    }

    @Override
    @Nonnull
    public ProbabilityPropertyId withMin(double min) {
        assert (this.checkRange(min));
        super.withMin(min);
        return this;
    }

    @Override
    @Nonnull
    public ProbabilityPropertyId withMax(double max) {
        assert (this.checkRange(max));
        super.withMax(max);
        return this;
    }

    private boolean checkRange(double value) {
        return value >= 0.0 && value <= 1.0;
    }

    @Override
    @Nonnull
    public ProbabilityPropertyId addCategory(@Nonnull Class<? extends Category> category) {
        super.addCategory((Class)category);
        return this;
    }

    @Override
    @Nonnull
    public ProbabilityPropertyId addCategory(@Nonnull Category category) {
        super.addCategory(category);
        return this;
    }

    protected static class ProbabilityCodec
    extends DoubleCodec {
        public ProbabilityCodec() {
            this.setMin(0.0);
            this.setMax(1.0);
        }

        @Override
        @Nonnull
        public String getUsage() {
            return "a probability belonging to [0 (never) .. 1 (always)]";
        }

        @Override
        @Nonnull
        public String getVariableName() {
            return "probability";
        }
    }
}

