/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.file;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.file.AbstractStreamFile;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.DirectoryLocation;
import com.android.sched.util.location.FileLocation;
import java.io.File;

public class Files {
    private static final int TEMP_ATTEMPTS = 10000;

    private Files() {
    }

    @Nonnull
    public static File createTempDir(@Nonnull String prefix) throws CannotCreateFileException, CannotChangePermissionException {
        String tmpdir = System.getProperty("java.io.tmpdir");
        assert (tmpdir != null);
        File baseDir = new File(tmpdir);
        String baseName = prefix + System.currentTimeMillis() + "-";
        DirectoryLocation location = null;
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            location = new DirectoryLocation(tempDir);
            try {
                Directory.create(tempDir, location);
                FileOrDirectory.unsetPermissions(tempDir, location, 7, FileOrDirectory.ChangePermission.EVERYBODY);
                FileOrDirectory.setPermissions(tempDir, location, 7, FileOrDirectory.ChangePermission.OWNER);
                return tempDir;
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                continue;
            }
        }
        assert (location != null);
        throw new CannotCreateFileException(location);
    }

    @Nonnull
    public static File createTempFile(@Nonnull String prefix) throws CannotCreateFileException, CannotChangePermissionException {
        return Files.createTempFile(prefix, "");
    }

    @Nonnull
    public static File createTempFile(@Nonnull String prefix, @Nonnull String suffix) throws CannotCreateFileException, CannotChangePermissionException {
        Directory baseDir;
        String baseName = prefix + System.currentTimeMillis() + "-";
        String tmpdir = System.getProperty("java.io.tmpdir");
        assert (tmpdir != null);
        try {
            baseDir = new Directory(tmpdir, null, FileOrDirectory.Existence.MUST_EXIST, 3, FileOrDirectory.ChangePermission.NOCHANGE);
        }
        catch (NoSuchFileException | NotDirectoryException | WrongPermissionException e) {
            throw new CannotCreateFileException(new FileLocation(new File(tmpdir, baseName + "0" + suffix)), (Throwable)e);
        }
        catch (FileAlreadyExistsException e) {
            throw new AssertionError((Object)e);
        }
        return Files.createTempFile(baseName, suffix, baseDir.getFile());
    }

    @Nonnull
    public static File createTempFile(@Nonnull String prefix, @Nonnull String suffix, @Nonnull Directory baseDir) throws CannotCreateFileException, CannotChangePermissionException {
        String baseName = prefix + System.currentTimeMillis() + "-";
        return Files.createTempFile(baseName, suffix, baseDir.getFile());
    }

    @Nonnull
    private static File createTempFile(@Nonnull String baseName, @Nonnull String suffix, @Nonnull File baseDir) throws CannotCreateFileException, CannotChangePermissionException {
        FileLocation location = null;
        for (int counter = 0; counter < 10000; ++counter) {
            File tempFile = new File(baseDir, baseName + counter + suffix);
            location = new FileLocation(tempFile);
            try {
                AbstractStreamFile.create(tempFile, location);
                FileOrDirectory.unsetPermissions(tempFile, location, 7, FileOrDirectory.ChangePermission.EVERYBODY);
                FileOrDirectory.setPermissions(tempFile, location, 3, FileOrDirectory.ChangePermission.OWNER);
                return tempFile;
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                continue;
            }
        }
        assert (location != null);
        throw new CannotCreateFileException(location);
    }
}

