/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.file;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.ConcurrentIOException;
import com.android.sched.util.file.AbstractStreamFile;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotGetModificationTimeException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.file.ZipException;
import com.android.sched.util.location.FileLocation;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.util.zip.ZipFile;

public class InputZipFile
extends AbstractStreamFile {
    @Nonnull
    private final ZipFile zipFile;

    public InputZipFile(@Nonnull String path) throws WrongPermissionException, NoSuchFileException, NotFileException, ZipException {
        this(new File(path), new FileLocation(path));
    }

    public InputZipFile(@CheckForNull Directory workingDirectory, String path) throws NotFileException, WrongPermissionException, NoSuchFileException, ZipException {
        this(InputZipFile.getFileFromWorkingDirectory(workingDirectory, path), new FileLocation(path));
    }

    protected InputZipFile(@Nonnull File file, @Nonnull FileLocation location, @Nonnull ZipFile zipFile) throws WrongPermissionException, NoSuchFileException, NotFileException {
        super(file, location, null);
        try {
            this.performChecks(FileOrDirectory.Existence.MUST_EXIST, 1, FileOrDirectory.ChangePermission.NOCHANGE);
        }
        catch (FileAlreadyExistsException e) {
            throw new AssertionError((Object)e);
        }
        catch (CannotCreateFileException e) {
            throw new AssertionError((Object)e);
        }
        catch (CannotChangePermissionException e) {
            throw new AssertionError((Object)e);
        }
        this.zipFile = zipFile;
    }

    private InputZipFile(@Nonnull File file, @Nonnull FileLocation location) throws WrongPermissionException, NoSuchFileException, NotFileException, ZipException {
        super(file, location, null);
        try {
            this.performChecks(FileOrDirectory.Existence.MUST_EXIST, 1, FileOrDirectory.ChangePermission.NOCHANGE);
        }
        catch (FileAlreadyExistsException e) {
            throw new AssertionError((Object)e);
        }
        catch (CannotCreateFileException e) {
            throw new AssertionError((Object)e);
        }
        catch (CannotChangePermissionException e) {
            throw new AssertionError((Object)e);
        }
        this.zipFile = this.processZip(file);
    }

    @Nonnull
    protected ZipFile processZip(@Nonnull File file) throws ZipException {
        try {
            return new ZipFile(file);
        }
        catch (java.util.zip.ZipException e) {
            throw new ZipException(this.getLocation(), e);
        }
        catch (IOException e) {
            throw new ConcurrentIOException(e);
        }
    }

    @Nonnull
    public ZipFile getZipFile() {
        return this.zipFile;
    }

    @Nonnull
    public String getName() {
        assert (this.file != null);
        return this.file.getName();
    }

    @Nonnull
    public FileTime getLastModified() throws CannotGetModificationTimeException {
        assert (this.file != null);
        try {
            return Files.getLastModifiedTime(this.file.toPath(), new LinkOption[0]);
        }
        catch (IOException e) {
            throw new CannotGetModificationTimeException(this, (Throwable)e);
        }
    }
}

