/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.file;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.ConcurrentIOException;
import com.android.sched.util.RunnableHooks;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.OutputStreamFile;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.FileLocation;
import com.android.sched.util.stream.QueryableStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipOutputStream;

public class OutputZipFile
extends OutputStreamFile {
    @Nonnull
    private final Compression compression;

    public OutputZipFile(@Nonnull String name, @CheckForNull RunnableHooks hooks, @Nonnull FileOrDirectory.Existence existence, @Nonnull FileOrDirectory.ChangePermission change, @Nonnull Compression compression) throws FileAlreadyExistsException, CannotCreateFileException, CannotChangePermissionException, WrongPermissionException, NoSuchFileException, NotFileException {
        this(new File(name), new FileLocation(name), hooks, existence, change, compression);
    }

    public OutputZipFile(@CheckForNull Directory workingDirectory, @Nonnull String name, @CheckForNull RunnableHooks hooks, @Nonnull FileOrDirectory.Existence existence, @Nonnull FileOrDirectory.ChangePermission change, @Nonnull Compression compression) throws FileAlreadyExistsException, CannotCreateFileException, CannotChangePermissionException, WrongPermissionException, NoSuchFileException, NotFileException {
        this(OutputZipFile.getFileFromWorkingDirectory(workingDirectory, name), new FileLocation(name), hooks, existence, change, compression);
    }

    private OutputZipFile(@Nonnull File file, @Nonnull FileLocation location, @CheckForNull RunnableHooks hooks, @Nonnull FileOrDirectory.Existence existence, @Nonnull FileOrDirectory.ChangePermission change, @Nonnull Compression compression) throws FileAlreadyExistsException, CannotCreateFileException, CannotChangePermissionException, WrongPermissionException, NoSuchFileException, NotFileException {
        super(file, location, hooks, existence, change, false);
        this.compression = compression;
    }

    @Override
    @Nonnull
    public synchronized ZipOutputStream getOutputStream() {
        assert (this.file != null);
        this.wasUsed = true;
        if (this.stream == null) {
            this.clearRemover();
            try {
                this.stream = new CustomZipOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(this.file)), this.compression);
            }
            catch (FileNotFoundException e) {
                throw new ConcurrentIOException(e);
            }
        }
        return (ZipOutputStream)((Object)this.stream);
    }

    @Nonnull
    public String getName() {
        assert (this.file != null);
        return this.file.getName();
    }

    private static class CustomZipOutputStream
    extends ZipOutputStream
    implements QueryableStream {
        private boolean closed = false;

        public CustomZipOutputStream(@Nonnull OutputStream out, @Nonnull Compression compression) {
            super(out);
            switch (compression) {
                case COMPRESSED: {
                    this.setMethod(8);
                    break;
                }
                case UNCOMPRESSED: {
                    this.setMethod(8);
                    this.setLevel(0);
                    break;
                }
                default: {
                    throw new AssertionError((Object)compression.name());
                }
            }
        }

        @Override
        public synchronized void close() throws IOException {
            super.close();
            this.closed = true;
        }

        @Override
        public synchronized boolean isClosed() {
            return this.closed;
        }
    }

    public static enum Compression {
        COMPRESSED,
        UNCOMPRESSED;

    }
}

