/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.file;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.location.Location;
import com.android.sched.util.location.StandardErrorLocation;
import com.android.sched.util.location.StandardOutputLocation;
import java.io.OutputStream;

public enum StandardOutputKind {
    STANDARD_OUTPUT{

        @Override
        @Nonnull
        public OutputStream getOutputStream() {
            return System.out;
        }

        @Override
        @Nonnull
        public Location getLocation() {
            return STANDARD_OUTPUT_LOCATION;
        }
    }
    ,
    STANDARD_ERROR{

        @Override
        @Nonnull
        public OutputStream getOutputStream() {
            return System.err;
        }

        @Override
        @Nonnull
        public Location getLocation() {
            return STANDARD_ERROR_LOCATION;
        }
    };

    @Nonnull
    private static final Location STANDARD_OUTPUT_LOCATION;
    @Nonnull
    private static final Location STANDARD_ERROR_LOCATION;

    @Nonnull
    public abstract OutputStream getOutputStream();

    @Nonnull
    public abstract Location getLocation();

    static {
        STANDARD_OUTPUT_LOCATION = new StandardOutputLocation();
        STANDARD_ERROR_LOCATION = new StandardErrorLocation();
    }
}

