/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.location;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.location.Location;
import java.io.File;
import java.io.IOException;

public abstract class FileOrDirLocation
implements Location {
    @Nonnull
    private final String path;
    @CheckForNull
    private String normalizedPath;

    public FileOrDirLocation(@Nonnull File file) {
        this.path = file.getPath();
    }

    public FileOrDirLocation(@Nonnull String path) {
        this.path = path;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    public final boolean equals(@CheckForNull Object obj) {
        if (!(obj instanceof FileOrDirLocation)) {
            return false;
        }
        FileOrDirLocation location = (FileOrDirLocation)obj;
        this.ensureNormalized();
        location.ensureNormalized();
        assert (this.normalizedPath != null);
        assert (location.normalizedPath != null);
        return this.normalizedPath.equals(location.normalizedPath);
    }

    public final int hashCode() {
        this.ensureNormalized();
        assert (this.normalizedPath != null);
        return this.normalizedPath.hashCode();
    }

    private void ensureNormalized() {
        if (this.normalizedPath == null) {
            File file = new File(this.path);
            try {
                this.normalizedPath = file.getCanonicalPath();
            }
            catch (IOException e) {
                this.normalizedPath = file.getAbsolutePath();
            }
        }
    }
}

