/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.location;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.location.Location;
import java.util.zip.ZipEntry;

public class ZipLocation
implements Location {
    @Nonnull
    private final Location archive;
    @Nonnull
    private final String entryName;

    public ZipLocation(@Nonnull Location archive, @Nonnull ZipEntry entry) {
        this.archive = archive;
        this.entryName = entry.getName();
    }

    @Override
    @Nonnull
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        if (!this.archive.getDescription().isEmpty()) {
            sb.append(this.archive.getDescription()).append(", ");
        }
        return sb.append("entry '/").append(this.entryName).append('\'').toString();
    }

    @Nonnull
    public Location getArchive() {
        return this.archive;
    }

    @Nonnull
    public String getEntryName() {
        return this.entryName;
    }

    public final boolean equals(Object obj) {
        return obj instanceof ZipLocation && ((ZipLocation)obj).archive.equals(this.archive) && ((ZipLocation)obj).entryName.equals(this.entryName);
    }

    public final int hashCode() {
        return this.archive.hashCode() ^ this.entryName.hashCode();
    }
}

