/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.log.ThreadTracerState;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;

public class ThreadWithTracer
extends Thread {
    @CheckForNull
    private ThreadTracerState state;
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();

    public ThreadWithTracer(@Nonnull Runnable target, @Nonnull String name) {
        super(target, name);
    }

    public ThreadWithTracer(@Nonnull Runnable target) {
        super(target);
    }

    public ThreadWithTracer(@CheckForNull ThreadGroup group, @Nonnull Runnable target, @Nonnull String name, @Nonnegative long stackSize) {
        super(group, target, name, stackSize);
    }

    public ThreadWithTracer(@CheckForNull ThreadGroup group, @Nonnull Runnable target, @Nonnull String name) {
        super(group, target, name);
    }

    public ThreadWithTracer(@CheckForNull ThreadGroup group, @Nonnull Runnable target) {
        super(group, target);
    }

    @Override
    public void start() {
        this.state = this.tracer.getThreadState();
        super.start();
    }

    @Override
    public void run() {
        assert (this.state != null);
        this.tracer.pushThreadState(this.state);
        try {
            super.run();
        }
        finally {
            assert (this.state != null);
            this.tracer.popThreadState(this.state);
        }
    }
}

