/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.stats;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.findbugs.SuppressFBWarnings;
import com.android.sched.util.log.stats.Sample;
import com.android.sched.util.log.stats.Statistic;
import com.android.sched.util.log.stats.StatisticId;

@SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
public class SampleImpl
extends Sample {
    @Nonnegative
    private int validCount;
    @Nonnegative
    private int nanCount;
    private double min = Double.POSITIVE_INFINITY;
    @CheckForNull
    private Object minObject;
    private double max = Double.NEGATIVE_INFINITY;
    @CheckForNull
    private Object maxObject;
    private double total;

    protected SampleImpl(@Nonnull StatisticId<? extends Statistic> id) {
        super(id);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public synchronized void add(double value) {
        this.add(value, null);
    }

    @Override
    public synchronized void add(double value, @CheckForNull Object obj) {
        if (!Double.isNaN(value)) {
            if (value < this.min) {
                this.min = value;
                this.minObject = obj;
            }
            if (value > this.max) {
                this.max = value;
                this.maxObject = obj;
            }
            this.total += value;
            ++this.validCount;
        } else {
            ++this.nanCount;
        }
    }

    @Override
    @Nonnegative
    public int getCount() {
        return this.validCount;
    }

    @Override
    @Nonnegative
    public int getNaNCount() {
        return this.nanCount;
    }

    @Override
    public double getTotal() {
        return this.total;
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public synchronized double getAverage() {
        return this.total / (double)this.validCount;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    @CheckForNull
    public Object getMinObject() {
        return this.minObject;
    }

    @Override
    @CheckForNull
    public Object getMaxObject() {
        return this.maxObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void merge(@Nonnull Statistic statistic) {
        SampleImpl samples;
        SampleImpl sampleImpl = samples = (SampleImpl)statistic;
        synchronized (sampleImpl) {
            this.validCount += samples.validCount;
            this.nanCount += samples.nanCount;
            this.total += samples.total;
            if (samples.min < this.min) {
                this.min = samples.min;
                this.minObject = samples.minObject;
            }
            if (samples.max > this.max) {
                this.max = samples.max;
                this.maxObject = samples.maxObject;
            }
        }
    }
}

