/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.tracer;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.log.tracer.probe.EventCountProbe;
import com.android.sched.util.log.tracer.probe.GcCountProbe;
import com.android.sched.util.log.tracer.probe.GcDurationProbe;
import com.android.sched.util.log.tracer.probe.HeapAllocationCountProbe;
import com.android.sched.util.log.tracer.probe.HeapAllocationSizeProbe;
import com.android.sched.util.log.tracer.probe.HeapMemoryProbe;
import com.android.sched.util.log.tracer.probe.JitDurationProbe;
import com.android.sched.util.log.tracer.probe.Probe;
import com.android.sched.util.log.tracer.probe.ThreadContentionCountProbe;
import com.android.sched.util.log.tracer.probe.ThreadContentionDurationProbe;
import com.android.sched.util.log.tracer.probe.ThreadTimeProbe;
import com.android.sched.util.log.tracer.probe.WallClockProbe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum TemplateFtl {
    COUNT("Event count", "count.html.ftl", "count-ec.html", new MappingProbe[]{new MappingProbe(EventCountProbe.class, "count")}, null),
    TIME_TT("Thread CPU time", "time.html.ftl", "time-tt.html", new MappingProbe[]{new MappingProbe(ThreadTimeProbe.class, "time")}, null),
    TIME_WC("Wall Clock time", "time.html.ftl", "time-wc.html", new MappingProbe[]{new MappingProbe(WallClockProbe.class, "time")}, null),
    HEAP_MEMORY("Heap memory usage", "memory.html.ftl", "memory-heap.html", new MappingProbe[]{new MappingProbe(HeapMemoryProbe.class, "memory")}, null),
    HEAP_ALLOCATION_SIZE("Heap allocation size usage", "memory.html.ftl", "memory-alloc-size.html", new MappingProbe[]{new MappingProbe(HeapAllocationSizeProbe.class, "memory")}, null),
    HEAP_ALLOCATION_COUNT("Heap allocation count usage", "count.html.ftl", "heap-alloc-count.html", new MappingProbe[]{new MappingProbe(HeapAllocationCountProbe.class, "count")}, null),
    GC_TIME("Garbage Collector duration", "time.html.ftl", "time-gc.html", new MappingProbe[]{new MappingProbe(GcDurationProbe.class, "time")}, null),
    GC_COUNT("Garbage Collector count", "count.html.ftl", "count-gc.html", new MappingProbe[]{new MappingProbe(GcCountProbe.class, "count")}, null),
    CONTENTION_DURATION("Contention duration", "time.html.ftl", "time-contention.html", new MappingProbe[]{new MappingProbe(ThreadContentionDurationProbe.class, "time")}, null),
    CONTENTION_COUNT("Contention count", "count.html.ftl", "count-contention.html", new MappingProbe[]{new MappingProbe(ThreadContentionCountProbe.class, "count")}, null),
    JIT_DURATION("JIT compiler duration", "time.html.ftl", "time-jit.html", new MappingProbe[]{new MappingProbe(JitDurationProbe.class, "time")}, null),
    OVERVIEW("Overview", "overview.html.ftl", "index.html", null, null);

    @Nonnull
    private String name;
    @Nonnull
    private String templateName;
    @Nonnull
    private String targetName;
    @Nonnull
    private final List<Class<? extends Probe>> mandatoryProbes = new ArrayList<Class<? extends Probe>>();
    @Nonnull
    private final List<Class<? extends Probe>> optionalProbes = new ArrayList<Class<? extends Probe>>();
    @Nonnull
    private final Map<Class<? extends Probe>, String> labels = new HashMap<Class<? extends Probe>, String>();

    private TemplateFtl(@Nonnull String name, @CheckForNull String templateName, @CheckForNull String targetName, MappingProbe[] mandatoryProbes, MappingProbe[] optionalProbes) {
        this.name = name;
        this.templateName = templateName;
        this.targetName = targetName;
        if (mandatoryProbes != null) {
            for (MappingProbe ms : mandatoryProbes) {
                this.mandatoryProbes.add(ms.getProbe());
                this.labels.put(ms.getProbe(), ms.getLabel());
            }
        }
        if (optionalProbes != null) {
            for (MappingProbe ms : optionalProbes) {
                this.optionalProbes.add(ms.getProbe());
                this.labels.put(ms.getProbe(), ms.getLabel());
            }
        }
    }

    @Nonnull
    public String getTemplateName() {
        return this.templateName;
    }

    @Nonnull
    public String getTargetName() {
        return this.targetName;
    }

    @Nonnull
    public List<Class<? extends Probe>> getMandatoryProbes() {
        return this.mandatoryProbes;
    }

    @Nonnull
    public List<Class<? extends Probe>> getOptionalProbes() {
        return this.optionalProbes;
    }

    @Nonnull
    public Object getName() {
        return this.name;
    }

    @Nonnull
    public String getLabel(@Nonnull Class<? extends Probe> probe) {
        String label = this.labels.get(probe);
        if (label == null) {
            throw new IllegalArgumentException();
        }
        return this.labels.get(probe);
    }

    private static class MappingProbe {
        @Nonnull
        private final Class<? extends Probe> probe;
        @Nonnull
        private final String label;

        private MappingProbe(@Nonnull Class<? extends Probe> probe, @Nonnull String label) {
            this.probe = probe;
            this.label = label;
        }

        @Nonnull
        private Class<? extends Probe> getProbe() {
            return this.probe;
        }

        @Nonnull
        private String getLabel() {
            return this.label;
        }
    }
}

