/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.tracer.probe;

import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.log.tracer.probe.Probe;

public abstract class MemoryBytesProbe
extends Probe {
    private static final boolean UNIT_IN_SI = false;
    private static final int UNIT_BASE = 1024;
    private static final char[] UNIT_PREFIX = new char[]{'K', 'M', 'G', 'T', 'P', 'E', 'Z', 'Y'};
    private static final boolean PRECISE = false;
    private static final String FORMAT = "%.4f";

    protected MemoryBytesProbe(@Nonnull String description, @Nonnegative int priority) {
        super(description, priority);
    }

    @Override
    @Nonnull
    public String formatValue(long b) {
        return MemoryBytesProbe.formatBytes(b);
    }

    @Nonnull
    public static String formatBytes(long b) {
        StringBuilder sb = new StringBuilder();
        if (b < 0L) {
            sb.append('-');
            b = -b;
        }
        if (b < 1024L) {
            sb.append(b);
            sb.append(' ');
        } else {
            int exp = (int)(Math.log(b) / Math.log(1024.0));
            sb.append(String.format(FORMAT, (double)b / Math.pow(1024.0, exp)));
            sb.append(' ');
            sb.append(UNIT_PREFIX[exp - 1]);
            sb.append('i');
        }
        sb.append('B');
        return sb.toString();
    }
}

