/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.tracer.probe;

import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.ImplementationFilter;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.log.tracer.probe.Probe;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

@ImplementationName(iface=Probe.class, name="thread-contention-count", filter=Filter.class)
public class ThreadContentionCountProbe
extends Probe {
    @Nonnull
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    public ThreadContentionCountProbe() {
        super("Thread contention count", 5);
        this.threadMXBean.setThreadContentionMonitoringEnabled(true);
    }

    @Override
    @Nonnegative
    public long read() {
        return this.threadMXBean.getThreadInfo(Thread.currentThread().getId()).getBlockedCount();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    @Nonnull
    public String formatValue(long value) {
        return Long.valueOf(value).toString();
    }

    static class Filter
    implements ImplementationFilter {
        Filter() {
        }

        @Override
        public boolean isValid() {
            try {
                ThreadMXBean threadManager = ManagementFactory.getThreadMXBean();
                return threadManager.isThreadContentionMonitoringSupported();
            }
            catch (Throwable e) {
                return false;
            }
        }
    }
}

