/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.tracer.probe;

import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.log.tracer.probe.Probe;
import java.util.concurrent.TimeUnit;

public abstract class TimeNanosProbe
extends Probe {
    private static final TimeUnit[] UNIT_TIME = new TimeUnit[]{TimeUnit.DAYS, TimeUnit.HOURS, TimeUnit.MINUTES, TimeUnit.SECONDS, TimeUnit.MILLISECONDS, TimeUnit.MICROSECONDS, TimeUnit.NANOSECONDS};
    private static final String[] UNIT_PREFIX = new String[]{"d", "h", "min", "s", "ms", "\u00b5s", "ns"};
    private static final boolean PRECISE = false;
    private static final String FORMAT = "%.4f";

    protected TimeNanosProbe(@Nonnull String description, @Nonnegative int priority) {
        super(description, priority);
    }

    @Override
    @Nonnull
    public String formatValue(long ns) {
        return TimeNanosProbe.formatDuration(ns);
    }

    @Nonnull
    public static String formatDuration(long ns) {
        if (ns == 0L) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        if (ns < 0L) {
            sb.append('-');
            ns = -ns;
        }
        int idx = 0;
        for (TimeUnit unit : UNIT_TIME) {
            double u = (double)ns / (double)TimeUnit.NANOSECONDS.convert(1L, unit);
            if (u >= 1.0) {
                sb.append(String.format(FORMAT, u));
                sb.append(' ');
                sb.append(UNIT_PREFIX[idx]);
                break;
            }
            ++idx;
        }
        return sb.toString();
    }
}

