/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.tracer.watcher;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.log.EventType;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.ArrayAlloc;
import com.android.sched.util.log.stats.ArrayAllocImpl;
import com.android.sched.util.log.stats.Statistic;
import com.android.sched.util.log.stats.StatisticId;
import com.android.sched.util.log.tracer.watcher.ObjectWatcher;
import com.android.sched.util.log.tracer.watcher.WatcherInstaller;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ArrayAllocationWatcher
implements ObjectWatcher<Object> {
    @Nonnull
    private static final Map<Class<?>, StatisticId<ArrayAlloc>> arrayStats = new ConcurrentHashMap();

    @Override
    public boolean notifyInstantiation(@Nonnull Object object, @Nonnegative long size, int count, @Nonnull EventType eventType, @CheckForNull StackTraceElement site) {
        Class<?> type = object.getClass();
        if (count >= 0) {
            this.notifyArray(type, size, count, eventType);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyArray(@Nonnull Class<?> type, @Nonnegative long size, @Nonnegative int count, @Nonnull EventType eventType) {
        Class<ArrayAllocationWatcher> clazz = ArrayAllocationWatcher.class;
        synchronized (ArrayAllocationWatcher.class) {
            StatisticId<ArrayAlloc> id = arrayStats.get(type);
            if (id == null) {
                String name = type.getName();
                id = new StatisticId<ArrayAlloc>("jack.allocation.array." + name, "Array allocation of type " + name, ArrayAllocImpl.class, ArrayAlloc.class);
                arrayStats.put(type, id);
            }
            // ** MonitorExit[var6_5] (shouldn't be in output)
            try {
                TracerFactory.getTracer().getStatistic(id).recordAllocation(count, size, eventType);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return;
        }
    }

    @Override
    @Nonnull
    public ObjectWatcher.Statistics addSample(@Nonnull Object node, @CheckForNull ObjectWatcher.Statistics raw, @Nonnull EventType type) {
        throw new AssertionError();
    }

    @ImplementationName(iface=WatcherInstaller.class, name="array-alloc", description="record array allocations type by type")
    public static class DetailedAllocationWatcherInstaller
    implements WatcherInstaller {
        @Override
        public void install(@Nonnull Tracer tracer) {
            tracer.registerWatcher(Object.class, ArrayAllocationWatcher.class);
        }
    }

    static class Statistics
    implements ObjectWatcher.Statistics {
        Statistics() {
        }

        @Override
        public Iterator<Statistic> iterator() {
            throw new AssertionError();
        }
    }
}

