/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.print;

import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.print.DataType;
import com.android.sched.util.print.DataView;
import java.util.ArrayList;
import java.util.List;

public class DataViewBuilder {
    @Nonnull
    private final List<String> namesList = new ArrayList<String>();
    @Nonnull
    private final List<DataType> typesList = new ArrayList<DataType>();
    @Nonnull
    private final DataType type;

    @Nonnull
    public static DataViewBuilder getStructure() {
        return new DataViewBuilder(DataType.STRUCT);
    }

    @Nonnull
    public static DataViewBuilder getList(@Nonnull DataType type) {
        return new DataViewBuilder(DataType.LIST).addField("<unknown>", type);
    }

    private DataViewBuilder(@Nonnull DataType type) {
        this.type = type;
    }

    @Nonnull
    public DataViewBuilder addField(@Nonnull String name, @Nonnull DataType type) {
        this.namesList.add(name);
        this.typesList.add(type);
        return this;
    }

    @Nonnull
    public DataViewBuilder addDataView(@Nonnull DataView view) {
        for (String string : view.getDataNames()) {
            this.namesList.add(string);
        }
        for (DataType dataType : view.getDataTypes()) {
            this.typesList.add(dataType);
        }
        return this;
    }

    @Nonnull
    public DataViewBuilder addFields(@Nonnull String[] names, @Nonnull DataType[] types) {
        for (String string : names) {
            this.namesList.add(string);
        }
        for (DataType dataType : types) {
            this.typesList.add(dataType);
        }
        return this;
    }

    @Nonnull
    public DataView build() {
        assert (this.namesList.size() == this.typesList.size());
        return new DataHeaderImpl(this.namesList, this.typesList);
    }

    private class DataHeaderImpl
    implements DataView {
        @Nonnull
        private final String[] names;
        @Nonnull
        private final DataType[] types;

        public DataHeaderImpl(@Nonnull List<String> names, List<DataType> types) {
            this.names = names.toArray(new String[names.size()]);
            this.types = types.toArray(new DataType[types.size()]);
        }

        @Override
        @Nonnegative
        public int getDataCount() {
            return this.names.length;
        }

        @Override
        @Nonnull
        public String[] getDataNames() {
            return this.names;
        }

        @Override
        @Nonnull
        public DataType[] getDataTypes() {
            return this.types;
        }

        @Override
        @Nonnull
        public DataType getDataType() {
            return DataViewBuilder.this.type;
        }
    }
}

