/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.sched;

import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.item.AbstractItemManager;
import com.android.sched.item.Feature;
import com.android.sched.item.Item;
import com.android.sched.item.Items;
import com.android.sched.item.ManagedItem;
import com.android.sched.item.Production;
import com.android.sched.marker.ManagedMarker;
import com.android.sched.marker.Marker;
import com.android.sched.marker.MarkerManager;
import com.android.sched.marker.MarkerNotConformException;
import com.android.sched.scheduler.FeatureSet;
import com.android.sched.scheduler.ManagedRunnable;
import com.android.sched.scheduler.ManagedSchedulable;
import com.android.sched.scheduler.ManagedVisitor;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.codec.PathCodec;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.sched.ManagedDataListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@ImplementationName(iface=ManagedDataListener.class, name="dot")
@HasKeyId
public class ManagedDataAsDot
implements ManagedDataListener {
    @Nonnull
    private static final PropertyId<File> DOT_FILE = PropertyId.create("sched.dotfile", "Define in which file generates data as dot", new PathCodec()).addDefaultValue((File)((Object)"schedlib.dot"));
    @Nonnull
    private final PrintWriter out;
    @Nonnull
    private final Map<Class<? extends Item>, Class<?>> itemOnlyUsedOnType = new HashMap();
    @Nonnull
    private final Map<Class<?>, ManagedRunnable> typeAtLeastUseBy = new HashMap();
    @Nonnull
    private final List<ManagedVisitor> visitorList = new LinkedList<ManagedVisitor>();
    @Nonnegative
    private int closeIfZero;
    @Nonnegative
    private int nbItemManagerOpen = 0;
    private boolean noMoreItemManager = false;
    private boolean noMoreManagedSchedulable = false;

    public ManagedDataAsDot() throws IOException {
        Logger logger = LoggerFactory.getLogger();
        File file = ThreadConfig.get(DOT_FILE);
        try {
            this.out = new PrintWriter(new BufferedWriter(new FileWriter(file), 102400));
            this.out.println("digraph g {");
            this.out.println("  compound=true;");
            this.out.println("  graph [");
            this.out.println("    rankdir = TD");
            this.out.println("  ];");
            this.out.println("  node [");
            this.out.println("    fontsize = 16");
            this.out.println("    shape = ellipse");
            this.out.println("  ];");
            this.out.println("  edge [");
            this.out.println("  ];");
            this.out.println();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unable to open graph file '" + file.getAbsolutePath() + "'", e);
            throw e;
        }
        this.closeIfZero = 2;
    }

    @Override
    public void notifyNewItemManager(@Nonnull AbstractItemManager itemManager) {
        assert (!this.noMoreItemManager);
        ++this.nbItemManagerOpen;
        ++this.closeIfZero;
    }

    @Override
    public void notifyNoMoreItemManager() {
        assert (!this.noMoreItemManager);
        this.noMoreItemManager = true;
        --this.closeIfZero;
        this.closeIfZero();
    }

    @Override
    public void notifyNewManagedItem(@Nonnull ManagedItem item) {
        assert (this.nbItemManagerOpen > 0);
        if (Marker.class.isAssignableFrom(item.getItem())) {
            try {
                this.addManagedMarker(new ManagedMarker(item.getItem()));
            }
            catch (MarkerNotConformException e) {
                this.addManagedMarkerError(item);
            }
        } else {
            this.addManagedItem(item);
        }
    }

    @Override
    public void notifyNoMoreManagedItem(@Nonnull Class<? extends Item> type) {
        assert (this.nbItemManagerOpen > 0);
        --this.nbItemManagerOpen;
        --this.closeIfZero;
        this.closeIfZero();
    }

    @Override
    public void notifyNewManagedSchedulable(@Nonnull ManagedSchedulable schedulable) {
        assert (!this.noMoreManagedSchedulable);
        if (schedulable instanceof ManagedRunnable) {
            this.addManagedRunnable((ManagedRunnable)schedulable);
        } else if (schedulable instanceof ManagedVisitor) {
            this.addManagedVisitor((ManagedVisitor)schedulable);
        } else {
            throw new AssertionError();
        }
    }

    @Override
    public void notifyNoMoreManagedSchedulable() {
        assert (!this.noMoreManagedSchedulable);
        this.noMoreManagedSchedulable = true;
        --this.closeIfZero;
        this.closeIfZero();
    }

    private void closeIfZero() {
        if (this.closeIfZero == 0) {
            this.close();
        }
    }

    private void addManagedMarker(@Nonnull ManagedMarker marker) {
        this.out.println("\"" + marker.getMarker().getCanonicalName() + "\"");
        this.out.println("[");
        this.out.println("  shape=none,");
        this.out.println("  margin=0,");
        this.out.println("  label =<");
        this.out.println("    <TABLE BORDER=\"0\" CELLBORDER=\"1\" CELLSPACING=\"0\" CELLPADDING=\"4\">");
        this.out.println("      <TR><TD PORT=\"header\" BGCOLOR=\"black\"><FONT COLOR=\"white\">" + marker.getName() + "</FONT></TD></TR>");
        for (Class<? extends MarkerManager> cls : marker.getStaticValidOn()) {
            this.out.println("      <TR><TD>" + cls.getSimpleName() + "</TD></TR>");
        }
        for (ManagedMarker.InternalDynamicValidOn dvo : marker.getDynamicValidOn()) {
            this.out.println("      <TR><TD><FONT COLOR=\"#aaaaaa\">" + dvo.getValidOn().getSimpleName() + "</FONT></TD></TR>");
        }
        this.out.println("    </TABLE>>");
        this.out.println("];");
        this.out.println();
    }

    private void addManagedMarkerError(@Nonnull ManagedItem item) {
        this.out.println("\"" + item.getItem().getCanonicalName() + "\"");
        this.out.println("[");
        this.out.println("  shape = box,");
        this.out.println("  style = filled,");
        this.out.println("  color = red,");
        this.out.println("  fillcolor = red,");
        this.out.println("  fontcolor = black,");
        this.out.println("  label = \"" + item.getName() + "\",");
        this.out.println("];");
        this.out.println();
    }

    private void addManagedItem(@Nonnull ManagedItem item) {
        if (Feature.class.isAssignableFrom(item.getItem())) {
            return;
        }
        this.out.println("\"" + item.getItem().getCanonicalName() + "\"");
        this.out.println("[");
        this.out.println("  shape = box,");
        this.out.println("  style = filled,");
        if (Production.class.isAssignableFrom(item.getItem())) {
            this.out.println("  color = gold3,");
            this.out.println("  fillcolor = gold3,");
            this.out.println("  fontcolor = black,");
        } else {
            this.out.println("  color = black,");
            this.out.println("  fillcolor = black,");
            this.out.println("  fontcolor = white,");
        }
        this.out.println("  label = \"" + item.getName() + "\",");
        this.out.println("];");
        this.out.println();
    }

    private void addManagedRunnable(@Nonnull ManagedRunnable runnable) {
        if (this.typeAtLeastUseBy.get(runnable.getRunOn()) == null) {
            this.typeAtLeastUseBy.put(runnable.getRunOn(), runnable);
        }
        this.out.println("subgraph \"cluster_" + runnable.getRunOn().getCanonicalName() + "\"");
        this.out.println("{");
        this.out.println("  label=\"" + runnable.getRunOn().getSimpleName() + "\";");
        this.out.println("  color=blue;");
        this.out.println("  fontcolor = blue;");
        this.out.println("  \"" + runnable.getRunnableSchedulable().getCanonicalName() + "\"");
        this.out.println("  [");
        this.out.println("  shape=none,");
        this.out.println("  margin=0,");
        this.out.println("  label =<");
        this.out.println("    <TABLE BORDER=\"0\" CELLBORDER=\"1\" CELLSPACING=\"0\" CELLPADDING=\"4\">");
        this.out.println("      <TR><TD BGCOLOR=\"white\"><FONT COLOR=\"black\">" + runnable.getName() + "</FONT></TD></TR>");
        for (Class cls : runnable.getSupportedFeatures()) {
            this.out.println("      <TR><TD><FONT COLOR=\"black\">" + Items.getName(cls) + "</FONT></TD></TR>");
        }
        FeatureSet all = new FeatureSet(runnable.getSupportedFeatures());
        all.clear();
        for (FeatureSet features : runnable.getOptionalFeatures()) {
            all.addAll(features);
        }
        for (Class feature : all) {
            this.out.println("      <TR><TD><FONT COLOR=\"grey\">" + Items.getName(feature) + "</FONT></TD></TR>");
        }
        this.out.println("    </TABLE>>");
        this.out.println("  ];");
        this.out.println("}");
        this.out.println();
        for (Class item : runnable.getAddedTags()) {
            this.out.print("\"" + runnable.getRunnableSchedulable().getCanonicalName() + "\"");
            this.out.print(" -> ");
            this.out.println("\"" + item.getCanonicalName() + "\"");
            this.out.println("[");
            this.out.println("  arrowhead=normal,");
            this.out.println("  color=green4");
            this.out.println("];");
            this.out.println();
            if (this.itemOnlyUsedOnType.get(item) != null) {
                if (this.itemOnlyUsedOnType.get(item) == runnable.getRunOn()) continue;
                this.itemOnlyUsedOnType.remove(item);
                this.itemOnlyUsedOnType.put(item, null);
                continue;
            }
            this.itemOnlyUsedOnType.put(item, runnable.getRunOn());
        }
        for (Class item : runnable.getRemovedTags()) {
            this.out.print("\"" + runnable.getRunnableSchedulable().getCanonicalName() + "\"");
            this.out.print(" -> ");
            this.out.println("\"" + item.getCanonicalName() + "\"");
            this.out.println("[");
            this.out.println("  arrowhead=normal,");
            this.out.println("  color=red4");
            this.out.println("];");
            this.out.println();
            if (this.itemOnlyUsedOnType.get(item) != null) {
                if (this.itemOnlyUsedOnType.get(item) == runnable.getRunOn()) continue;
                this.itemOnlyUsedOnType.remove(item);
                this.itemOnlyUsedOnType.put(item, null);
                continue;
            }
            this.itemOnlyUsedOnType.put(item, runnable.getRunOn());
        }
        for (Class item : runnable.getDefaultNeededTags()) {
            this.out.print("\"" + item.getCanonicalName() + "\"");
            this.out.print(" -> ");
            this.out.println("\"" + runnable.getRunnableSchedulable().getCanonicalName() + "\"");
            this.out.println("[");
            this.out.println("  arrowhead=normal,");
            this.out.println("  style=dashed,");
            this.out.println("  color=green4");
            this.out.println("];");
            this.out.println();
            if (this.itemOnlyUsedOnType.get(item) != null) {
                if (this.itemOnlyUsedOnType.get(item) == runnable.getRunOn()) continue;
                this.itemOnlyUsedOnType.remove(item);
                this.itemOnlyUsedOnType.put(item, null);
                continue;
            }
            this.itemOnlyUsedOnType.put(item, runnable.getRunOn());
        }
        for (Class item : runnable.getDefaultUnsupportedTags()) {
            this.out.print("\"" + item.getCanonicalName() + "\"");
            this.out.print(" -> ");
            this.out.println("\"" + runnable.getRunnableSchedulable().getCanonicalName() + "\"");
            this.out.println("[");
            this.out.println("  arrowhead=normal,");
            this.out.println("  style=dashed,");
            this.out.println("  color=red4");
            this.out.println("];");
            this.out.println();
            if (this.itemOnlyUsedOnType.get(item) != null) {
                if (this.itemOnlyUsedOnType.get(item) == runnable.getRunOn()) continue;
                this.itemOnlyUsedOnType.remove(item);
                this.itemOnlyUsedOnType.put(item, null);
                continue;
            }
            this.itemOnlyUsedOnType.put(item, runnable.getRunOn());
        }
        for (FeatureSet features : runnable.getOptionalFeatures()) {
            for (Class item : runnable.getNeededTags(features)) {
                this.out.print("\"" + item.getCanonicalName() + "\"");
                this.out.print(" -> ");
                this.out.println("\"" + runnable.getRunnableSchedulable().getCanonicalName() + "\"");
                this.out.println("[");
                this.out.println("  arrowhead=normal,");
                this.out.println("  style=dotted,");
                this.out.println("  label=\"" + features + "\"");
                this.out.println("  color=green4");
                this.out.println("];");
                this.out.println();
                if (this.itemOnlyUsedOnType.get(item) != null) {
                    if (this.itemOnlyUsedOnType.get(item) == runnable.getRunOn()) continue;
                    this.itemOnlyUsedOnType.remove(item);
                    this.itemOnlyUsedOnType.put(item, null);
                    continue;
                }
                this.itemOnlyUsedOnType.put(item, runnable.getRunOn());
            }
            for (Class item : runnable.getUnsupportedTags(features)) {
                this.out.print("\"" + item.getCanonicalName() + "\"");
                this.out.print(" -> ");
                this.out.println("\"" + runnable.getRunnableSchedulable().getCanonicalName() + "\"");
                this.out.println("[");
                this.out.println("  arrowhead=normal,");
                this.out.println("  style=dotted,");
                this.out.println("  label=\"" + features + "\"");
                this.out.println("  color=red4");
                this.out.println("];");
                this.out.println();
                if (this.itemOnlyUsedOnType.get(item) != null) {
                    if (this.itemOnlyUsedOnType.get(item) == runnable.getRunOn()) continue;
                    this.itemOnlyUsedOnType.remove(item);
                    this.itemOnlyUsedOnType.put(item, null);
                    continue;
                }
                this.itemOnlyUsedOnType.put(item, runnable.getRunOn());
            }
        }
        for (Class item : runnable.getProductions()) {
            this.out.print("\"" + runnable.getRunnableSchedulable().getCanonicalName() + "\"");
            this.out.print(" -> ");
            this.out.println("\"" + item.getCanonicalName() + "\"");
            this.out.println("[");
            this.out.println("  arrowhead=normal,");
            this.out.println("  color=gold3");
            this.out.println("];");
            this.out.println();
            if (this.itemOnlyUsedOnType.get(item) != null) {
                if (this.itemOnlyUsedOnType.get(item) == runnable.getRunOn()) continue;
                this.itemOnlyUsedOnType.remove(item);
                this.itemOnlyUsedOnType.put(item, null);
                continue;
            }
            this.itemOnlyUsedOnType.put(item, runnable.getRunOn());
        }
    }

    private void addManagedVisitor(@Nonnull ManagedVisitor visitor) {
        this.visitorList.add(visitor);
    }

    private void close() {
        for (Map.Entry<Class<Item>, Class<?>> entry : this.itemOnlyUsedOnType.entrySet()) {
            if (entry.getValue() == null) continue;
            this.out.println("subgraph \"cluster_" + entry.getValue().getCanonicalName() + "\"");
            this.out.println("{");
            this.out.println("  \"" + entry.getKey().getCanonicalName() + "\"");
            this.out.println("}");
            this.out.println();
        }
        for (ManagedVisitor visitor : this.visitorList) {
            this.out.println("\"" + visitor.getVisitorSchedulable().getCanonicalName() + "\"");
            this.out.println("[");
            this.out.println("  shape=hexagon,");
            this.out.println("  color=blue,");
            this.out.println("  fontcolor=blue,");
            this.out.println("  label=\"" + visitor.getName() + "\"");
            this.out.println("];");
            this.out.println();
            if (this.typeAtLeastUseBy.get(visitor.getRunOn()) == null) {
                this.out.println("subgraph \"cluster_" + visitor.getRunOn().getCanonicalName() + "\"");
                this.out.println("{");
                this.out.println("  label=\"" + visitor.getRunOn().getSimpleName() + "\";");
                this.out.println("  color=blue;");
                this.out.println("  fontcolor = blue;");
                this.out.println("  \"" + visitor.getRunOn().getCanonicalName() + "\"");
                this.out.println("  [");
                this.out.println("    shape=point");
                this.out.println("  ];");
                this.out.println("}");
                this.out.println();
            }
            if (this.typeAtLeastUseBy.get(visitor.getRunOn()) != null) {
                this.out.print("\"" + this.typeAtLeastUseBy.get(visitor.getRunOn()).getRunnableSchedulable().getCanonicalName() + "\"");
            } else {
                this.out.print("\"" + visitor.getRunOn().getCanonicalName() + "\"");
            }
            this.out.print(" -> ");
            this.out.println("\"" + visitor.getVisitorSchedulable().getCanonicalName() + "\"");
            this.out.println("[");
            this.out.println("  arrowhead=normal,");
            this.out.println("  color=blue,");
            this.out.println("  ltail=\"cluster_" + visitor.getRunOn().getCanonicalName() + "\"");
            this.out.println("];");
            this.out.println();
            if (this.typeAtLeastUseBy.get(visitor.getRunOnAfter()) == null) {
                this.out.println("subgraph \"cluster_" + visitor.getRunOnAfter().getCanonicalName() + "\"");
                this.out.println("{");
                this.out.println("  label=\"" + visitor.getRunOnAfter().getSimpleName() + "\";");
                this.out.println("  color=blue;");
                this.out.println("  fontcolor = blue;");
                this.out.println("  \"" + visitor.getRunOnAfter().getCanonicalName() + "\"");
                this.out.println("  [");
                this.out.println("    shape=point,");
                this.out.println("  ];");
                this.out.println("}");
                this.out.println();
            }
            this.out.print("\"" + visitor.getVisitorSchedulable().getCanonicalName() + "\"");
            this.out.print(" -> ");
            if (this.typeAtLeastUseBy.get(visitor.getRunOnAfter()) != null) {
                this.out.println("\"" + this.typeAtLeastUseBy.get(visitor.getRunOnAfter()).getRunnableSchedulable().getCanonicalName() + "\"");
            } else {
                this.out.println("\"" + visitor.getRunOnAfter().getCanonicalName() + "\"");
            }
            this.out.println("[");
            this.out.println("  arrowhead=normal,");
            this.out.println("  color=blue,");
            this.out.println("  lhead=\"cluster_" + visitor.getRunOnAfter().getCanonicalName() + "\"");
            this.out.println("];");
            this.out.println();
        }
        this.out.println("}");
        this.out.close();
    }
}

