/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.stream;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.LineSeparator;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Formatter;
import java.util.Locale;

public class CustomPrintWriter
extends PrintWriter {
    private boolean autoFlush = false;
    @CheckForNull
    private Formatter formatter = null;
    @Nonnull
    private final String newLine;
    @CheckForNull
    private IOException pendingFirstException = null;

    public CustomPrintWriter(@Nonnull Writer out) {
        this(out, LineSeparator.SYSTEM.getLineSeparator());
    }

    public CustomPrintWriter(@Nonnull Writer out, @Nonnull String lineSeparator) {
        this(out, lineSeparator, false);
    }

    public CustomPrintWriter(@Nonnull Writer out, @Nonnull String lineSeparator, boolean autoFlush) {
        super(out, autoFlush);
        this.autoFlush = autoFlush;
        this.newLine = lineSeparator;
    }

    private void manageException(@Nonnull IOException e) {
        if (this.pendingFirstException == null) {
            this.pendingFirstException = e;
            super.setError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.ensureOpen();
                this.out.flush();
            }
            catch (IOException e) {
                this.manageException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.out == null) {
                    return;
                }
                this.out.close();
                this.out = null;
            }
            catch (IOException e) {
                this.manageException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int c) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.ensureOpen();
                this.out.write(c);
            }
            catch (InterruptedIOException e) {
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                this.manageException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] buf, int off, int len) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.ensureOpen();
                this.out.write(buf, off, len);
            }
            catch (InterruptedIOException e) {
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                this.manageException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String s, int off, int len) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.ensureOpen();
                this.out.write(s, off, len);
            }
            catch (InterruptedIOException e) {
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                this.manageException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.ensureOpen();
                this.newLine();
            }
            catch (InterruptedIOException e) {
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                this.manageException(e);
            }
        }
    }

    @Override
    public void println(boolean b) {
        this.println(String.valueOf(b));
    }

    @Override
    public void println(char c) {
        this.println(String.valueOf(c));
    }

    @Override
    public void println(int i) {
        this.println(String.valueOf(i));
    }

    @Override
    public void println(long l) {
        this.println(String.valueOf(l));
    }

    @Override
    public void println(float f) {
        this.println(String.valueOf(f));
    }

    @Override
    public void println(double d) {
        this.println(String.valueOf(d));
    }

    @Override
    public void println(Object obj) {
        this.println(String.valueOf(obj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(char[] ac) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.print(ac);
                this.newLine();
            }
            catch (InterruptedIOException e) {
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                this.manageException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(String string) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.print(string);
                this.newLine();
            }
            catch (InterruptedIOException e) {
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                this.manageException(e);
            }
        }
    }

    private void newLine() throws IOException {
        this.out.write(this.newLine);
        if (this.autoFlush) {
            this.out.flush();
        }
    }

    @Override
    @Nonnull
    public PrintWriter format(String format, Object ... args) {
        this.format(Locale.getDefault(), format, args);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public PrintWriter format(Locale locale, String format, Object ... args) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.ensureOpen();
                this.ensureFormatter(locale);
                assert (this.formatter != null);
                this.formatter.format(locale, format, args);
                if (this.autoFlush) {
                    this.out.flush();
                }
            }
            catch (InterruptedIOException e) {
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                this.manageException(e);
            }
        }
        return this;
    }

    private void ensureFormatter(@Nonnull Locale locale) {
        if (this.formatter == null || this.formatter.locale() != locale) {
            this.formatter = new Formatter(this, locale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkError() {
        Object object = this.lock;
        synchronized (object) {
            if (this.out != null) {
                this.flush();
            }
            return this.pendingFirstException != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearError() {
        Object object = this.lock;
        synchronized (object) {
            this.pendingFirstException = null;
            super.clearError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throwPendingException() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.pendingFirstException != null) {
                IOException pending = this.pendingFirstException;
                this.clearError();
                throw pending;
            }
        }
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Writer already closed");
        }
    }
}

