/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotDeleteFileException;
import com.android.sched.util.file.CannotGetModificationTimeException;
import com.android.sched.util.file.CannotReadException;
import com.android.sched.util.file.CannotWriteException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.Location;
import com.android.sched.vfs.BaseVDir;
import com.android.sched.vfs.BaseVElement;
import com.android.sched.vfs.BaseVFS;
import com.android.sched.vfs.VFile;
import com.android.sched.vfs.VPath;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.attribute.FileTime;

abstract class BaseVFile
extends BaseVElement
implements VFile {
    public BaseVFile(@Nonnull BaseVFS<? extends BaseVDir, ? extends BaseVFile> vfs, @Nonnull String name) {
        super(vfs, name);
    }

    @Override
    @Nonnull
    public InputStream getInputStream() throws WrongPermissionException {
        return this.vfs.openRead(this);
    }

    @Override
    public boolean isVDir() {
        return false;
    }

    @Override
    @Nonnull
    public OutputStream getOutputStream() throws WrongPermissionException {
        return this.getOutputStream(false);
    }

    @Override
    @Nonnull
    public OutputStream getOutputStream(boolean append) throws WrongPermissionException {
        return this.vfs.openWrite(this, append);
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return this.vfs.getVFileLocation(this);
    }

    @Override
    @CheckForNull
    public String getDigest() {
        return null;
    }

    @Override
    @Nonnull
    public FileTime getLastModified() throws CannotGetModificationTimeException {
        return this.vfs.getLastModified(this);
    }

    @Override
    public void delete() throws CannotDeleteFileException {
        this.vfs.delete(this);
    }

    @Override
    @Nonnull
    public VPath getPathFromRoot() {
        return this.vfs.getPathFromRoot(this);
    }

    @Nonnull
    public String toString() {
        return this.getPathFromRoot().getPathAsString('/') + " (" + this.getLocation().getDescription() + ')';
    }

    @Override
    public void copy(@Nonnull VFile vFile) throws WrongPermissionException, CannotCloseException, CannotReadException, CannotWriteException {
        this.vfs.copy(vFile, this);
    }
}

