/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.location.Location;
import com.android.sched.vfs.GenericInputVFile;
import com.android.sched.vfs.InputVDir;
import com.android.sched.vfs.InputVElement;
import com.android.sched.vfs.InputVFile;
import com.android.sched.vfs.VDir;
import com.android.sched.vfs.VElement;
import com.android.sched.vfs.VFile;
import com.android.sched.vfs.VPath;
import java.util.ArrayList;
import java.util.Collection;

public class GenericInputVDir
implements InputVDir {
    @Nonnull
    private final VDir dir;

    GenericInputVDir(@Nonnull VDir dir) {
        this.dir = dir;
    }

    @Override
    public boolean isVDir() {
        return true;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.dir.getName();
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return this.dir.getLocation();
    }

    @Override
    @Nonnull
    public Collection<? extends InputVElement> list() {
        Collection<? extends VElement> vElements = this.dir.list();
        ArrayList<InputVElement> inputVElements = new ArrayList<InputVElement>(vElements.size());
        for (VElement vElement : vElements) {
            if (vElement.isVDir()) {
                inputVElements.add(new GenericInputVDir((VDir)vElement));
                continue;
            }
            inputVElements.add(new GenericInputVFile((VFile)vElement));
        }
        return inputVElements;
    }

    @Override
    @Nonnull
    public InputVDir getInputVDir(@Nonnull VPath path) throws NotDirectoryException, NoSuchFileException {
        return new GenericInputVDir(this.dir.getVDir(path));
    }

    @Override
    @Nonnull
    public InputVFile getInputVFile(@Nonnull VPath path) throws NotFileException, NoSuchFileException, NotDirectoryException {
        return new GenericInputVFile(this.dir.getVFile(path));
    }
}

