/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.HasDescription;
import com.android.sched.util.codec.DirectDirOutputVFSCodec;
import com.android.sched.util.codec.OutputVFSCodec;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.config.category.Category;
import com.android.sched.util.config.expression.BooleanExpression;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.vfs.OutputVFS;

public class OutputVFSPropertyId
extends PropertyId<OutputVFS>
implements HasDescription {
    @Nonnull
    public static OutputVFSPropertyId create(@Nonnull String name, @Nonnull String description, @Nonnull DirectDirOutputVFSCodec codec) {
        return new OutputVFSPropertyId(name, description, codec);
    }

    @Nonnull
    public static OutputVFSPropertyId create(@Nonnull String name, @Nonnull String description, @Nonnull OutputVFSCodec codec) {
        return new OutputVFSPropertyId(name, description, codec);
    }

    protected OutputVFSPropertyId(@Nonnull String name, @Nonnull String description, @Nonnull StringCodec<OutputVFS> codec) {
        super(name, description, codec);
        this.withAutoCheck();
    }

    @Nonnull
    public OutputVFSPropertyId addDefaultValue(@Nonnull String defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Nonnull
    public OutputVFSPropertyId addDefaultValue(@Nonnull OutputVFS defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Override
    @Nonnull
    public OutputVFSPropertyId requiredIf(@Nonnull BooleanExpression expression) {
        super.requiredIf(expression);
        return this;
    }

    @Nonnull
    public OutputVFSPropertyId addCategory(@Nonnull Class<? extends Category> category) {
        super.addCategory((Class)category);
        return this;
    }

    @Override
    @Nonnull
    public OutputVFSPropertyId addCategory(@Nonnull Category category) {
        super.addCategory(category);
        return this;
    }

    @Nonnull
    public OutputVFSPropertyId withAutoCheck() {
        this.setShutdownHook(new PropertyId.ShutdownRunnable<OutputVFS>(){

            @Override
            public void run(@Nonnull OutputVFS vfs) {
                if (!vfs.isClosed()) {
                    throw new AssertionError((Object)("OutputVFS in " + vfs.getLocation().getDescription() + " from property '" + OutputVFSPropertyId.this.getName() + "' is not closed"));
                }
            }
        });
        return this;
    }

    @Nonnull
    public OutputVFSPropertyId withoutAutoAction() {
        this.removeShutdownHook();
        return this;
    }
}

