/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.jill.google.common.base.Splitter;
import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotDeleteFileException;
import com.android.sched.util.file.CannotGetModificationTimeException;
import com.android.sched.util.file.InputZipFile;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.location.HasLocation;
import com.android.sched.util.location.Location;
import com.android.sched.util.location.ZipLocation;
import com.android.sched.vfs.BaseVDir;
import com.android.sched.vfs.BaseVElement;
import com.android.sched.vfs.BaseVFS;
import com.android.sched.vfs.BaseVFile;
import com.android.sched.vfs.Capabilities;
import com.android.sched.vfs.InMemoryVDir;
import com.android.sched.vfs.VFS;
import com.android.sched.vfs.VFSStatCategory;
import com.android.sched.vfs.VPath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ReadZipFS
extends BaseVFS<ZipVDir, ZipVFile>
implements VFS {
    @Nonnull
    private static final Splitter splitter = Splitter.on('/');
    @Nonnull
    private static final Set<Capabilities> CAPABILITIES = Collections.unmodifiableSet(EnumSet.of(Capabilities.READ, Capabilities.PARALLEL_READ, Capabilities.CASE_SENSITIVE));
    @Nonnull
    private final ZipVDir root = new ZipVDir(this, new ZipEntry(""), "");
    @Nonnull
    private final InputZipFile inputZipFile;
    @Nonnull
    private final ZipFile zipFile;
    @CheckForNull
    private String infoString;

    public ReadZipFS(@Nonnull InputZipFile zipFile) {
        this.inputZipFile = zipFile;
        this.zipFile = zipFile.getZipFile();
        this.loadSubElements();
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "zip archive reader";
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return this.inputZipFile.getLocation();
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.inputZipFile.getPath();
    }

    @Override
    @Nonnull
    public ZipVDir getRootDir() {
        return this.root;
    }

    @Override
    public synchronized void close() throws CannotCloseException {
        if (!this.closed) {
            try {
                this.zipFile.close();
            }
            catch (IOException e) {
                throw new CannotCloseException((HasLocation)this, (Exception)e);
            }
            this.closed = true;
        }
    }

    @Override
    @Nonnull
    InputStream openRead(@Nonnull ZipVFile file) {
        try {
            VFSStatCategory.ZIP_READ.getCounterStat(this.getTracer(), this.infoString).incValue();
            return this.zipFile.getInputStream(file.getZipEntry());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @Nonnull
    OutputStream openWrite(@Nonnull ZipVFile file) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    OutputStream openWrite(@Nonnull ZipVFile file, boolean append) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    ZipVDir getVDir(@Nonnull ZipVDir parent, @Nonnull String name) throws NotDirectoryException, NoSuchFileException {
        BaseVElement element = parent.getFromCache(name);
        if (element != null) {
            if (element.isVDir()) {
                return (ZipVDir)element;
            }
            throw new NotDirectoryException(this.getVDirLocation(parent, name));
        }
        throw new NoSuchFileException(this.getVDirLocation(parent, name));
    }

    @Override
    @Nonnull
    ZipVFile getVFile(@Nonnull ZipVDir parent, @Nonnull String name) throws NotFileException, NoSuchFileException {
        BaseVElement element = parent.getFromCache(name);
        if (element != null) {
            if (!element.isVDir()) {
                return (ZipVFile)element;
            }
            throw new NotFileException(this.getVFileLocation(parent, name));
        }
        throw new NoSuchFileException(this.getVFileLocation(parent, name));
    }

    @Override
    @Nonnull
    ZipVDir createVDir(@Nonnull ZipVDir parent, @Nonnull String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    ZipVFile createVFile(@Nonnull ZipVDir parent, @Nonnull String name) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    private synchronized ZipVDir loadVDir(@Nonnull ZipVDir parent, @Nonnull String name) {
        ZipVDir vDir = (ZipVDir)parent.getFromCache(name);
        if (vDir == null) {
            vDir = new ZipVDir(this, new ZipEntry(parent.getZipEntry().getName() + name + '/'), name);
            parent.putInCache(name, vDir);
        }
        return vDir;
    }

    @Nonnull
    private ZipVFile loadVFile(@Nonnull ZipVDir parent, @Nonnull String name) {
        ZipVFile vFile = new ZipVFile(this, this.zipFile.getEntry(parent.getZipEntry().getName() + name), name);
        parent.putInCache(name, vFile);
        return vFile;
    }

    @Override
    @Nonnull
    void delete(@Nonnull ZipVFile file) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    Collection<? extends BaseVElement> list(@Nonnull ZipVDir dir) {
        return dir.getAllFromCache();
    }

    @Override
    boolean isEmpty(@Nonnull ZipVDir dir) {
        return dir.isEmpty();
    }

    @Override
    @Nonnull
    FileTime getLastModified(@Nonnull ZipVFile file) throws CannotGetModificationTimeException {
        return this.inputZipFile.getLastModified();
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull ZipVFile file) {
        return new ZipLocation(this.inputZipFile.getLocation(), file.getZipEntry());
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull ZipVDir parent, @Nonnull String name) {
        return new ZipLocation(this.inputZipFile.getLocation(), new ZipEntry(parent.getZipEntry().getName() + name));
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull ZipVDir dir) {
        return new ZipLocation(this.inputZipFile.getLocation(), dir.getZipEntry());
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull ZipVDir parent, @Nonnull String name) {
        return new ZipLocation(this.inputZipFile.getLocation(), new ZipEntry(parent.getZipEntry().getName() + name + '/'));
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull ZipVDir parent, @Nonnull VPath path) {
        return new ZipLocation(this.inputZipFile.getLocation(), new ZipEntry(parent.getZipEntry().getName() + path.getPathAsString('/')));
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull ZipVDir parent, @Nonnull VPath path) {
        return new ZipLocation(this.inputZipFile.getLocation(), new ZipEntry(parent.getZipEntry().getName() + path.getPathAsString('/') + '/'));
    }

    @Override
    public boolean needsSequentialWriting() {
        return false;
    }

    @Override
    @Nonnull
    public Set<Capabilities> getCapabilities() {
        return CAPABILITIES;
    }

    private void loadSubElements() {
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String entryName = entry.getName();
            ZipVDir currentDir = this.getRootDir();
            Iterator<String> names = splitter.split(entryName).iterator();
            String simpleName = null;
            while (names.hasNext()) {
                simpleName = names.next();
                assert (!simpleName.isEmpty());
                if (!names.hasNext()) continue;
                currentDir = this.loadVDir(currentDir, simpleName);
            }
            this.loadVFile(currentDir, simpleName);
        }
    }

    @Override
    @Nonnull
    VPath getPathFromDir(@Nonnull ZipVDir parent, @Nonnull ZipVFile file) {
        String fileEntryPath = file.getZipEntry().getName();
        String parentEntryPath = parent.getZipEntry().getName();
        assert (fileEntryPath.startsWith(parentEntryPath));
        String newPath = fileEntryPath.substring(parentEntryPath.length());
        return new VPath(newPath, '/');
    }

    @Override
    @Nonnull
    VPath getPathFromRoot(@Nonnull ZipVFile file) {
        return this.getPathFromDir(this.root, file);
    }

    public void setInfoString(@CheckForNull String infoString) {
        this.infoString = infoString;
    }

    @Override
    public String getInfoString() {
        return this.infoString;
    }

    public String toString() {
        return "rZipFS: " + this.getLocation().getDescription();
    }

    static class ZipVFile
    extends BaseVFile {
        @Nonnull
        private final ZipEntry zipEntry;

        ZipVFile(@Nonnull BaseVFS<? extends ZipVDir, ? extends ZipVFile> vfs, @Nonnull ZipEntry zipEntry, @Nonnull String name) {
            super(vfs, name);
            this.zipEntry = zipEntry;
        }

        @Nonnull
        public ZipEntry getZipEntry() {
            return this.zipEntry;
        }

        @Override
        @Nonnull
        public VPath getPath() {
            return new VPath(this.zipEntry.getName(), '/');
        }

        @Override
        public void delete() throws CannotDeleteFileException {
            this.vfs.delete(this);
        }
    }

    static class ZipVDir
    extends InMemoryVDir {
        @Nonnull
        private final ZipEntry zipEntry;

        ZipVDir(@Nonnull BaseVFS<? extends ZipVDir, ? extends ZipVFile> vfs, @Nonnull ZipEntry zipEntry, @Nonnull String name) {
            super((BaseVFS<? extends InMemoryVDir, ? extends BaseVFile>)vfs, name);
            this.zipEntry = zipEntry;
        }

        @Nonnull
        public ZipEntry getZipEntry() {
            return this.zipEntry;
        }

        @Override
        @Nonnull
        public VPath getPath() {
            return new VPath(this.zipEntry.getName(), '/');
        }

        @Override
        @Nonnull
        public BaseVFile getVFile(@Nonnull String name) throws NoSuchFileException, NotFileException {
            return this.vfs.getVFile(this, name);
        }

        @Override
        @Nonnull
        public BaseVDir getVDir(@Nonnull String name) throws NotDirectoryException, NoSuchFileException {
            return this.vfs.getVDir(this, name);
        }

        @Override
        @Nonnull
        public BaseVFile createVFile(@Nonnull String name) throws CannotCreateFileException {
            return this.vfs.createVFile(this, name);
        }

        @Override
        @Nonnull
        public BaseVDir createVDir(@Nonnull String name) throws CannotCreateFileException {
            return this.vfs.createVDir(this, name);
        }

        @Override
        @Nonnull
        public Collection<? extends BaseVElement> list() {
            return this.vfs.list(this);
        }
    }
}

