/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.HasDescription;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.codec.VFSCodec;
import com.android.sched.util.config.category.Category;
import com.android.sched.util.config.expression.BooleanExpression;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.file.Statusful;
import com.android.sched.util.file.StreamFileStatus;
import com.android.sched.vfs.VFS;

public class VFSPropertyId
extends PropertyId<VFS>
implements HasDescription {
    @Nonnull
    public static VFSPropertyId create(@Nonnull String name, @Nonnull String description, @Nonnull VFSCodec codec) {
        return new VFSPropertyId(name, description, codec);
    }

    protected VFSPropertyId(@Nonnull String name, @Nonnull String description, @Nonnull StringCodec<VFS> codec) {
        super(name, description, codec);
        this.withAutoCheck();
    }

    @Nonnull
    public VFSPropertyId addDefaultValue(@Nonnull String defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Nonnull
    public VFSPropertyId addDefaultValue(@Nonnull VFS defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Override
    @Nonnull
    public VFSPropertyId requiredIf(@Nonnull BooleanExpression expression) {
        super.requiredIf(expression);
        return this;
    }

    @Nonnull
    public VFSPropertyId addCategory(@Nonnull Class<? extends Category> category) {
        super.addCategory((Class)category);
        return this;
    }

    @Override
    @Nonnull
    public VFSPropertyId addCategory(@Nonnull Category category) {
        super.addCategory(category);
        return this;
    }

    @Nonnull
    public VFSPropertyId withAutoCheck() {
        this.setShutdownHook(new PropertyId.ShutdownRunnable<VFS>(){

            @Override
            public void run(@Nonnull VFS vfs) {
                boolean open;
                if (vfs instanceof Statusful) {
                    open = ((Statusful)((Object)vfs)).getStatus() == StreamFileStatus.OPEN;
                } else {
                    boolean bl = open = !vfs.isClosed();
                }
                if (open) {
                    throw new AssertionError((Object)("VFS '" + vfs.getDescription() + "' in " + vfs.getLocation().getDescription() + " from property '" + VFSPropertyId.this.getName() + "' is not closed"));
                }
            }
        });
        return this;
    }

    @Nonnull
    public VFSPropertyId withoutAutoAction() {
        this.removeShutdownHook();
        return this;
    }
}

