/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotDeleteFileException;
import com.android.sched.util.file.CannotGetModificationTimeException;
import com.android.sched.util.file.CannotReadException;
import com.android.sched.util.file.CannotWriteException;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.HasLocation;
import com.android.sched.util.location.Location;
import com.android.sched.util.stream.LocationByteStreamSucker;
import com.android.sched.vfs.BaseVDir;
import com.android.sched.vfs.BaseVElement;
import com.android.sched.vfs.BaseVFS;
import com.android.sched.vfs.BaseVFile;
import com.android.sched.vfs.Capabilities;
import com.android.sched.vfs.VDir;
import com.android.sched.vfs.VElement;
import com.android.sched.vfs.VFS;
import com.android.sched.vfs.VFile;
import com.android.sched.vfs.VPath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class VFSToVFSWrapper
extends BaseVFS<BaseVDir, BaseVFile>
implements VFS {
    @Nonnull
    private BaseVFS<BaseVDir, BaseVFile> workVFS;
    @Nonnull
    private final BaseVFS<BaseVDir, BaseVFile> finalVFS;
    @Nonnull
    private final Set<Capabilities> capabilities;

    public VFSToVFSWrapper(@Nonnull VFS workVFS, @Nonnull VFS finalVFS) {
        this.workVFS = (BaseVFS)workVFS;
        this.finalVFS = (BaseVFS)finalVFS;
        EnumSet<Capabilities> capabilities = EnumSet.noneOf(Capabilities.class);
        block9: for (Capabilities capability : workVFS.getCapabilities()) {
            switch (capability) {
                case CASE_SENSITIVE: {
                    if (!finalVFS.getCapabilities().contains((Object)capability)) continue block9;
                    capabilities.add(capability);
                    continue block9;
                }
                case DIGEST: {
                    capabilities.add(capability);
                    continue block9;
                }
                case PARALLEL_READ: {
                    capabilities.add(capability);
                    continue block9;
                }
                case PARALLEL_WRITE: {
                    capabilities.add(capability);
                    continue block9;
                }
                case READ: {
                    capabilities.add(capability);
                    continue block9;
                }
                case UNIQUE_ELEMENT: {
                    capabilities.add(capability);
                    continue block9;
                }
                case WRITE: {
                    capabilities.add(capability);
                    continue block9;
                }
            }
            throw new AssertionError();
        }
        this.capabilities = Collections.unmodifiableSet(capabilities);
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return this.finalVFS.getLocation();
    }

    @Override
    public void close() throws CannotCloseException {
        if (!this.closed) {
            try {
                this.dumpToDir(this.getRootDir(), this.finalVFS.getRootDir());
                this.finalVFS.close();
                this.workVFS.close();
                this.closed = true;
            }
            catch (CannotCloseException | CannotCreateFileException | CannotReadException | CannotWriteException | WrongPermissionException e) {
                throw new CannotCloseException((HasLocation)this, (Exception)e);
            }
        }
    }

    private void dumpToDir(VDir srcRootDir, VDir destRootDir) throws CannotCreateFileException, WrongPermissionException, CannotCloseException, CannotReadException, CannotWriteException {
        for (VElement vElement : srcRootDir.list()) {
            String elementName = vElement.getName();
            if (vElement.isVDir()) {
                VDir dir = destRootDir.createVDir(elementName);
                this.dumpToDir((VDir)vElement, dir);
                continue;
            }
            VFile file = destRootDir.createVFile(elementName);
            try {
                InputStream is = ((VFile)vElement).getInputStream();
                Throwable throwable = null;
                try {
                    try {
                        OutputStream os = file.getOutputStream();
                        Throwable throwable2 = null;
                        try {
                            new LocationByteStreamSucker(is, os, vElement, file).suck();
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (os == null) continue;
                            if (throwable2 != null) {
                                try {
                                    os.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            os.close();
                        }
                    }
                    catch (IOException e) {
                        throw new CannotCloseException((HasLocation)file, (Exception)e);
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException e) {
                throw new CannotCloseException((HasLocation)vElement, (Exception)e);
            }
        }
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "a VFS-to-VFS wrapper";
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.finalVFS.getPath();
    }

    @Override
    @Nonnull
    public BaseVDir getRootDir() {
        return this.workVFS.getRootDir();
    }

    @Override
    public boolean needsSequentialWriting() {
        return this.workVFS.needsSequentialWriting();
    }

    @Override
    @Nonnull
    public Set<Capabilities> getCapabilities() {
        return this.capabilities;
    }

    @Override
    @Nonnull
    InputStream openRead(@Nonnull BaseVFile file) throws WrongPermissionException {
        return this.workVFS.openRead(file);
    }

    @Override
    @Nonnull
    OutputStream openWrite(@Nonnull BaseVFile file) throws WrongPermissionException {
        return this.openWrite(file, false);
    }

    @Override
    @Nonnull
    OutputStream openWrite(@Nonnull BaseVFile file, boolean append) throws WrongPermissionException {
        return this.workVFS.openWrite(file, append);
    }

    @Override
    @Nonnull
    BaseVDir getVDir(@Nonnull BaseVDir parent, @Nonnull String name) throws NotDirectoryException, NoSuchFileException {
        return this.workVFS.getVDir(parent, name);
    }

    @Override
    @Nonnull
    BaseVFile getVFile(@Nonnull BaseVDir parent, @Nonnull String name) throws NotFileException, NoSuchFileException {
        return this.workVFS.getVFile(parent, name);
    }

    @Override
    @Nonnull
    BaseVDir createVDir(@Nonnull BaseVDir parent, @Nonnull String name) throws CannotCreateFileException {
        return this.workVFS.createVDir(parent, name);
    }

    @Override
    @Nonnull
    BaseVFile createVFile(@Nonnull BaseVDir parent, @Nonnull String name) throws CannotCreateFileException {
        return this.workVFS.createVFile(parent, name);
    }

    @Override
    @Nonnull
    void delete(@Nonnull BaseVFile file) throws CannotDeleteFileException {
        this.workVFS.delete(file);
    }

    @Override
    @Nonnull
    Collection<? extends BaseVElement> list(@Nonnull BaseVDir dir) {
        return this.workVFS.list(dir);
    }

    @Override
    boolean isEmpty(@Nonnull BaseVDir dir) {
        return this.workVFS.isEmpty(dir);
    }

    @Override
    @Nonnull
    FileTime getLastModified(@Nonnull BaseVFile file) throws CannotGetModificationTimeException {
        return this.workVFS.getLastModified(file);
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull BaseVFile file) {
        return this.workVFS.getVFileLocation(file);
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull BaseVDir parent, @Nonnull String name) {
        return this.workVFS.getVFileLocation(parent, name);
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull BaseVDir parent, @Nonnull VPath path) {
        return this.workVFS.getVFileLocation(parent, path);
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull BaseVDir dir) {
        return this.workVFS.getVDirLocation(dir);
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull BaseVDir parent, @Nonnull String name) {
        return this.workVFS.getVDirLocation(parent, name);
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull BaseVDir parent, @Nonnull VPath path) {
        return this.workVFS.getVDirLocation(parent, path);
    }

    public void setWorkVFS(@Nonnull VFS temporaryVFS) {
        this.workVFS = (BaseVFS)temporaryVFS;
    }

    @Override
    @Nonnull
    VPath getPathFromDir(@Nonnull BaseVDir parent, @Nonnull BaseVFile file) {
        return this.workVFS.getPathFromDir(parent, file);
    }

    @Override
    @Nonnull
    VPath getPathFromRoot(@Nonnull BaseVFile file) {
        return this.workVFS.getPathFromRoot(file);
    }

    @Nonnull
    public VFS getWorkVFS() {
        return this.workVFS;
    }

    @Nonnull
    public VFS getFinalVFS() {
        return this.finalVFS;
    }

    @Override
    @CheckForNull
    public String getInfoString() {
        return this.finalVFS.getInfoString();
    }

    public String toString() {
        return "(workVFS >> " + this.workVFS.toString() + " / finalVFS >> " + this.finalVFS.toString() + ')';
    }
}

