/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.kms;

import com.android.apksig.KeyConfig;
import com.android.apksig.SignerEngine;
import com.android.apksig.kms.KmsException;
import com.android.apksig.kms.KmsType;
import com.android.apksig.kms.aws.AwsSignerEngine;

public abstract class KmsSignerEngine
implements SignerEngine {
    public final KmsType kmsType;
    public final String keyAlias;

    public KmsSignerEngine(KmsType kmsType, String keyAlias) {
        this.kmsType = kmsType;
        this.keyAlias = keyAlias;
    }

    @Override
    public abstract byte[] sign(byte[] var1);

    public static KmsSignerEngine fromKmsConfig(KeyConfig.Kms kmsConfig, String jcaSignatureAlgorithm) {
        switch (kmsConfig.kmsType) {
            case AWS: {
                return new AwsSignerEngine(kmsConfig.keyAlias, jcaSignatureAlgorithm);
            }
        }
        throw new KmsException(kmsConfig.kmsType, "Unsupported KMS");
    }
}

