/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.kms.aws;

import com.android.apksig.kms.KmsException;
import com.android.apksig.kms.KmsSignerEngine;
import com.android.apksig.kms.KmsType;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;
import software.amazon.awssdk.services.kms.model.SignRequest;
import software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec;

public class AwsSignerEngine
extends KmsSignerEngine {
    private static final String ALIAS_PREFIX = "alias/";
    private final SigningAlgorithmSpec mSigningAlgorithmSpec;

    public AwsSignerEngine(String keyAlias, String jcaSignatureAlgorithm) {
        super(KmsType.AWS, keyAlias);
        this.mSigningAlgorithmSpec = AwsSignerEngine.fromJcaSignatureAlgorithm(jcaSignatureAlgorithm);
    }

    @Override
    public byte[] sign(byte[] data) {
        try (KmsClient client = (KmsClient)((KmsClientBuilder)KmsClient.builder().httpClientBuilder((SdkHttpClient.Builder)UrlConnectionHttpClient.builder())).build();){
            byte[] byArray = client.sign((SignRequest)SignRequest.builder().keyId(ALIAS_PREFIX + this.keyAlias).signingAlgorithm(this.mSigningAlgorithmSpec).message(SdkBytes.fromByteArray((byte[])data)).build()).signature().asByteArray();
            return byArray;
        }
    }

    private static SigningAlgorithmSpec fromJcaSignatureAlgorithm(String jcaSignatureAlgorithm) {
        switch (jcaSignatureAlgorithm) {
            case "SHA256withRSA/PSS": {
                return SigningAlgorithmSpec.RSASSA_PSS_SHA_256;
            }
            case "SHA512withRSA/PSS": {
                return SigningAlgorithmSpec.RSASSA_PSS_SHA_512;
            }
            case "SHA256withRSA": {
                return SigningAlgorithmSpec.RSASSA_PKCS1_V1_5_SHA_256;
            }
            case "SHA512withRSA": {
                return SigningAlgorithmSpec.RSASSA_PKCS1_V1_5_SHA_512;
            }
            case "SHA256withECDSA": {
                return SigningAlgorithmSpec.ECDSA_SHA_256;
            }
            case "SHA512withECDSA": {
                return SigningAlgorithmSpec.ECDSA_SHA_512;
            }
        }
        throw new KmsException(KmsType.AWS, "Signature algorithm " + jcaSignatureAlgorithm + " not supported");
    }
}

