/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.EncodedKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.conscrypt.ArrayUtils;
import org.conscrypt.OpenSSLX25519PrivateKey;
import org.conscrypt.OpenSSLX25519PublicKey;
import org.conscrypt.XdhKeySpec;

public final class OpenSSLXDHKeyFactory
extends KeyFactorySpi {
    private static final Class<?> javaXecPublicKeySpec = OpenSSLXDHKeyFactory.getJavaXECPublicKeySpec();
    private static final Class<?> javaXecPrivateKeySpec = OpenSSLXDHKeyFactory.getJavaXECPrivateKeySpec();
    private static final AlgorithmParameterSpec javaX25519AlgorithmSpec = OpenSSLXDHKeyFactory.getJavaX25519ParameterSpec();

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec == null) {
            throw new InvalidKeySpecException("keySpec == null");
        }
        if (keySpec instanceof EncodedKeySpec) {
            return new OpenSSLX25519PublicKey((EncodedKeySpec)keySpec);
        }
        throw new InvalidKeySpecException("Must use XECPublicKeySpec, X509EncodedKeySpec or Raw EncodedKeySpec; was " + keySpec.getClass().getName());
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec == null) {
            throw new InvalidKeySpecException("keySpec == null");
        }
        if (keySpec instanceof EncodedKeySpec) {
            return new OpenSSLX25519PrivateKey((EncodedKeySpec)keySpec);
        }
        throw new InvalidKeySpecException("Must use XECPrivateKeySpec, PKCS8EncodedKeySpec or Raw EncodedKeySpec; was " + keySpec.getClass().getName());
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException {
        if (key == null) {
            throw new InvalidKeySpecException("key == null");
        }
        if (keySpec == null) {
            throw new InvalidKeySpecException("keySpec == null");
        }
        if (!"XDH".equals(key.getAlgorithm()) && !"X25519".equals(key.getAlgorithm())) {
            throw new InvalidKeySpecException("Key must be an XDH or X25519 key");
        }
        if (key.getEncoded() == null) {
            throw new InvalidKeySpecException("Key is destroyed");
        }
        try {
            key = this.engineTranslateKey(key);
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException("Unsupported key class: " + key.getClass(), e);
        }
        if (key instanceof OpenSSLX25519PublicKey) {
            OpenSSLX25519PublicKey conscryptKey = (OpenSSLX25519PublicKey)key;
            if (javaXecPublicKeySpec != null && javaXecPublicKeySpec.isAssignableFrom(keySpec)) {
                KeySpec result = this.constructJavaXecPublicKeySpec(conscryptKey);
                return (T)result;
            }
            if (X509EncodedKeySpec.class.isAssignableFrom(keySpec)) {
                X509EncodedKeySpec result = new X509EncodedKeySpec(key.getEncoded());
                return (T)result;
            }
            if (keySpec == XdhKeySpec.class) {
                XdhKeySpec result = new XdhKeySpec(conscryptKey.getU());
                return (T)result;
            }
            if (EncodedKeySpec.class.isAssignableFrom(keySpec)) {
                return this.makeRawKeySpec(conscryptKey.getU(), keySpec);
            }
        } else if (key instanceof OpenSSLX25519PrivateKey) {
            OpenSSLX25519PrivateKey conscryptKey = (OpenSSLX25519PrivateKey)key;
            if (javaXecPrivateKeySpec != null && javaXecPrivateKeySpec.isAssignableFrom(keySpec)) {
                KeySpec result = this.constructJavaPrivateKeySpec(conscryptKey);
                return (T)result;
            }
            if (PKCS8EncodedKeySpec.class.isAssignableFrom(keySpec)) {
                PKCS8EncodedKeySpec result = new PKCS8EncodedKeySpec(key.getEncoded());
                return (T)result;
            }
            if (keySpec == XdhKeySpec.class) {
                XdhKeySpec result = new XdhKeySpec(conscryptKey.getU());
                return (T)result;
            }
            if (EncodedKeySpec.class.isAssignableFrom(keySpec)) {
                return this.makeRawKeySpec(conscryptKey.getU(), keySpec);
            }
        }
        throw new InvalidKeySpecException("Unsupported key type and key spec combination; key=" + key.getClass().getName() + ", keySpec=" + keySpec.getName());
    }

    private <T extends KeySpec> T makeRawKeySpec(byte[] bytes, Class<T> keySpecClass) throws InvalidKeySpecException {
        try {
            Constructor<T> constructor = keySpecClass.getConstructor(byte[].class);
            KeySpec instance = (KeySpec)constructor.newInstance(new Object[]{bytes});
            EncodedKeySpec spec = (EncodedKeySpec)instance;
            if (!spec.getFormat().equalsIgnoreCase("raw")) {
                throw new InvalidKeySpecException("EncodedKeySpec class must be raw format");
            }
            return (T)instance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new InvalidKeySpecException("Can't process KeySpec class " + keySpecClass.getName(), e);
        }
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("key == null");
        }
        if (key instanceof OpenSSLX25519PublicKey || key instanceof OpenSSLX25519PrivateKey) {
            return key;
        }
        if (key instanceof PrivateKey && "PKCS#8".equals(key.getFormat())) {
            byte[] encoded = key.getEncoded();
            if (encoded == null) {
                throw new InvalidKeyException("Key does not support encoding");
            }
            try {
                return this.engineGeneratePrivate(new PKCS8EncodedKeySpec(encoded));
            }
            catch (InvalidKeySpecException e) {
                throw new InvalidKeyException(e);
            }
        }
        if (key instanceof PublicKey && "X.509".equals(key.getFormat())) {
            byte[] encoded = key.getEncoded();
            if (encoded == null) {
                throw new InvalidKeyException("Key does not support encoding");
            }
            try {
                return this.engineGeneratePublic(new X509EncodedKeySpec(encoded));
            }
            catch (InvalidKeySpecException e) {
                throw new InvalidKeyException(e);
            }
        }
        throw new InvalidKeyException("Key must be XEC public or private key; was " + key.getClass().getName());
    }

    private static Class<?> getJavaXECPrivateKeySpec() {
        try {
            return Class.forName("java.security.spec.XECPrivateKeySpec");
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
    }

    private static Class<?> getJavaXECPublicKeySpec() {
        try {
            return Class.forName("java.security.spec.XECPublicKeySpec");
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
    }

    private static AlgorithmParameterSpec getJavaX25519ParameterSpec() {
        try {
            Class<?> cls = Class.forName("java.security.spec.NamedParameterSpec");
            Field field = cls.getDeclaredField("X25519");
            Object result = field.get(null);
            return (AlgorithmParameterSpec)result;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException ignored) {
            return null;
        }
    }

    private KeySpec constructJavaPrivateKeySpec(OpenSSLX25519PrivateKey privateKey) throws InvalidKeySpecException {
        if (javaXecPrivateKeySpec == null) {
            throw new InvalidKeySpecException("Could not find java.security.spec.XECPrivateKeySpec");
        }
        try {
            Constructor<?> c = javaXecPrivateKeySpec.getConstructor(AlgorithmParameterSpec.class, byte[].class);
            KeySpec result = (KeySpec)c.newInstance(javaX25519AlgorithmSpec, privateKey.getU());
            return result;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new InvalidKeySpecException("Could not find java.security.spec.XECPrivateKeySpec", e);
        }
    }

    private KeySpec constructJavaXecPublicKeySpec(OpenSSLX25519PublicKey publicKey) throws InvalidKeySpecException {
        if (javaXecPublicKeySpec == null) {
            throw new InvalidKeySpecException("Could not find java.security.spec.XECPublicKeySpec");
        }
        try {
            Constructor<?> c = javaXecPublicKeySpec.getConstructor(AlgorithmParameterSpec.class, BigInteger.class);
            KeySpec result = (KeySpec)c.newInstance(javaX25519AlgorithmSpec, new BigInteger(1, ArrayUtils.reverse(publicKey.getU())));
            return result;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new InvalidKeySpecException("Could not find java.security.spec.XECPublicKeySpec", e);
        }
    }
}

