/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt.metrics;

public enum Protocol {
    UNKNOWN_PROTO(0),
    SSLv3(1),
    TLSv1(2),
    TLSv1_1(3),
    TLSv1_2(4),
    TLSv1_3(5),
    TLS_PROTO_FAILED(65535);

    final int id;

    public int getId() {
        return this.id;
    }

    public static Protocol forName(String name) {
        switch (name) {
            case "SSLv3": {
                return SSLv3;
            }
            case "TLSv1": {
                return TLSv1;
            }
            case "TLSv1.1": {
                return TLSv1_1;
            }
            case "TLSv1.2": {
                return TLSv1_2;
            }
            case "TLSv1.3": {
                return TLSv1_3;
            }
            case "TLS_PROTO_FAILED": {
                return TLS_PROTO_FAILED;
            }
        }
        return UNKNOWN_PROTO;
    }

    private Protocol(int id) {
        this.id = id;
    }
}

