/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt.metrics;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.conscrypt.Platform;
import org.conscrypt.ct.LogStore;
import org.conscrypt.metrics.CipherSuite;
import org.conscrypt.metrics.Protocol;
import org.conscrypt.metrics.ReflexiveStatsEvent;
import org.conscrypt.metrics.ReflexiveStatsLog;
import org.conscrypt.metrics.StatsLog;

public final class StatsLogImpl
implements StatsLog {
    public static final int TLS_HANDSHAKE_REPORTED = 317;
    public static final int CERTIFICATE_TRANSPARENCY_LOG_LIST_STATE_CHANGED = 934;
    private static final ExecutorService e = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                }
            });
            return thread;
        }
    });
    private static final StatsLog INSTANCE = new StatsLogImpl();

    private StatsLogImpl() {
    }

    public static StatsLog getInstance() {
        return INSTANCE;
    }

    @Override
    public void countTlsHandshake(boolean success, String protocol, String cipherSuite, long duration) {
        Protocol proto = Protocol.forName(protocol);
        CipherSuite suite = CipherSuite.forName(cipherSuite);
        this.write(317, success, proto.getId(), suite.getId(), (int)duration, Platform.getStatsSource().ordinal(), Platform.getUids());
    }

    private static int logStoreStateToMetricsState(LogStore.State state) {
        boolean METRIC_UNKNOWN = false;
        boolean METRIC_SUCCESS = true;
        int METRIC_NOT_FOUND = 2;
        int METRIC_PARSING_FAILED = 3;
        int METRIC_EXPIRED = 4;
        switch (state) {
            case UNINITIALIZED: 
            case LOADED: {
                return 0;
            }
            case NOT_FOUND: {
                return 2;
            }
            case MALFORMED: {
                return 3;
            }
            case COMPLIANT: {
                return 1;
            }
            case NON_COMPLIANT: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public void updateCTLogListStatusChanged(LogStore logStore) {
        int state = StatsLogImpl.logStoreStateToMetricsState(logStore.getState());
        this.write(934, state, logStore.getCompatVersion(), logStore.getMinCompatVersionAvailable(), logStore.getMajorVersion(), logStore.getMinorVersion());
    }

    private void write(final int atomId, final boolean success, final int protocol, final int cipherSuite, final int duration, final int source, final int[] uids) {
        e.execute(new Runnable(){

            @Override
            public void run() {
                ReflexiveStatsEvent event = ReflexiveStatsEvent.buildEvent(atomId, success, protocol, cipherSuite, duration, source, uids);
                ReflexiveStatsLog.write(event);
            }
        });
    }

    private void write(final int atomId, final int status, final int loadedCompatVersion, final int minCompatVersionAvailable, final int majorVersion, final int minorVersion) {
        e.execute(new Runnable(){

            @Override
            public void run() {
                ReflexiveStatsEvent.Builder builder = ReflexiveStatsEvent.newBuilder();
                builder.setAtomId(atomId);
                builder.writeInt(status);
                builder.writeInt(loadedCompatVersion);
                builder.writeInt(minCompatVersionAvailable);
                builder.writeInt(majorVersion);
                builder.writeInt(minorVersion);
                builder.usePooledBuffer();
                ReflexiveStatsLog.write(builder.build());
            }
        });
    }
}

