/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8wrappers;

import com.android.tools.r8.AndroidResourceInput;
import com.android.tools.r8.ArchiveProtoAndroidResourceConsumer;
import com.android.tools.r8.ArchiveProtoAndroidResourceProvider;
import com.android.tools.r8.BaseCompilerCommand;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.DiagnosticsLevel;
import com.android.tools.r8.ParseFlagInfo;
import com.android.tools.r8.ParseFlagPrinter;
import com.android.tools.r8.R8;
import com.android.tools.r8.R8Command;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.ResourcePath;
import com.android.tools.r8.Version;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8wrappers.utils.DepsFileWriter;
import com.android.tools.r8wrappers.utils.WrapperDiagnosticsHandler;
import com.android.tools.r8wrappers.utils.WrapperFlag;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class R8Wrapper {
    private static final String WRAPPER_STRING = "r8-aosp-wrapper";
    private static final Origin CLI_ORIGIN = new Origin(Origin.root()){

        @Override
        public String part() {
            return R8Wrapper.WRAPPER_STRING;
        }
    };
    private WrapperDiagnosticsHandler diagnosticsHandler = new WrapperDiagnosticsHandler();
    private boolean useCompatPg = false;
    private Path depsOutput = null;
    private Path resourceInput = null;
    private Path resourceOutput = null;
    private final List<String> pgRules = new ArrayList<String>();
    private boolean printInfoDiagnostics = false;
    private boolean dontOptimize = false;
    private boolean optimizingResourceShrinking = false;
    private boolean forceOptimizingResourceShrinking = false;
    private boolean noImplicitDefaultInit = false;

    private static List<ParseFlagInfo> getAdditionalFlagsInfo() {
        return Arrays.asList(new WrapperFlag("--deps-file <file>", "Write input dependencies to <file>."), new WrapperFlag("--info", "Print the info-level log messages from the compiler."), new WrapperFlag("--resource-input", "Resource input for the resource shrinker."), new WrapperFlag("--resource-output", "Resource shrinker output."), new WrapperFlag("--optimized-resource-shrinking", "Use R8 optimizing resource pipeline."), new WrapperFlag("--no-implicit-default-init", "Disable compat-mode behavior of keeping default constructors in full mode."));
    }

    private static String getUsageMessage() {
        StringBuilder builder = R8Wrapper.appendLines(new StringBuilder(), "Usage: r8 [options] [@<argfile>] <input-files>", " where <input-files> are any combination of class, zip, or jar files", " and each <argfile> is a file containing additional arguments (one per line)", " and options are:");
        new ParseFlagPrinter().addFlags(R8Command.getParseFlagsInformation()).addFlags(R8Wrapper.getAdditionalFlagsInfo()).setIndent(2).appendLinesToBuilder(builder);
        return builder.toString();
    }

    private static StringBuilder appendLines(StringBuilder builder, String ... lines) {
        for (String line : lines) {
            builder.append(line).append(System.lineSeparator());
        }
        return builder;
    }

    public static void main(String[] args) throws CompilationFailedException {
        R8Command.Builder builder;
        System.setProperty("com.android.tools.r8.disableEnqueuerDeferredTracing", "1");
        System.setProperty("com.android.tools.r8.enableSameFilePolicy", "1");
        System.setProperty("com.android.tools.r8.experimental.enablewhyareyounotinlining", "1");
        System.setProperty("com.android.tools.r8.experimental.enableconvertchecknotnull", "1");
        R8Wrapper wrapper = new R8Wrapper();
        String[] remainingArgs = wrapper.parseWrapperArguments(args);
        if (!wrapper.useCompatPg && !wrapper.noImplicitDefaultInit) {
            System.setProperty("com.android.tools.r8.enableEmptyMemberRulesToDefaultInitRuleConversion", "1");
        }
        if ((builder = R8Command.parse(remainingArgs, CLI_ORIGIN, wrapper.diagnosticsHandler)).isPrintHelp()) {
            System.out.println(R8Wrapper.getUsageMessage());
            return;
        }
        if (builder.isPrintVersion()) {
            System.out.println("R8(r8-aosp-wrapper) " + Version.getVersionString());
            return;
        }
        wrapper.applyWrapperArguments(builder);
        R8Wrapper.applyCommonCompilerArguments(builder);
        builder.setEnableExperimentalKeepAnnotations(true);
        R8.run((R8Command)builder.build());
    }

    private String[] parseWrapperArguments(String[] args) {
        ArrayList<String> remainingArgs = new ArrayList<String>();
        block36: for (int i11 = 0; i11 < args.length; ++i11) {
            String arg;
            switch (arg = args[i11]) {
                case "--info": {
                    this.printInfoDiagnostics = true;
                    continue block36;
                }
                case "--resource-input": {
                    if (this.resourceInput != null) {
                        throw new RuntimeException("Only one --resource-input flag accepted");
                    }
                    String nextArg = args[++i11];
                    this.resourceInput = Paths.get(nextArg, new String[0]);
                    continue block36;
                }
                case "--resource-output": {
                    if (this.resourceOutput != null) {
                        throw new RuntimeException("Only one --resource-output flag accepted");
                    }
                    String nextArg = args[++i11];
                    this.resourceOutput = Paths.get(nextArg, new String[0]);
                    continue block36;
                }
                case "--optimized-resource-shrinking": {
                    this.optimizingResourceShrinking = true;
                    continue block36;
                }
                case "--force-optimized-resource-shrinking": {
                    this.forceOptimizingResourceShrinking = true;
                    continue block36;
                }
                case "--no-implicit-default-init": {
                    this.noImplicitDefaultInit = true;
                    continue block36;
                }
                case "--deps-file": {
                    String nextArg = args[++i11];
                    this.depsOutput = Paths.get(nextArg, new String[0]);
                    continue block36;
                }
                case "--multi-dex": {
                    continue block36;
                }
                case "--force-proguard-compatibility": {
                    this.useCompatPg = true;
                    continue block36;
                }
                case "-dontshrink": 
                case "-dontobfuscate": 
                case "-ignorewarnings": {
                    this.pgRules.add(arg);
                    continue block36;
                }
                case "-dontoptimize": {
                    this.dontOptimize = true;
                    this.pgRules.add(arg);
                    continue block36;
                }
                case "-injars": 
                case "-libraryjars": 
                case "-include": 
                case "-printmapping": 
                case "-printconfiguration": 
                case "-printusage": 
                case "-printseeds": {
                    this.pgRules.add(arg + " " + args[++i11]);
                    continue block36;
                }
                default: {
                    remainingArgs.add(arg);
                }
            }
        }
        return remainingArgs.toArray(new String[0]);
    }

    private void applyWrapperArguments(R8Command.Builder builder) {
        this.diagnosticsHandler.setPrintInfoDiagnostics(this.printInfoDiagnostics);
        if (!this.dontOptimize) {
            this.diagnosticsHandler.setDuplicateTypesDiagnosticsLevel(DiagnosticsLevel.WARNING);
        }
        if (this.depsOutput != null) {
            Path codeOutput = builder.getOutputPath();
            Path target = Files.isDirectory(codeOutput, new LinkOption[0]) ? codeOutput.resolve("classes.dex") : codeOutput;
            builder.setInputDependencyGraphConsumer(new DepsFileWriter(target, this.depsOutput.toString()));
        }
        if (this.resourceInput != null && this.resourceOutput != null) {
            builder.setAndroidResourceProvider(new AOSPResourceProvider(this.resourceInput, new PathOrigin(this.resourceInput)));
            builder.setAndroidResourceConsumer(new ArchiveProtoAndroidResourceConsumer(this.resourceOutput, this.resourceInput));
            if (this.optimizingResourceShrinking) {
                builder.setResourceShrinkerConfiguration(b11 -> b11.enableOptimizedShrinkingWithR8().build());
                if (!this.forceOptimizingResourceShrinking) {
                    builder.addProguardConfiguration(List.of("-keep class **.R$id {<fields>;}"), CLI_ORIGIN);
                }
            }
        } else if (this.resourceOutput != null || this.resourceInput != null) {
            throw new RuntimeException("Both --resource-input and --resource-output must be specified");
        }
        if (!this.pgRules.isEmpty()) {
            builder.addProguardConfiguration(this.pgRules, CLI_ORIGIN);
        }
        if (this.useCompatPg) {
            builder.setProguardCompatibility(this.useCompatPg);
        }
    }

    public static void applyCommonCompilerArguments(BaseCompilerCommand.Builder<?, ?> builder) {
        if (!builder.getAndroidPlatformBuild()) {
            System.setProperty("com.android.tools.r8.disableApiModeling", "1");
        }
    }

    private static class AOSPResourceProvider
    extends ArchiveProtoAndroidResourceProvider {
        final String defaultXmlRules = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<resources xmlns:tools=\"http://schemas.android.com/tools\"\n    tools:shrinkMode=\"strict\"\n    tools:keep=\"@id/*\"\n/>\n";
        final AndroidResourceInput defaultRules = new AndroidResourceInput(this){

            @Override
            public ResourcePath getPath() {
                return new ResourcePath(this){

                    @Override
                    public String location() {
                        return "res/raw/asop_default.xml";
                    }
                };
            }

            @Override
            public AndroidResourceInput.Kind getKind() {
                return AndroidResourceInput.Kind.KEEP_RULE_FILE;
            }

            @Override
            public InputStream getByteStream() throws ResourceException {
                return new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<resources xmlns:tools=\"http://schemas.android.com/tools\"\n    tools:shrinkMode=\"strict\"\n    tools:keep=\"@id/*\"\n/>\n".getBytes(StandardCharsets.UTF_8));
            }

            @Override
            public Origin getOrigin() {
                return new PathOrigin(Paths.get("R8Wrapper.java", new String[0]));
            }
        };

        public AOSPResourceProvider(Path archive, Origin origin) {
            super(archive, origin);
        }

        @Override
        public Collection<AndroidResourceInput> getAndroidResources() throws ResourceException {
            ArrayList<AndroidResourceInput> androidResourceInputs = new ArrayList<AndroidResourceInput>(super.getAndroidResources());
            androidResourceInputs.add(this.defaultRules);
            return androidResourceInputs;
        }
    }
}

