/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;
import org.conscrypt.EvpMdRef;
import org.conscrypt.NativeCrypto;
import org.conscrypt.NativeRef;

public abstract class OpenSSLMac
extends MacSpi {
    private final int size;
    private final byte[] singleByte = new byte[1];
    protected boolean initialized = false;

    private OpenSSLMac(int size) {
        this.size = size;
    }

    protected abstract void initContext(byte[] var1);

    protected abstract void resetContext();

    protected abstract void updateDirect(long var1, int var3);

    @Override
    protected int engineGetMacLength() {
        return this.size;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("key must be a SecretKey");
        }
        if (params != null) {
            throw new InvalidAlgorithmParameterException("unknown parameter type");
        }
        byte[] keyBytes = key.getEncoded();
        if (keyBytes == null) {
            throw new InvalidKeyException("key cannot be encoded");
        }
        try {
            this.initContext(keyBytes);
        }
        catch (RuntimeException e) {
            throw new InvalidKeyException("invalid key", e);
        }
        this.initialized = true;
    }

    @Override
    protected void engineUpdate(byte input) {
        this.singleByte[0] = input;
        this.engineUpdate(this.singleByte, 0, 1);
    }

    @Override
    protected void engineUpdate(ByteBuffer input) {
        if (!input.hasRemaining()) {
            return;
        }
        if (!input.isDirect()) {
            super.engineUpdate(input);
            return;
        }
        long baseAddress = NativeCrypto.getDirectBufferAddress(input);
        if (baseAddress == 0L) {
            super.engineUpdate(input);
            return;
        }
        int position = input.position();
        if (position < 0) {
            throw new IllegalStateException("Negative position");
        }
        long ptr = baseAddress + (long)position;
        int len = input.remaining();
        if (len < 0) {
            throw new IllegalStateException("Negative remaining amount");
        }
        this.updateDirect(ptr, len);
        input.position(position + len);
    }

    @Override
    protected byte[] engineDoFinal() {
        byte[] output = this.doFinal();
        this.resetContext();
        return output;
    }

    protected abstract byte[] doFinal();

    @Override
    protected void engineReset() {
        if (!this.initialized) {
            return;
        }
        this.resetContext();
    }

    public static final class AesCmac
    extends OpenSSLMac {
        private NativeRef.CMAC_CTX ctx;

        public AesCmac() {
            super(16);
        }

        @Override
        protected void initContext(byte[] keyBytes) {
            NativeRef.CMAC_CTX ctxLocal = new NativeRef.CMAC_CTX(NativeCrypto.CMAC_CTX_new());
            NativeCrypto.CMAC_Init(ctxLocal, keyBytes);
            this.ctx = ctxLocal;
        }

        @Override
        protected void resetContext() {
            NativeRef.CMAC_CTX ctxLocal = this.ctx;
            NativeCrypto.CMAC_Reset(ctxLocal);
        }

        @Override
        protected void updateDirect(long ptr, int len) {
            NativeRef.CMAC_CTX ctxLocal = this.ctx;
            NativeCrypto.CMAC_UpdateDirect(ctxLocal, ptr, len);
        }

        @Override
        protected byte[] doFinal() {
            NativeRef.CMAC_CTX ctxLocal = this.ctx;
            return NativeCrypto.CMAC_Final(ctxLocal);
        }

        @Override
        protected void engineUpdate(byte[] input, int offset, int len) {
            NativeRef.CMAC_CTX ctxLocal = this.ctx;
            NativeCrypto.CMAC_Update(ctxLocal, input, offset, len);
        }
    }

    public static final class HmacSHA512
    extends Hmac {
        public HmacSHA512() {
            super(EvpMdRef.SHA512.EVP_MD, EvpMdRef.SHA512.SIZE_BYTES);
        }
    }

    public static final class HmacSHA384
    extends Hmac {
        public HmacSHA384() {
            super(EvpMdRef.SHA384.EVP_MD, EvpMdRef.SHA384.SIZE_BYTES);
        }
    }

    public static final class HmacSHA256
    extends Hmac {
        public HmacSHA256() {
            super(EvpMdRef.SHA256.EVP_MD, EvpMdRef.SHA256.SIZE_BYTES);
        }
    }

    public static final class HmacSHA224
    extends Hmac {
        public HmacSHA224() {
            super(EvpMdRef.SHA224.EVP_MD, EvpMdRef.SHA224.SIZE_BYTES);
        }
    }

    public static final class HmacSHA1
    extends Hmac {
        public HmacSHA1() {
            super(EvpMdRef.SHA1.EVP_MD, EvpMdRef.SHA1.SIZE_BYTES);
        }
    }

    public static final class HmacMD5
    extends Hmac {
        public HmacMD5() {
            super(EvpMdRef.MD5.EVP_MD, EvpMdRef.MD5.SIZE_BYTES);
        }
    }

    public static class Hmac
    extends OpenSSLMac {
        private NativeRef.HMAC_CTX ctx;
        private final long evpMd;

        public Hmac(long evpMd, int size) {
            super(size);
            this.evpMd = evpMd;
        }

        @Override
        protected void initContext(byte[] keyBytes) {
            NativeRef.HMAC_CTX ctxLocal = new NativeRef.HMAC_CTX(NativeCrypto.HMAC_CTX_new());
            NativeCrypto.HMAC_Init_ex(ctxLocal, keyBytes, this.evpMd);
            this.ctx = ctxLocal;
        }

        @Override
        protected void resetContext() {
            NativeRef.HMAC_CTX ctxLocal = this.ctx;
            NativeCrypto.HMAC_Reset(ctxLocal);
        }

        @Override
        protected void engineUpdate(byte[] input, int offset, int len) {
            NativeRef.HMAC_CTX ctxLocal = this.ctx;
            NativeCrypto.HMAC_Update(ctxLocal, input, offset, len);
        }

        @Override
        protected void updateDirect(long ptr, int len) {
            NativeRef.HMAC_CTX ctxLocal = this.ctx;
            NativeCrypto.HMAC_UpdateDirect(ctxLocal, ptr, len);
        }

        @Override
        protected byte[] doFinal() {
            NativeRef.HMAC_CTX ctxLocal = this.ctx;
            return NativeCrypto.HMAC_Final(ctxLocal);
        }
    }
}

