/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt.metrics;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.conscrypt.Platform;
import org.conscrypt.ct.LogStore;
import org.conscrypt.ct.PolicyCompliance;
import org.conscrypt.ct.VerificationResult;
import org.conscrypt.metrics.CertificateTransparencyVerificationReason;
import org.conscrypt.metrics.CipherSuite;
import org.conscrypt.metrics.ConscryptStatsLog;
import org.conscrypt.metrics.Protocol;
import org.conscrypt.metrics.StatsLog;

public final class StatsLogImpl
implements StatsLog {
    private static final ExecutorService e = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                }
            });
            return thread;
        }
    });
    private static final StatsLog INSTANCE = new StatsLogImpl();

    private StatsLogImpl() {
    }

    public static StatsLog getInstance() {
        return INSTANCE;
    }

    @Override
    public void countTlsHandshake(boolean success, String protocol, String cipherSuite, long duration) {
        Protocol proto = Protocol.forName(protocol);
        CipherSuite suite = CipherSuite.forName(cipherSuite);
        this.write(317, success, proto.getId(), suite.getId(), (int)duration, Platform.getStatsSource().getId(), Platform.getUids());
    }

    private static int logStoreStateToMetricsState(LogStore.State state) {
        switch (state) {
            case UNINITIALIZED: 
            case LOADED: {
                return 0;
            }
            case NOT_FOUND: {
                return 2;
            }
            case MALFORMED: {
                return 3;
            }
            case COMPLIANT: {
                return 1;
            }
            case NON_COMPLIANT: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public void updateCTLogListStatusChanged(LogStore logStore) {
        int state = StatsLogImpl.logStoreStateToMetricsState(logStore.getState());
        this.write(934, state, logStore.getCompatVersion(), logStore.getMinCompatVersionAvailable(), logStore.getMajorVersion(), logStore.getMinorVersion());
    }

    private static int policyComplianceToMetrics(VerificationResult result, PolicyCompliance compliance) {
        if (compliance == PolicyCompliance.COMPLY) {
            return 1;
        }
        if (result.getValidSCTs().size() == 0) {
            return 3;
        }
        if (compliance == PolicyCompliance.NOT_ENOUGH_SCTS || compliance == PolicyCompliance.NOT_ENOUGH_DIVERSE_SCTS) {
            return 4;
        }
        return 0;
    }

    @Override
    public void reportCTVerificationResult(LogStore store, VerificationResult result, PolicyCompliance compliance, CertificateTransparencyVerificationReason reason) {
        if (store.getState() == LogStore.State.NOT_FOUND || store.getState() == LogStore.State.MALFORMED) {
            this.write(989, 5, reason.getId(), 0, 0, 0, 0, 0, 0);
        } else if (store.getState() == LogStore.State.NON_COMPLIANT) {
            this.write(989, 6, reason.getId(), 0, 0, 0, 0, 0, 0);
        } else if (store.getState() == LogStore.State.COMPLIANT) {
            int comp = StatsLogImpl.policyComplianceToMetrics(result, compliance);
            this.write(989, comp, reason.getId(), store.getCompatVersion(), store.getMajorVersion(), store.getMinorVersion(), result.numCertSCTs(), result.numOCSPSCTs(), result.numTlsSCTs());
        }
    }

    private void write(final int atomId, final boolean success, final int protocol, final int cipherSuite, final int duration, final int source, final int[] uids) {
        e.execute(new Runnable(){

            @Override
            public void run() {
                ConscryptStatsLog.write(atomId, success, protocol, cipherSuite, duration, source, uids);
            }
        });
    }

    private void write(final int atomId, final int status, final int loadedCompatVersion, final int minCompatVersionAvailable, final int majorVersion, final int minorVersion) {
        e.execute(new Runnable(){

            @Override
            public void run() {
                ConscryptStatsLog.write(atomId, status, loadedCompatVersion, minCompatVersionAvailable, majorVersion, minorVersion);
            }
        });
    }

    private void write(final int atomId, final int verificationResult, final int verificationReason, final int policyCompatVersion, final int majorVersion, final int minorVersion, final int numEmbeddedScts, final int numOcspScts, final int numTlsScts) {
        e.execute(new Runnable(){

            @Override
            public void run() {
                ConscryptStatsLog.write(atomId, verificationResult, verificationReason, policyCompatVersion, majorVersion, minorVersion, numEmbeddedScts, numOcspScts, numTlsScts);
            }
        });
    }
}

