/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked.raw;

import com.android.tools.smali.dexlib2.ValueType;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.DexReader;
import com.android.tools.smali.dexlib2.dexbacked.raw.FieldIdItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.MethodIdItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.ProtoIdItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.StringIdItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.TypeIdItem;
import com.android.tools.smali.dexlib2.dexbacked.value.DexBackedEncodedValue;
import com.android.tools.smali.dexlib2.util.AnnotatedBytes;
import javax.annotation.Nonnull;

public class EncodedValue {
    public static void annotateEncodedValue(@Nonnull DexBackedDexFile dexFile, @Nonnull AnnotatedBytes out, @Nonnull DexReader reader) {
        int valueArgType = reader.readUbyte();
        int valueArg = valueArgType >>> 5;
        int valueType = valueArgType & 0x1F;
        switch (valueType) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                out.annotate(1, "valueArg = %d, valueType = 0x%x: %s", valueArg, valueType, ValueType.getValueTypeName(valueType));
                reader.setOffset(reader.getOffset() - 1);
                out.annotate(valueArg + 1, "value = %s", EncodedValue.asString(dexFile, reader));
                break;
            }
            case 28: {
                out.annotate(1, "valueArg = %d, valueType = 0x%x: array", valueArg, valueType);
                EncodedValue.annotateEncodedArray(dexFile, out, reader);
                break;
            }
            case 29: {
                out.annotate(1, "valueArg = %d, valueType = 0x%x: annotation", valueArg, valueType);
                EncodedValue.annotateEncodedAnnotation(dexFile, out, reader);
                break;
            }
            case 30: {
                out.annotate(1, "valueArg = %d, valueType = 0x%x: null", valueArg, valueType);
                break;
            }
            case 31: {
                out.annotate(1, "valueArg = %d, valueType = 0x%x: boolean, value=%s", valueArg, valueType, valueArg == 1);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid encoded value type 0x%x at offset 0x%x", valueType, reader.getOffset()));
            }
        }
    }

    public static void annotateEncodedAnnotation(@Nonnull DexBackedDexFile dexFile, @Nonnull AnnotatedBytes out, @Nonnull DexReader reader) {
        assert (out.getCursor() == reader.getOffset());
        int typeIndex = reader.readSmallUleb128();
        out.annotateTo(reader.getOffset(), TypeIdItem.getReferenceAnnotation(dexFile, typeIndex), new Object[0]);
        int size = reader.readSmallUleb128();
        out.annotateTo(reader.getOffset(), "size: %d", size);
        for (int i = 0; i < size; ++i) {
            out.annotate(0, "element[%d]", i);
            out.indent();
            int nameIndex = reader.readSmallUleb128();
            out.annotateTo(reader.getOffset(), "name = %s", StringIdItem.getReferenceAnnotation(dexFile, nameIndex));
            EncodedValue.annotateEncodedValue(dexFile, out, reader);
            out.deindent();
        }
    }

    public static void annotateEncodedArray(@Nonnull DexBackedDexFile dexFile, @Nonnull AnnotatedBytes out, @Nonnull DexReader reader) {
        assert (out.getCursor() == reader.getOffset());
        int size = reader.readSmallUleb128();
        out.annotateTo(reader.getOffset(), "size: %d", size);
        for (int i = 0; i < size; ++i) {
            out.annotate(0, "element[%d]", i);
            out.indent();
            EncodedValue.annotateEncodedValue(dexFile, out, reader);
            out.deindent();
        }
    }

    public static String asString(@Nonnull DexBackedDexFile dexFile, @Nonnull DexReader reader) {
        int valueArgType = reader.readUbyte();
        int valueArg = valueArgType >>> 5;
        int valueType = valueArgType & 0x1F;
        switch (valueType) {
            case 0: {
                int intValue = reader.readByte();
                return String.format("0x%x", intValue);
            }
            case 2: {
                int intValue = reader.readSizedInt(valueArg + 1);
                return String.format("0x%x", intValue);
            }
            case 3: {
                int intValue = reader.readSizedSmallUint(valueArg + 1);
                return String.format("0x%x", intValue);
            }
            case 4: {
                int intValue = reader.readSizedInt(valueArg + 1);
                return String.format("0x%x", intValue);
            }
            case 6: {
                long longValue = reader.readSizedLong(valueArg + 1);
                return String.format("0x%x", longValue);
            }
            case 16: {
                float floatValue = Float.intBitsToFloat(reader.readSizedRightExtendedInt(valueArg + 1));
                return String.format("%f", Float.valueOf(floatValue));
            }
            case 17: {
                double doubleValue = Double.longBitsToDouble(reader.readSizedRightExtendedLong(valueArg + 1));
                return String.format("%f", doubleValue);
            }
            case 21: {
                int protoIndex = reader.readSizedSmallUint(valueArg + 1);
                return ProtoIdItem.getReferenceAnnotation(dexFile, protoIndex);
            }
            case 23: {
                int stringIndex = reader.readSizedSmallUint(valueArg + 1);
                return StringIdItem.getReferenceAnnotation(dexFile, stringIndex, true);
            }
            case 24: {
                int typeIndex = reader.readSizedSmallUint(valueArg + 1);
                return TypeIdItem.getReferenceAnnotation(dexFile, typeIndex);
            }
            case 25: {
                int fieldIndex = reader.readSizedSmallUint(valueArg + 1);
                return FieldIdItem.getReferenceAnnotation(dexFile, fieldIndex);
            }
            case 26: {
                int methodIndex = reader.readSizedSmallUint(valueArg + 1);
                return MethodIdItem.getReferenceAnnotation(dexFile, methodIndex);
            }
            case 27: {
                int fieldIndex = reader.readSizedSmallUint(valueArg + 1);
                return FieldIdItem.getReferenceAnnotation(dexFile, fieldIndex);
            }
            case 22: 
            case 28: 
            case 29: {
                reader.setOffset(reader.getOffset() - 1);
                return DexBackedEncodedValue.readFrom(dexFile, reader).toString();
            }
            case 30: {
                return "null";
            }
            case 31: {
                return Boolean.toString(valueArg == 1);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid encoded value type 0x%x at offset 0x%x", valueType, reader.getOffset()));
    }
}

