/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreProjectEnvironment;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B?\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u0006\u0010\u0013\u001a\u00020\u0011J6\u0010\u0014\u001a\u00020\u0000\"\n\b\u0000\u0010\u0015\u0018\u0001*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0014\b\u0004\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u00020\u00110\u001aH\u0086\b\u00f8\u0001\u0000J\u0017\u0010\u001b\u001a\u00020\u00002\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0086\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/lint/PathCollection;", "", "physicalFiles", "", "Ljava/nio/file/Path;", "physicalDirectories", "virtualFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "virtualDirectories", "<init>", "(Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;)V", "getPhysicalFiles", "()Ljava/util/Collection;", "getPhysicalDirectories", "getVirtualFiles", "getVirtualDirectories", "isEmpty", "", "hasFiles", "isNotEmpty", "filter", "F", "Lcom/intellij/psi/PsiFileSystemItem;", "kotlinCoreProjectEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;", "keepFile", "Lkotlin/Function1;", "plus", "paths", "toString", "", "lint-cli"})
@SourceDebugExtension(value={"SMAP\nUastEnvironmentVirtualFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UastEnvironmentVirtualFileUtils.kt\ncom/android/tools/lint/PathCollection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,265:1\n774#2:266\n865#2,2:267\n774#2:269\n865#2,2:270\n774#2:272\n865#2,2:273\n774#2:275\n865#2,2:276\n*S KotlinDebug\n*F\n+ 1 UastEnvironmentVirtualFileUtils.kt\ncom/android/tools/lint/PathCollection\n*L\n206#1:266\n206#1:267,2\n207#1:269\n207#1:270,2\n208#1:272\n208#1:273,2\n209#1:275\n209#1:276,2\n*E\n"})
public final class PathCollection {
    @NotNull
    private final Collection<Path> physicalFiles;
    @NotNull
    private final Collection<Path> physicalDirectories;
    @NotNull
    private final Collection<VirtualFile> virtualFiles;
    @NotNull
    private final Collection<VirtualFile> virtualDirectories;

    public PathCollection(@NotNull Collection<? extends Path> physicalFiles, @NotNull Collection<? extends Path> physicalDirectories, @NotNull Collection<? extends VirtualFile> virtualFiles, @NotNull Collection<? extends VirtualFile> virtualDirectories) {
        Intrinsics.checkNotNullParameter(physicalFiles, (String)"physicalFiles");
        Intrinsics.checkNotNullParameter(physicalDirectories, (String)"physicalDirectories");
        Intrinsics.checkNotNullParameter(virtualFiles, (String)"virtualFiles");
        Intrinsics.checkNotNullParameter(virtualDirectories, (String)"virtualDirectories");
        this.physicalFiles = physicalFiles;
        this.physicalDirectories = physicalDirectories;
        this.virtualFiles = virtualFiles;
        this.virtualDirectories = virtualDirectories;
    }

    @NotNull
    public final Collection<Path> getPhysicalFiles() {
        return this.physicalFiles;
    }

    @NotNull
    public final Collection<Path> getPhysicalDirectories() {
        return this.physicalDirectories;
    }

    @NotNull
    public final Collection<VirtualFile> getVirtualFiles() {
        return this.virtualFiles;
    }

    @NotNull
    public final Collection<VirtualFile> getVirtualDirectories() {
        return this.virtualDirectories;
    }

    public final boolean isEmpty() {
        return this.physicalFiles.isEmpty() && this.physicalDirectories.isEmpty() && this.virtualFiles.isEmpty() && this.virtualDirectories.isEmpty();
    }

    public final boolean hasFiles() {
        return !this.physicalFiles.isEmpty() || !this.virtualFiles.isEmpty();
    }

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public final /* synthetic */ <F extends PsiFileSystemItem> PathCollection filter(KotlinCoreProjectEnvironment kotlinCoreProjectEnvironment, Function1<? super F, Boolean> keepFile) {
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)kotlinCoreProjectEnvironment, (String)"kotlinCoreProjectEnvironment");
        Intrinsics.checkNotNullParameter(keepFile, (String)"keepFile");
        boolean $i$f$filter = false;
        PsiManager $this$filter_u24lambda_u240 = PsiManager.getInstance((Project)((Project)kotlinCoreProjectEnvironment.getProject()));
        boolean bl = false;
        Intrinsics.needClassReification();
        Function1 keepVirtual2 = (Function1)new Function1<VirtualFile, Boolean>($this$filter_u24lambda_u240, keepFile){
            final /* synthetic */ PsiManager $this_with;
            final /* synthetic */ Function1<F, Boolean> $keepFile;
            {
                this.$this_with = $receiver;
                this.$keepFile = $keepFile;
                super(1);
            }

            public final Boolean invoke(VirtualFile vFile) {
                Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
                PsiFileSystemItem file = vFile.isDirectory() ? (PsiFileSystemItem)this.$this_with.findDirectory(vFile) : (PsiFileSystemItem)this.$this_with.findFile(vFile);
                Intrinsics.reifiedOperationMarker((int)3, (String)"F");
                return file instanceof PsiFileSystemItem && (Boolean)this.$keepFile.invoke((Object)file) != false;
            }
        };
        CoreLocalFileSystem $this$filter_u24lambda_u241 = kotlinCoreProjectEnvironment.getEnvironment().getLocalFileSystem();
        boolean $i$a$-with-PathCollection$filter$keepPhysical$22 = false;
        Function1 keepPhysical2 = (Function1)new Function1<Path, Boolean>($this$filter_u24lambda_u241, (Function1<? super VirtualFile, Boolean>)keepVirtual2){
            final /* synthetic */ CoreLocalFileSystem $this_with;
            final /* synthetic */ Function1<VirtualFile, Boolean> $keepVirtual;
            {
                this.$this_with = $receiver;
                this.$keepVirtual = $keepVirtual;
                super(1);
            }

            public final Boolean invoke(Path path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                VirtualFile vFile = this.$this_with.findFileByPath(((Object)path).toString());
                return vFile != null && (Boolean)this.$keepVirtual.invoke((Object)vFile) != false;
            }
        };
        Iterable $this$filter$iv = this.getPhysicalFiles();
        boolean $i$f$filter2 = false;
        Iterable $i$a$-with-PathCollection$filter$keepPhysical$22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)keepPhysical2.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = this.getPhysicalDirectories();
        Collection collection = (List)destination$iv$iv;
        $i$f$filter2 = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)keepPhysical2.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = this.getVirtualFiles();
        Collection collection2 = (List)destination$iv$iv;
        $i$f$filter2 = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)keepVirtual2.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection collection3 = (List)destination$iv$iv;
        $this$filter$iv = this.getVirtualDirectories();
        collection3 = collection3;
        $i$f$filter2 = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)keepVirtual2.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        Collection collection4 = list2;
        Collection collection5 = collection3;
        Collection collection6 = collection2;
        Collection collection7 = collection;
        return new PathCollection(collection7, collection6, collection5, collection4);
    }

    @NotNull
    public final PathCollection plus(@NotNull Collection<? extends Path> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Set newPhysicalFiles = CollectionsKt.toMutableSet((Iterable)this.physicalFiles);
        Set newPhysicalDirectories = CollectionsKt.toMutableSet((Iterable)this.physicalDirectories);
        for (Path path : paths) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            boolean bl = Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? newPhysicalDirectories.add(path) : newPhysicalFiles.add(path);
        }
        return new PathCollection(newPhysicalFiles, newPhysicalDirectories, this.virtualFiles, this.virtualDirectories);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u242.append("PathCollection {").append('\n');
        $this$toString_u24lambda_u242.append("  physical: ");
        CollectionsKt.joinTo$default((Iterable)CollectionsKt.plus(this.physicalDirectories, (Iterable)this.physicalFiles), (Appendable)$this$toString_u24lambda_u242, null, (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)114, null);
        $this$toString_u24lambda_u242.append('\n');
        $this$toString_u24lambda_u242.append("  virtual: ");
        CollectionsKt.joinTo$default((Iterable)CollectionsKt.plus(this.virtualDirectories, (Iterable)this.virtualFiles), (Appendable)$this$toString_u24lambda_u242, null, (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)114, null);
        $this$toString_u24lambda_u242.append('\n');
        $this$toString_u24lambda_u242.append("}").append('\n');
        return stringBuilder.toString();
    }
}

