/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.HtmlReporter;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.LintStats;
import com.android.tools.lint.MultiProjectHtmlReporter;
import com.android.tools.lint.SarifReporter;
import com.android.tools.lint.TextReporter;
import com.android.tools.lint.XmlFileType;
import com.android.tools.lint.XmlReporter;
import com.android.tools.lint.checks.AccessibilityDetector;
import com.android.tools.lint.checks.ActionsXmlDetector;
import com.android.tools.lint.checks.AlwaysShowActionDetector;
import com.android.tools.lint.checks.AndroidAutoDetector;
import com.android.tools.lint.checks.AndroidTvDetector;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.checks.AppCompatCallDetector;
import com.android.tools.lint.checks.AppCompatCustomViewDetector;
import com.android.tools.lint.checks.AppCompatResourceDetector;
import com.android.tools.lint.checks.AppLinksValidDetector;
import com.android.tools.lint.checks.AssertDetector;
import com.android.tools.lint.checks.AutofillDetector;
import com.android.tools.lint.checks.ButtonDetector;
import com.android.tools.lint.checks.ByteOrderMarkDetector;
import com.android.tools.lint.checks.CallSuperDetector;
import com.android.tools.lint.checks.CanvasSizeDetector;
import com.android.tools.lint.checks.CheckResultDetector;
import com.android.tools.lint.checks.ChromeOsDetector;
import com.android.tools.lint.checks.ChromeOsSourceDetector;
import com.android.tools.lint.checks.CleanupDetector;
import com.android.tools.lint.checks.CommentDetector;
import com.android.tools.lint.checks.DataBindingDetector;
import com.android.tools.lint.checks.DuplicateResourceDetector;
import com.android.tools.lint.checks.EllipsizeMaxLinesDetector;
import com.android.tools.lint.checks.ExportedFlagDetector;
import com.android.tools.lint.checks.FontDetector;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.checks.GridLayoutDetector;
import com.android.tools.lint.checks.IconDetector;
import com.android.tools.lint.checks.IgnoreWithoutReasonDetector;
import com.android.tools.lint.checks.IncludeDetector;
import com.android.tools.lint.checks.InefficientWeightDetector;
import com.android.tools.lint.checks.InteroperabilityDetector;
import com.android.tools.lint.checks.JavaPerformanceDetector;
import com.android.tools.lint.checks.KeyboardNavigationDetector;
import com.android.tools.lint.checks.LabelForDetector;
import com.android.tools.lint.checks.LintDetectorDetector;
import com.android.tools.lint.checks.LocaleDetector;
import com.android.tools.lint.checks.ManifestDetector;
import com.android.tools.lint.checks.MissingClassDetector;
import com.android.tools.lint.checks.MissingIdDetector;
import com.android.tools.lint.checks.MissingPrefixDetector;
import com.android.tools.lint.checks.MotionLayoutDetector;
import com.android.tools.lint.checks.MotionSceneDetector;
import com.android.tools.lint.checks.NamespaceDetector;
import com.android.tools.lint.checks.NetworkSecurityConfigDetector;
import com.android.tools.lint.checks.ObjectAnimatorDetector;
import com.android.tools.lint.checks.ObsoleteLayoutParamsDetector;
import com.android.tools.lint.checks.ParcelDetector;
import com.android.tools.lint.checks.PermissionDetector;
import com.android.tools.lint.checks.PropertyFileDetector;
import com.android.tools.lint.checks.PxUsageDetector;
import com.android.tools.lint.checks.ReadParcelableDetector;
import com.android.tools.lint.checks.RtlDetector;
import com.android.tools.lint.checks.SamDetector;
import com.android.tools.lint.checks.ScrollViewChildDetector;
import com.android.tools.lint.checks.SdkIntDetector;
import com.android.tools.lint.checks.SecurityDetector;
import com.android.tools.lint.checks.ServiceCastDetector;
import com.android.tools.lint.checks.SignatureOrSystemDetector;
import com.android.tools.lint.checks.StringEscapeDetector;
import com.android.tools.lint.checks.SyntheticAccessorDetector;
import com.android.tools.lint.checks.TextFieldDetector;
import com.android.tools.lint.checks.TextViewDetector;
import com.android.tools.lint.checks.TileProviderDetector;
import com.android.tools.lint.checks.TitleDetector;
import com.android.tools.lint.checks.ToastDetector;
import com.android.tools.lint.checks.TranslationDetector;
import com.android.tools.lint.checks.TypoDetector;
import com.android.tools.lint.checks.TypographyDetector;
import com.android.tools.lint.checks.UnsafeBroadcastReceiverDetector;
import com.android.tools.lint.checks.UnusedResourceDetector;
import com.android.tools.lint.checks.UselessViewDetector;
import com.android.tools.lint.checks.Utf8Detector;
import com.android.tools.lint.checks.VectorPathDetector;
import com.android.tools.lint.checks.ViewTypeDetector;
import com.android.tools.lint.checks.WakelockDetector;
import com.android.tools.lint.checks.WatchFaceEditorDetector;
import com.android.tools.lint.checks.WatchFaceForAndroidXDetector;
import com.android.tools.lint.checks.WearStandaloneAppDetector;
import com.android.tools.lint.checks.WrongCallDetector;
import com.android.tools.lint.checks.WrongCaseDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.utils.SdkUtils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000 +2\u00020\u0001:\u0001+B\u001b\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H&J\u001e\u0010!\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001dH\u0016J\u0010\u0010$\u001a\u0004\u0018\u00010\u000e2\u0006\u0010%\u001a\u00020\u0005J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u000eH\u0004J\u0010\u0010)\u001a\u00020\u00192\b\u0010*\u001a\u0004\u0018\u00010\u000eR\u0010\u0010\u0002\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0012\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u0011R(\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0010\u0010&\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/android/tools/lint/Reporter;", "", "client", "Lcom/android/tools/lint/LintCliClient;", "output", "Ljava/io/File;", "<init>", "(Lcom/android/tools/lint/LintCliClient;Ljava/io/File;)V", "getOutput", "()Ljava/io/File;", "isWriteToConsole", "", "()Z", "title", "", "isDisplayEmpty", "setDisplayEmpty", "(Z)V", "urlMap", "", "getUrlMap", "()Ljava/util/Map;", "setUrlMap", "(Ljava/util/Map;)V", "write", "", "stats", "Lcom/android/tools/lint/LintStats;", "incidents", "", "Lcom/android/tools/lint/detector/api/Incident;", "registry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "writeProjectList", "projects", "Lcom/android/tools/lint/MultiProjectHtmlReporter$ProjectEntry;", "getUrl", "file", "stripPrefix", "stripPath", "path", "setStripPrefix", "prefix", "Companion", "lint-cli"})
public abstract class Reporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    protected final LintCliClient client;
    @Nullable
    private final File output;
    @JvmField
    @NotNull
    public String title;
    private boolean isDisplayEmpty;
    @Nullable
    private Map<String, String> urlMap;
    @Nullable
    private String stripPrefix;
    @NotNull
    public static final String STDOUT = "stdout";
    @NotNull
    public static final String STDERR = "stderr";
    @Nullable
    private static Set<Issue> studioFixes;

    protected Reporter(@NotNull LintCliClient client, @Nullable File output) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        this.client = client;
        this.output = output;
        this.title = "Lint Report";
        this.isDisplayEmpty = true;
    }

    @Nullable
    public final File getOutput() {
        return this.output;
    }

    public final boolean isWriteToConsole() {
        return this.output == null;
    }

    public final boolean isDisplayEmpty() {
        return this.isDisplayEmpty;
    }

    public final void setDisplayEmpty(boolean bl) {
        this.isDisplayEmpty = bl;
    }

    @Nullable
    public final Map<String, String> getUrlMap() {
        return this.urlMap;
    }

    public final void setUrlMap(@Nullable Map<String, String> map) {
        this.urlMap = map;
    }

    public abstract void write(@NotNull LintStats var1, @NotNull List<Incident> var2, @NotNull IssueRegistry var3) throws IOException;

    public void writeProjectList(@NotNull LintStats stats, @NotNull List<MultiProjectHtmlReporter.ProjectEntry> projects) throws IOException {
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        throw new UnsupportedOperationException();
    }

    @Nullable
    public final String getUrl(@NotNull File file) {
        String string;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Map<String, String> urlMap = this.urlMap;
        if (urlMap != null) {
            String path = file.getAbsolutePath();
            Intrinsics.checkNotNull((Object)path);
            String pathUrl = Companion.encodeUrl(path);
            for (Map.Entry<String, String> entry : urlMap.entrySet()) {
                String prefix = entry.getKey();
                String value = entry.getValue();
                String prefixUrl = Companion.encodeUrl(prefix);
                if (!StringsKt.startsWith$default((String)pathUrl, (String)prefixUrl, (boolean)false, (int)2, null)) continue;
                String string2 = pathUrl.substring(prefixUrl.length());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String relative = string2;
                return value + relative;
            }
        }
        if (file.isAbsolute()) {
            File file2 = this.output;
            String relativePath = this.client.getRelativePath(file2 != null ? file2.getParentFile() : null, file);
            if (relativePath != null) {
                relativePath = StringsKt.replace$default((String)relativePath, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
                return Companion.encodeUrl(relativePath);
            }
        }
        try {
            string = SdkUtils.fileToUrlString((File)file);
        }
        catch (MalformedURLException e) {
            string = null;
        }
        return string;
    }

    @NotNull
    protected final String stripPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String stripPrefix = this.stripPrefix;
        if (stripPrefix != null && StringsKt.startsWith$default((String)path, (String)stripPrefix, (boolean)false, (int)2, null) && path.length() > stripPrefix.length()) {
            int index = stripPrefix.length();
            if (path.charAt(index) == File.separatorChar) {
                ++index;
            }
            String string = path.substring(index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        return path;
    }

    public final void setStripPrefix(@Nullable String prefix) {
        this.stripPrefix = prefix;
    }

    @JvmStatic
    @NotNull
    public static final Reporter createHtmlReporter(@NotNull LintCliClient client, @NotNull File output, @NotNull LintCliFlags flags) throws IOException {
        return Companion.createHtmlReporter(client, output, flags);
    }

    @JvmStatic
    @NotNull
    public static final XmlReporter createXmlReporter(@NotNull LintCliClient client, @NotNull File output, @NotNull XmlFileType reportType) throws IOException {
        return Companion.createXmlReporter(client, output, reportType);
    }

    @JvmStatic
    @NotNull
    public static final Reporter createSarifReporter(@NotNull LintCliClient client, @NotNull File output) throws IOException {
        return Companion.createSarifReporter(client, output);
    }

    @JvmStatic
    @NotNull
    public static final String encodeUrl(@NotNull String url) {
        return Companion.encodeUrl(url);
    }

    @JvmStatic
    public static final boolean hasAutoFix(@Nullable Issue issue) {
        return Companion.hasAutoFix(issue);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005H\u0007J\u0012\u0010 \u001a\u00020\u00152\b\u0010!\u001a\u0004\u0018\u00010\u001fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/Reporter$Companion;", "", "<init>", "()V", "STDOUT", "", "STDERR", "createHtmlReporter", "Lcom/android/tools/lint/Reporter;", "client", "Lcom/android/tools/lint/LintCliClient;", "output", "Ljava/io/File;", "flags", "Lcom/android/tools/lint/LintCliFlags;", "createTextReporter", "Lcom/android/tools/lint/TextReporter;", "file", "writer", "Ljava/io/Writer;", "close", "", "createXmlReporter", "Lcom/android/tools/lint/XmlReporter;", "reportType", "Lcom/android/tools/lint/XmlFileType;", "createSarifReporter", "encodeUrl", "url", "studioFixes", "", "Lcom/android/tools/lint/detector/api/Issue;", "hasAutoFix", "issue", "lint-cli"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Reporter createHtmlReporter(@NotNull LintCliClient client, @NotNull File output, @NotNull LintCliFlags flags) throws IOException {
            Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
            return new HtmlReporter(client, output, flags);
        }

        @NotNull
        public final TextReporter createTextReporter(@NotNull LintCliClient client, @NotNull LintCliFlags flags, @Nullable File file, @NotNull Writer writer, boolean close) {
            Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
            Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            return new TextReporter(client, flags, file, writer, close);
        }

        @JvmStatic
        @NotNull
        public final XmlReporter createXmlReporter(@NotNull LintCliClient client, @NotNull File output, @NotNull XmlFileType reportType) throws IOException {
            Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)((Object)reportType), (String)"reportType");
            return new XmlReporter(client, output, reportType);
        }

        public static /* synthetic */ XmlReporter createXmlReporter$default(Companion companion, LintCliClient lintCliClient, File file, XmlFileType xmlFileType, int n, Object object) throws IOException {
            if ((n & 4) != 0) {
                xmlFileType = XmlFileType.REPORT;
            }
            return companion.createXmlReporter(lintCliClient, file, xmlFileType);
        }

        @JvmStatic
        @NotNull
        public final Reporter createSarifReporter(@NotNull LintCliClient client, @NotNull File output) throws IOException {
            Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            return new SarifReporter(client, output);
        }

        @JvmStatic
        @NotNull
        public final String encodeUrl(@NotNull String url) {
            String string;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            try {
                String encoded = StringsKt.replace$default((String)url, (char)'\\', (char)'/', (boolean)false, (int)4, null);
                String string2 = URLEncoder.encode(encoded, "UTF-8");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encode(...)");
                string = StringsKt.replace$default((String)string2, (String)"%2F", (String)"/", (boolean)false, (int)4, null);
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("Invalid string " + e.getLocalizedMessage());
                string = url;
            }
            return string;
        }

        @JvmStatic
        public final boolean hasAutoFix(@Nullable Issue issue) {
            if (studioFixes == null) {
                Object[] objectArray = new Issue[]{AccessibilityDetector.ISSUE, ActionsXmlDetector.ISSUE, AlwaysShowActionDetector.ISSUE, AndroidAutoDetector.INVALID_USES_TAG_ISSUE, AndroidTvDetector.MISSING_BANNER, AndroidTvDetector.MISSING_LEANBACK_SUPPORT, AndroidTvDetector.PERMISSION_IMPLIES_UNSUPPORTED_HARDWARE, AndroidTvDetector.UNSUPPORTED_TV_HARDWARE, AnnotationDetector.FLAG_STYLE, AnnotationDetector.SWITCH_TYPE_DEF, ApiDetector.INLINED, ApiDetector.OBSOLETE_SDK, ApiDetector.UNSUPPORTED, ApiDetector.UNUSED, AppCompatCallDetector.ISSUE, AppCompatCustomViewDetector.ISSUE, AppCompatResourceDetector.ISSUE, AppLinksValidDetector.INTENT_FILTER_UNIQUE_DATA_ATTRIBUTES, AppLinksValidDetector.VALIDATION, AssertDetector.EXPENSIVE, AutofillDetector.ISSUE, ButtonDetector.STYLE, ByteOrderMarkDetector.BOM, CallSuperDetector.ISSUE, CanvasSizeDetector.ISSUE, CheckResultDetector.CHECK_PERMISSION, CheckResultDetector.CHECK_RESULT, ChromeOsDetector.NON_RESIZEABLE_ACTIVITY, ChromeOsDetector.PERMISSION_IMPLIES_UNSUPPORTED_HARDWARE, ChromeOsDetector.SETTING_ORIENTATION_ON_ACTIVITY, ChromeOsDetector.UNSUPPORTED_CHROME_OS_HARDWARE, ChromeOsSourceDetector.CHROMEOS_ON_CONFIGURATION_CHANGED, ChromeOsSourceDetector.UNSUPPORTED_CAMERA_FEATURE, ChromeOsSourceDetector.UNSUPPORTED_LOCKED_ORIENTATION, CleanupDetector.APPLY_SHARED_PREF, CleanupDetector.SHARED_PREF, CommentDetector.STOP_SHIP, DataBindingDetector.ESCAPE_XML, DuplicateResourceDetector.TYPE_MISMATCH, EllipsizeMaxLinesDetector.ISSUE, ExportedFlagDetector.ISSUE, FontDetector.FONT_VALIDATION, GradleDetector.AGP_DEPENDENCY, GradleDetector.ANNOTATION_PROCESSOR_ON_COMPILE_PATH, GradleDetector.CHROMEOS_ABI_SUPPORT, GradleDetector.COMPATIBILITY, GradleDetector.DEPENDENCY, GradleDetector.DEPRECATED, GradleDetector.DEPRECATED_CONFIGURATION, GradleDetector.DEPRECATED_LIBRARY, GradleDetector.DUPLICATE_CLASSES, GradleDetector.EXPIRED_TARGET_SDK_VERSION, GradleDetector.EXPIRING_TARGET_SDK_VERSION, GradleDetector.JAVA_PLUGIN_LANGUAGE_LEVEL, GradleDetector.JCENTER_REPOSITORY_OBSOLETE, GradleDetector.KTX_EXTENSION_AVAILABLE, GradleDetector.MIN_SDK_TOO_LOW, GradleDetector.NOT_INTERPOLATED, GradleDetector.PATH, GradleDetector.PLUS, GradleDetector.REMOTE_VERSION, GradleDetector.RISKY_LIBRARY, GradleDetector.STRING_INTEGER, GradleDetector.TARGET_NEWER, GridLayoutDetector.ISSUE, IconDetector.WEBP_ELIGIBLE, IconDetector.WEBP_UNSUPPORTED, IgnoreWithoutReasonDetector.ISSUE, IncludeDetector.ISSUE, InefficientWeightDetector.BASELINE_WEIGHTS, InefficientWeightDetector.INEFFICIENT_WEIGHT, InefficientWeightDetector.ORIENTATION, InteroperabilityDetector.PLATFORM_NULLNESS, JavaPerformanceDetector.USE_VALUE_OF, KeyboardNavigationDetector.ISSUE, LabelForDetector.ISSUE, LintDetectorDetector.DOLLAR_STRINGS, LintDetectorDetector.EXISTING_LINT_CONSTANTS, LintDetectorDetector.TEXT_FORMAT, LintDetectorDetector.TRIM_INDENT, LocaleDetector.STRING_LOCALE, ManifestDetector.APPLICATION_ICON, ManifestDetector.DATA_EXTRACTION_RULES, ManifestDetector.MIPMAP, ManifestDetector.MOCK_LOCATION, ManifestDetector.SET_VERSION, MissingClassDetector.INNERCLASS, MissingIdDetector.ISSUE, MissingPrefixDetector.MISSING_NAMESPACE, MotionLayoutDetector.INVALID_SCENE_FILE_REFERENCE, MotionSceneDetector.MOTION_SCENE_FILE_VALIDATION_ERROR, NamespaceDetector.REDUNDANT, NamespaceDetector.RES_AUTO, NamespaceDetector.TYPO, NetworkSecurityConfigDetector.INSECURE_CONFIGURATION, NetworkSecurityConfigDetector.ISSUE, ObjectAnimatorDetector.MISSING_KEEP, ObsoleteLayoutParamsDetector.ISSUE, ParcelDetector.ISSUE, PermissionDetector.MISSING_PERMISSION, PropertyFileDetector.ESCAPE, PropertyFileDetector.HTTP, PxUsageDetector.DP_ISSUE, PxUsageDetector.PX_ISSUE, ReadParcelableDetector.ISSUE, RtlDetector.COMPAT, RtlDetector.USE_START, SamDetector.ISSUE, ScrollViewChildDetector.ISSUE, SdkIntDetector.ISSUE, SecurityDetector.EXPORTED_PROVIDER, SecurityDetector.EXPORTED_RECEIVER, SecurityDetector.EXPORTED_SERVICE, ServiceCastDetector.WIFI_MANAGER, ServiceCastDetector.WIFI_MANAGER_UNCERTAIN, SignatureOrSystemDetector.ISSUE, StringEscapeDetector.STRING_ESCAPING, SyntheticAccessorDetector.ISSUE, TextFieldDetector.ISSUE, TextViewDetector.SELECTABLE, TileProviderDetector.TILE_PROVIDER_PERMISSIONS, TitleDetector.ISSUE, ToastDetector.ISSUE, TranslationDetector.EXTRA, TranslationDetector.MISSING, TranslationDetector.MISSING_BASE, TranslationDetector.TRANSLATED_UNTRANSLATABLE, TypoDetector.ISSUE, TypographyDetector.DASHES, TypographyDetector.ELLIPSIS, TypographyDetector.FRACTIONS, TypographyDetector.OTHER, TypographyDetector.QUOTES, UnsafeBroadcastReceiverDetector.BROADCAST_SMS, UnusedResourceDetector.ISSUE, UnusedResourceDetector.ISSUE_IDS, UselessViewDetector.USELESS_LEAF, Utf8Detector.ISSUE, VectorPathDetector.PATH_VALID, ViewTypeDetector.ADD_CAST, ViewTypeDetector.WRONG_VIEW_CAST, WakelockDetector.TIMEOUT, WatchFaceForAndroidXDetector.ISSUE, WatchFaceEditorDetector.ISSUE, WearStandaloneAppDetector.WEAR_STANDALONE_APP_ISSUE, WrongCallDetector.ISSUE, WrongCaseDetector.WRONG_CASE};
                studioFixes = SetsKt.setOf((Object[])objectArray);
            }
            Set set = studioFixes;
            return set != null ? CollectionsKt.contains((Iterable)set, (Object)issue) : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

