/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.Serializer;
import com.esotericsoftware.kryo.kryo5.serializers.CompatibleFieldSerializer;
import com.esotericsoftware.kryo.kryo5.serializers.FieldSerializer;
import com.esotericsoftware.kryo.kryo5.serializers.TaggedFieldSerializer;
import com.esotericsoftware.kryo.kryo5.serializers.VersionFieldSerializer;
import com.esotericsoftware.kryo.kryo5.util.Util;

public interface SerializerFactory<T extends Serializer> {
    public T newSerializer(Kryo var1, Class var2);

    public boolean isSupported(Class var1);

    public static class CompatibleFieldSerializerFactory
    extends BaseSerializerFactory<CompatibleFieldSerializer> {
        private final CompatibleFieldSerializer.CompatibleFieldSerializerConfig config;

        public CompatibleFieldSerializerFactory() {
            this.config = new CompatibleFieldSerializer.CompatibleFieldSerializerConfig();
        }

        public CompatibleFieldSerializerFactory(CompatibleFieldSerializer.CompatibleFieldSerializerConfig config) {
            this.config = config;
        }

        public CompatibleFieldSerializer.CompatibleFieldSerializerConfig getConfig() {
            return this.config;
        }

        @Override
        public CompatibleFieldSerializer newSerializer(Kryo kryo, Class type) {
            return new CompatibleFieldSerializer(kryo, type, this.config.clone());
        }
    }

    public static class VersionFieldSerializerFactory
    extends BaseSerializerFactory<VersionFieldSerializer> {
        private final VersionFieldSerializer.VersionFieldSerializerConfig config;

        public VersionFieldSerializerFactory() {
            this.config = new VersionFieldSerializer.VersionFieldSerializerConfig();
        }

        public VersionFieldSerializerFactory(VersionFieldSerializer.VersionFieldSerializerConfig config) {
            this.config = config;
        }

        public VersionFieldSerializer.VersionFieldSerializerConfig getConfig() {
            return this.config;
        }

        @Override
        public VersionFieldSerializer newSerializer(Kryo kryo, Class type) {
            return new VersionFieldSerializer(kryo, type, this.config.clone());
        }
    }

    public static class TaggedFieldSerializerFactory
    extends BaseSerializerFactory<TaggedFieldSerializer> {
        private final TaggedFieldSerializer.TaggedFieldSerializerConfig config;

        public TaggedFieldSerializerFactory() {
            this.config = new TaggedFieldSerializer.TaggedFieldSerializerConfig();
        }

        public TaggedFieldSerializerFactory(TaggedFieldSerializer.TaggedFieldSerializerConfig config) {
            this.config = config;
        }

        public TaggedFieldSerializer.TaggedFieldSerializerConfig getConfig() {
            return this.config;
        }

        @Override
        public TaggedFieldSerializer newSerializer(Kryo kryo, Class type) {
            return new TaggedFieldSerializer(kryo, type, this.config.clone());
        }
    }

    public static class FieldSerializerFactory
    extends BaseSerializerFactory<FieldSerializer> {
        private final FieldSerializer.FieldSerializerConfig config;

        public FieldSerializerFactory() {
            this.config = new FieldSerializer.FieldSerializerConfig();
        }

        public FieldSerializerFactory(FieldSerializer.FieldSerializerConfig config) {
            this.config = config;
        }

        public FieldSerializer.FieldSerializerConfig getConfig() {
            return this.config;
        }

        @Override
        public FieldSerializer newSerializer(Kryo kryo, Class type) {
            return new FieldSerializer(kryo, type, this.config.clone());
        }
    }

    public static class SingletonSerializerFactory<T extends Serializer>
    extends BaseSerializerFactory<T> {
        private final T serializer;

        public SingletonSerializerFactory(T serializer2) {
            this.serializer = serializer2;
        }

        @Override
        public T newSerializer(Kryo kryo, Class type) {
            return this.serializer;
        }
    }

    public static class ReflectionSerializerFactory<T extends Serializer>
    extends BaseSerializerFactory<T> {
        private final Class<T> serializerClass;

        public ReflectionSerializerFactory(Class<T> serializerClass) {
            this.serializerClass = serializerClass;
        }

        @Override
        public T newSerializer(Kryo kryo, Class type) {
            return ReflectionSerializerFactory.newSerializer(kryo, this.serializerClass, type);
        }

        public static <T extends Serializer> T newSerializer(Kryo kryo, Class<T> serializerClass, Class type) {
            try {
                try {
                    return (T)((Serializer)serializerClass.getConstructor(Kryo.class, Class.class).newInstance(kryo, type));
                }
                catch (NoSuchMethodException ex1) {
                    try {
                        return (T)((Serializer)serializerClass.getConstructor(Kryo.class).newInstance(kryo));
                    }
                    catch (NoSuchMethodException ex2) {
                        try {
                            return (T)((Serializer)serializerClass.getConstructor(Class.class).newInstance(type));
                        }
                        catch (NoSuchMethodException ex3) {
                            return (T)((Serializer)serializerClass.newInstance());
                        }
                    }
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unable to create serializer \"" + serializerClass.getName() + "\" for class: " + Util.className(type), ex);
            }
        }
    }

    public static abstract class BaseSerializerFactory<T extends Serializer>
    implements SerializerFactory<T> {
        @Override
        public boolean isSupported(Class type) {
            return true;
        }
    }
}

