/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.StackframeShrinkVerdict;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0007\u001a\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a0\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u00012\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\bj\u0002`\nH\u0002\u001a0\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u00012\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\bj\u0002`\nH\u0002\"\u0018\u0010\f\u001a\u00020\r*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\bj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\bj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000*$\b\u0002\u0010\u0010\"\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\b2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\b\u00a8\u0006\u0013"}, d2={"stripCoroutineTrace", "", "Ljava/lang/StackTraceElement;", "trace", "stripTraceWithNonLibraryFrames", "stripLibraryOnlyTrace", "stripStart", "judge", "Lkotlin/Function1;", "Lcom/intellij/diagnostic/StackframeShrinkVerdict;", "Lcom/intellij/diagnostic/StackframeJudge;", "stripTail", "fullName", "", "getFullName", "(Ljava/lang/StackTraceElement;)Ljava/lang/String;", "StackframeJudge", "nonLibraryCaseStackframeJudge", "libraryStackframeJudge", "intellij.platform.util.base"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\ncoroutineTraceStrip.kt\nKotlin\n*S Kotlin\n*F\n+ 1 coroutineTraceStrip.kt\ncom/intellij/diagnostic/CoroutineTraceStripKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1734#2,3:131\n388#2,7:134\n*S KotlinDebug\n*F\n+ 1 coroutineTraceStrip.kt\ncom/intellij/diagnostic/CoroutineTraceStripKt\n*L\n19#1:131,3\n28#1:134,7\n*E\n"})
public final class CoroutineTraceStripKt {
    @NotNull
    private static final Function1<StackTraceElement, StackframeShrinkVerdict> nonLibraryCaseStackframeJudge = CoroutineTraceStripKt::nonLibraryCaseStackframeJudge$lambda$2;
    @NotNull
    private static final Function1<StackTraceElement, StackframeShrinkVerdict> libraryStackframeJudge = CoroutineTraceStripKt::libraryStackframeJudge$lambda$3;

    @ApiStatus.Internal
    @VisibleForTesting
    @NotNull
    public static final List<StackTraceElement> stripCoroutineTrace(@NotNull List<StackTraceElement> trace) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(trace, (String)"trace");
            if (trace.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            Iterable $this$all$iv = trace;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    StackTraceElement it = (StackTraceElement)element$iv;
                    boolean bl2 = false;
                    String string = it.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
                    if (StringsKt.startsWith$default((String)string, (String)"kotlinx.coroutines.", (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl ? CoroutineTraceStripKt.stripLibraryOnlyTrace(trace) : CoroutineTraceStripKt.stripTraceWithNonLibraryFrames(trace);
    }

    private static final List<StackTraceElement> stripTraceWithNonLibraryFrames(List<StackTraceElement> trace) {
        int lastNonLibFrameIndex;
        block2: {
            int n;
            List<StackTraceElement> $this$indexOfLast$iv = trace;
            boolean $i$f$indexOfLast = false;
            ListIterator<StackTraceElement> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                StackTraceElement it = iterator$iv.previous();
                boolean bl = false;
                String string = it.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
                if (!(!StringsKt.startsWith$default((String)string, (String)"kotlinx.coroutines.", (boolean)false, (int)2, null))) continue;
                n = iterator$iv.nextIndex();
                break block2;
            }
            n = lastNonLibFrameIndex = -1;
        }
        if (!(lastNonLibFrameIndex != -1)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return CoroutineTraceStripKt.stripStart(trace.subList(0, lastNonLibFrameIndex + 1), nonLibraryCaseStackframeJudge);
    }

    private static final List<StackTraceElement> stripLibraryOnlyTrace(List<StackTraceElement> trace) {
        return CoroutineTraceStripKt.stripTail(CoroutineTraceStripKt.stripStart(trace, libraryStackframeJudge), libraryStackframeJudge);
    }

    private static final List<StackTraceElement> stripStart(List<StackTraceElement> $this$stripStart, Function1<? super StackTraceElement, ? extends StackframeShrinkVerdict> judge) {
        int startIndex;
        for (startIndex = 0; startIndex < $this$stripStart.size() && judge.invoke((Object)$this$stripStart.get(startIndex)) == StackframeShrinkVerdict.OMIT; ++startIndex) {
        }
        while (startIndex + 1 < $this$stripStart.size() && judge.invoke((Object)$this$stripStart.get(startIndex)) == StackframeShrinkVerdict.SHRINK && judge.invoke((Object)$this$stripStart.get(startIndex + 1)) == StackframeShrinkVerdict.SHRINK) {
            ++startIndex;
        }
        return $this$stripStart.subList(startIndex, $this$stripStart.size());
    }

    private static final List<StackTraceElement> stripTail(List<StackTraceElement> $this$stripTail, Function1<? super StackTraceElement, ? extends StackframeShrinkVerdict> judge) {
        int afterLastIndex = $this$stripTail.size();
        while (0 <= afterLastIndex - 1 && judge.invoke((Object)$this$stripTail.get(afterLastIndex - 1)) == StackframeShrinkVerdict.OMIT) {
            --afterLastIndex;
        }
        return $this$stripTail.subList(0, afterLastIndex);
    }

    private static final String getFullName(StackTraceElement $this$fullName) {
        return $this$fullName.getClassName() + '.' + $this$fullName.getMethodName();
    }

    private static final StackframeShrinkVerdict nonLibraryCaseStackframeJudge$lambda$2(StackTraceElement stackframe) {
        StackframeShrinkVerdict stackframeShrinkVerdict;
        Intrinsics.checkNotNullParameter((Object)stackframe, (String)"stackframe");
        switch (CoroutineTraceStripKt.getFullName(stackframe)) {
            case "com.intellij.util.CoroutineScopeKt$namedChildScope$2$1.invokeSuspend": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "com.intellij.util.CoroutineScopeKt$namedChildScope$2.invokeSuspend": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.KEEP;
                break;
            }
            case "kotlinx.coroutines.flow.StateFlowImpl.collect": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.FlowKt__MergeKt$flattenConcat$1$1.emit": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.FlowKt__MergeKt$flatMapConcat$$inlined$map$1$2.emit": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.FlowKt__LimitKt.emitAbort$FlowKt__LimitKt": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.FlowKt__LimitKt$take$2$1.emit": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            default: {
                stackframeShrinkVerdict = (StackframeShrinkVerdict)((Object)libraryStackframeJudge.invoke((Object)stackframe));
            }
        }
        return stackframeShrinkVerdict;
    }

    private static final StackframeShrinkVerdict libraryStackframeJudge$lambda$3(StackTraceElement stackframe) {
        StackframeShrinkVerdict stackframeShrinkVerdict;
        Intrinsics.checkNotNullParameter((Object)stackframe, (String)"stackframe");
        switch (CoroutineTraceStripKt.getFullName(stackframe)) {
            case "kotlinx.coroutines.channels.AbstractChannel.receiveCatching-JP2dKIU": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.channels.ProduceKt.awaitClose": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.SharedFlowImpl.collect$suspendImpl": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.FlowKt__ChannelsKt.emitAllImpl$FlowKt__ChannelsKt": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.FlowKt__DelayKt$debounceInternal$1.invokeSuspend": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.FlowKt__DelayKt$debounceInternal$1$values$1.invokeSuspend": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.FlowKt__ReduceKt.first": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.CallbackFlowBuilder.collectTo": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.StateFlowImpl.collect": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.SHRINK;
                break;
            }
            case "kotlinx.coroutines.flow.FlowKt__ShareKt$launchSharing$1.invokeSuspend": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.SHRINK;
                break;
            }
            case "kotlinx.coroutines.flow.FlowKt__ErrorsKt.catchImpl": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.SHRINK;
                break;
            }
            case "kotlinx.coroutines.flow.FlowKt__ErrorsKt$retryWhen$$inlined$unsafeFlow$1.collect": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.SHRINK;
                break;
            }
            case "kotlinx.coroutines.flow.FlowKt__ErrorsKt$catch$$inlined$unsafeFlow$1.collect": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.SHRINK;
                break;
            }
            case "kotlinx.coroutines.flow.internal.FlowCoroutineKt$scopedFlow$1$1.invokeSuspend": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.internal.ChannelFlow$collect$2.invokeSuspend": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.internal.ChannelFlow$collectToFun$1.invokeSuspend": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            case "kotlinx.coroutines.flow.internal.CombineKt$combineInternal$2.invokeSuspend": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.SHRINK;
                break;
            }
            case "kotlinx.coroutines.flow.internal.CombineKt$combineInternal$2$1.invokeSuspend": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.SHRINK;
                break;
            }
            case "kotlinx.coroutines.flow.internal.ChannelFlowTransformLatest$flowCollect$3.invokeSuspend": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.SHRINK;
                break;
            }
            case "kotlinx.coroutines.DelayKt.awaitCancellation": {
                stackframeShrinkVerdict = StackframeShrinkVerdict.OMIT;
                break;
            }
            default: {
                stackframeShrinkVerdict = StackframeShrinkVerdict.KEEP;
            }
        }
        return stackframeShrinkVerdict;
    }
}

