/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.MergeResolveUtilKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0007J\"\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/diff/comparison/MergeResolveUtil;", "", "<init>", "()V", "tryResolve", "", "leftText", "baseText", "rightText", "tryGreedyResolve", "intellij.platform.util.diff"})
public final class MergeResolveUtil {
    @NotNull
    public static final MergeResolveUtil INSTANCE = new MergeResolveUtil();

    private MergeResolveUtil() {
    }

    @JvmStatic
    @Nullable
    public static final CharSequence tryResolve(@NotNull CharSequence leftText, @NotNull CharSequence baseText, @NotNull CharSequence rightText) {
        Intrinsics.checkNotNullParameter((Object)leftText, (String)"leftText");
        Intrinsics.checkNotNullParameter((Object)baseText, (String)"baseText");
        Intrinsics.checkNotNullParameter((Object)rightText, (String)"rightText");
        try {
            CharSequence resolved = MergeResolveUtilKt.access$trySimpleResolve(leftText, baseText, rightText, ComparisonPolicy.DEFAULT);
            if (resolved != null) {
                return resolved;
            }
            return MergeResolveUtilKt.access$trySimpleResolve(leftText, baseText, rightText, ComparisonPolicy.IGNORE_WHITESPACES);
        }
        catch (DiffTooBigException e) {
            return null;
        }
    }

    @JvmStatic
    @Nullable
    public static final CharSequence tryGreedyResolve(@NotNull CharSequence leftText, @NotNull CharSequence baseText, @NotNull CharSequence rightText) {
        Intrinsics.checkNotNullParameter((Object)leftText, (String)"leftText");
        Intrinsics.checkNotNullParameter((Object)baseText, (String)"baseText");
        Intrinsics.checkNotNullParameter((Object)rightText, (String)"rightText");
        try {
            CharSequence resolved = MergeResolveUtilKt.access$tryGreedyResolve(leftText, baseText, rightText, ComparisonPolicy.DEFAULT);
            if (resolved != null) {
                return resolved;
            }
            return MergeResolveUtilKt.access$tryGreedyResolve(leftText, baseText, rightText, ComparisonPolicy.IGNORE_WHITESPACES);
        }
        catch (DiffTooBigException e) {
            return null;
        }
    }
}

