/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.ClassLoaderConfiguratorKt;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.KotlinK2ModeCompatibilityCheckerKt;
import com.intellij.ide.plugins.MainInfo;
import com.intellij.ide.plugins.ModuleLoadingRule;
import com.intellij.ide.plugins.PluginContentDescriptor;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.ide.plugins.XmlReader;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.ide.plugins.cl.ResolveScopeManager;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.ResourceFile;
import com.intellij.util.lang.UrlClassLoader;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\rJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\rJ\u001b\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0!2\u0006\u0010\u001f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\rH\u0002J\u0018\u0010$\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u0005H\u0002J#\u0010&\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\r2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0!H\u0002\u00a2\u0006\u0002\u0010(J\n\u0010)\u001a\u0004\u0018\u00010*H\u0002J\u0018\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020\u0005H\u0002J\u0010\u0010.\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\rH\u0002J9\u0010/\u001a\u0002002\u0006\u0010\u001f\u001a\u00020\r2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\r0!2\u0006\u00102\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001005H\u0002\u00a2\u0006\u0002\u00106R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/ide/plugins/ClassLoaderConfigurator;", "", "pluginSet", "Lcom/intellij/ide/plugins/PluginSet;", "coreLoader", "Ljava/lang/ClassLoader;", "<init>", "(Lcom/intellij/ide/plugins/PluginSet;Ljava/lang/ClassLoader;)V", "getPluginSet", "()Lcom/intellij/ide/plugins/PluginSet;", "pluginPackagePrefixUniqueGuard", "Ljava/util/HashMap;", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "resourceFileFactory", "Ljava/util/function/Function;", "Ljava/nio/file/Path;", "Lcom/intellij/util/lang/ResourceFile;", "getResourceFileFactory$annotations", "()V", "mainToClassPath", "Ljava/util/IdentityHashMap;", "Lcom/intellij/openapi/extensions/PluginId;", "Lcom/intellij/ide/plugins/MainInfo;", "configureDependency", "", "mainDescriptor", "moduleDescriptor", "configure", "", "configureModule", "module", "getSortedDependencies", "", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;)[Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "configureMainPluginModule", "configureDependenciesInOldFormat", "mainDependentClassLoader", "configureCorePluginModuleClassLoader", "deps", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;[Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;)V", "getCoreUrlClassLoaderIfPossible", "Lcom/intellij/util/lang/UrlClassLoader;", "setPluginClassLoaderForModuleAndOldSubDescriptors", "rootDescriptor", "classLoader", "checkPackagePrefixUniqueness", "createPluginClassLoader", "Lcom/intellij/ide/plugins/cl/PluginClassLoader;", "dependencies", "classPath", "Lcom/intellij/util/lang/ClassPath;", "libDirectories", "", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;[Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;Lcom/intellij/util/lang/ClassPath;Ljava/util/List;)Lcom/intellij/ide/plugins/cl/PluginClassLoader;", "intellij.platform.core.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nClassLoaderConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassLoaderConfigurator.kt\ncom/intellij/ide/plugins/ClassLoaderConfigurator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,542:1\n1#2:543\n12574#3,2:544\n37#4,2:546\n*S KotlinDebug\n*F\n+ 1 ClassLoaderConfigurator.kt\ncom/intellij/ide/plugins/ClassLoaderConfigurator\n*L\n101#1:544,2\n169#1:546,2\n*E\n"})
public final class ClassLoaderConfigurator {
    @NotNull
    private final PluginSet pluginSet;
    @NotNull
    private final ClassLoader coreLoader;
    @NotNull
    private final HashMap<String, IdeaPluginDescriptorImpl> pluginPackagePrefixUniqueGuard;
    @Nullable
    private final Function<Path, ResourceFile> resourceFileFactory;
    @NotNull
    private final IdentityHashMap<PluginId, MainInfo> mainToClassPath;

    /*
     * WARNING - void declaration
     */
    public ClassLoaderConfigurator(@NotNull PluginSet pluginSet, @NotNull ClassLoader coreLoader) {
        Function function;
        ClassLoaderConfigurator classLoaderConfigurator;
        Intrinsics.checkNotNullParameter((Object)pluginSet, (String)"pluginSet");
        Intrinsics.checkNotNullParameter((Object)coreLoader, (String)"coreLoader");
        this.pluginSet = pluginSet;
        this.coreLoader = coreLoader;
        this.pluginPackagePrefixUniqueGuard = new HashMap();
        this.mainToClassPath = new IdentityHashMap();
        ClassLoaderConfigurator classLoaderConfigurator2 = this;
        try {
            classLoaderConfigurator = classLoaderConfigurator2;
            function = MethodHandles.lookup().findStatic(this.coreLoader.loadClass("com.intellij.util.lang.PathClassLoader"), "getResourceFileFactory", MethodType.methodType(Function.class)).invokeExact();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classLoaderConfigurator = classLoaderConfigurator2;
            function = null;
        }
        catch (Throwable ignore) {
            void e;
            classLoaderConfigurator = classLoaderConfigurator2;
            ClassLoaderConfiguratorKt.access$getLog().error((Throwable)e);
            function = null;
        }
        classLoaderConfigurator.resourceFileFactory = function;
    }

    public /* synthetic */ ClassLoaderConfigurator(PluginSet pluginSet, ClassLoader classLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            classLoader = ClassLoaderConfigurator.class.getClassLoader();
        }
        this(pluginSet, classLoader);
    }

    @NotNull
    public final PluginSet getPluginSet() {
        return this.pluginSet;
    }

    private static /* synthetic */ void getResourceFileFactory$annotations() {
    }

    public final boolean configureDependency(@NotNull IdeaPluginDescriptorImpl mainDescriptor, @NotNull IdeaPluginDescriptorImpl moduleDescriptor) {
        Object v2;
        boolean $i$a$-assert-ClassLoaderConfigurator$configureDependency$322;
        block7: {
            Object it;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)mainDescriptor, (String)"mainDescriptor");
            Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
            boolean bl2 = bl = !Intrinsics.areEqual((Object)mainDescriptor, (Object)moduleDescriptor);
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-ClassLoaderConfigurator$configureDependency$322 = false;
                String $i$a$-assert-ClassLoaderConfigurator$configureDependency$322 = mainDescriptor + " != " + moduleDescriptor;
                throw new AssertionError((Object)$i$a$-assert-ClassLoaderConfigurator$configureDependency$322);
            }
            PluginId pluginId = mainDescriptor.getPluginId();
            $i$a$-assert-ClassLoaderConfigurator$configureDependency$322 = Intrinsics.areEqual((Object)pluginId, (Object)moduleDescriptor.getPluginId());
            if (_Assertions.ENABLED && !$i$a$-assert-ClassLoaderConfigurator$configureDependency$322) {
                boolean $i$a$-assert-ClassLoaderConfigurator$configureDependency$42 = false;
                String $i$a$-assert-ClassLoaderConfigurator$configureDependency$42 = "pluginId '" + pluginId + "' != moduleDescriptor.pluginId '" + moduleDescriptor.getPluginId() + '\'';
                throw new AssertionError((Object)$i$a$-assert-ClassLoaderConfigurator$configureDependency$42);
            }
            Object $i$a$-assert-ClassLoaderConfigurator$configureDependency$42 = mainDescriptor.getPluginClassLoader();
            PluginClassLoader pluginClassLoader = $i$a$-assert-ClassLoaderConfigurator$configureDependency$42 instanceof PluginClassLoader ? (PluginClassLoader)$i$a$-assert-ClassLoaderConfigurator$configureDependency$42 : null;
            if (pluginClassLoader != null) {
                it = pluginClassLoader;
                boolean bl3 = false;
                this.mainToClassPath.put(pluginId, new MainInfo((PluginClassLoader)it));
            }
            $i$a$-assert-ClassLoaderConfigurator$configureDependency$42 = mainDescriptor.pluginDependencies;
            it = $i$a$-assert-ClassLoaderConfigurator$configureDependency$42.iterator();
            while (it.hasNext()) {
                Object e = it.next();
                PluginDependency it2 = (PluginDependency)e;
                boolean bl4 = false;
                if (!(it2.subDescriptor == moduleDescriptor && it2.isOptional())) continue;
                v2 = e;
                break block7;
            }
            v2 = null;
        }
        if (v2 != null) {
            boolean bl;
            boolean bl5 = $i$a$-assert-ClassLoaderConfigurator$configureDependency$322 = moduleDescriptor.getPluginClassLoader() == null;
            if (_Assertions.ENABLED && !$i$a$-assert-ClassLoaderConfigurator$configureDependency$322) {
                boolean bl6 = false;
                String string = "sub descriptor " + moduleDescriptor + " of " + mainDescriptor + " seems to be already enabled";
                throw new AssertionError((Object)string);
            }
            ClassLoader mainDependentClassLoader = mainDescriptor.getPluginClassLoader();
            boolean bl7 = bl = mainDependentClassLoader != null;
            if (_Assertions.ENABLED && !bl) {
                boolean bl8 = false;
                String string = "plugin " + mainDescriptor + " is not yet enabled";
                throw new AssertionError((Object)string);
            }
            ClassLoader classLoader = mainDependentClassLoader;
            Intrinsics.checkNotNull((Object)classLoader);
            moduleDescriptor.setPluginClassLoader(classLoader);
            this.configureDependenciesInOldFormat(moduleDescriptor, mainDependentClassLoader);
            return true;
        }
        return this.configureModule(moduleDescriptor);
    }

    public final void configure() {
        for (IdeaPluginDescriptorImpl module : this.pluginSet.getEnabledModules()) {
            this.configureModule(module);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean configureModule(@NotNull IdeaPluginDescriptorImpl module) {
        boolean isMain;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.checkPackagePrefixUniqueness(module);
        boolean bl = isMain = module.moduleName == null;
        if (isMain) {
            this.configureMainPluginModule(module);
            return true;
        } else {
            IdeaPluginDescriptorImpl[] dependencies;
            if (module.packagePrefix == null && !Intrinsics.areEqual((Object)module.getPluginId(), (Object)PluginManagerCore.CORE_ID) && module.jarFiles == null) {
                throw new PluginException("Package is not specified (module=" + module + ')', module.getPluginId());
            }
            boolean bl2 = module.pluginDependencies.isEmpty();
            if (_Assertions.ENABLED && !bl2) {
                boolean $i$a$-assert-ClassLoaderConfigurator$configureModule$22 = false;
                String $i$a$-assert-ClassLoaderConfigurator$configureModule$22 = "Module " + module + " shouldn't have plugin dependencies: " + module.pluginDependencies;
                throw new AssertionError((Object)$i$a$-assert-ClassLoaderConfigurator$configureModule$22);
            }
            IdeaPluginDescriptorImpl[] $this$any$iv = dependencies = this.getSortedDependencies(module);
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                IdeaPluginDescriptorImpl element$iv;
                IdeaPluginDescriptorImpl it = element$iv = $this$any$iv[i];
                boolean bl3 = false;
                if (it.getPluginClassLoader() == null) {
                    return false;
                }
                boolean bl4 = false;
                if (!bl4) continue;
                return false;
            }
            boolean bl5 = false;
            if (bl5) {
                return false;
            }
            if (module.useCoreClassLoader) {
                module.setPluginClassLoader(this.coreLoader);
                return true;
            }
            MainInfo mainInfo = this.mainToClassPath.get(module.getPluginId());
            if (module.moduleLoadingRule == ModuleLoadingRule.REQUIRED) {
                ClassLoader classLoader;
                if (mainInfo == null) {
                    IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = this.pluginSet.findEnabledPlugin(module.getPluginId());
                    if (ideaPluginDescriptorImpl == null) {
                        throw new PluginException("Plugin " + module.getPluginId() + " is not found in enabled plugins", module.getPluginId());
                    }
                    IdeaPluginDescriptorImpl mainDescriptor = ideaPluginDescriptorImpl;
                    classLoader = this.configureMainPluginModule(mainDescriptor);
                } else {
                    classLoader = mainInfo.mainClassLoader;
                }
                module.setPluginClassLoader(classLoader);
                return true;
            } else if (mainInfo == null) {
                if (!Intrinsics.areEqual((Object)module.getPluginId(), (Object)PluginManagerCore.CORE_ID)) throw new PluginException("Cannot find containing plugin " + module.getPluginId() + " for module " + module.moduleName + ' ', module.getPluginId());
                this.configureCorePluginModuleClassLoader(module, dependencies);
                return true;
            } else {
                List<? extends Path> customJarFiles = module.jarFiles;
                if (customJarFiles == null) {
                    module.setPluginClassLoader(new PluginClassLoader(mainInfo.classPath, dependencies, module, this.coreLoader, ClassLoaderConfiguratorKt.access$createModuleResolveScopeManager(), module.packagePrefix, mainInfo.libDirectories));
                    return true;
                } else {
                    module.setPluginClassLoader(new PluginClassLoader(new ClassPath((Collection<Path>)customJarFiles, ClassLoaderConfiguratorKt.access$getDEFAULT_CLASSLOADER_CONFIGURATION$p(), this.resourceFileFactory, false), dependencies, module, this.coreLoader, null, null, mainInfo.libDirectories));
                }
            }
        }
        return true;
    }

    private final IdeaPluginDescriptorImpl[] getSortedDependencies(IdeaPluginDescriptorImpl module) {
        Collection<IdeaPluginDescriptorImpl> dependenciesList = this.pluginSet.moduleGraph.getDependencies(module);
        List mutableDependenciesList = null;
        for (PluginContentDescriptor.ModuleItem moduleItem : module.content.modules) {
            if (moduleItem.loadingRule != ModuleLoadingRule.REQUIRED) continue;
            if (mutableDependenciesList == null) {
                mutableDependenciesList = CollectionsKt.toMutableList(dependenciesList);
            }
            mutableDependenciesList.addAll(this.pluginSet.moduleGraph.getDependencies(moduleItem.requireDescriptor()));
        }
        List list = mutableDependenciesList;
        Collection<IdeaPluginDescriptorImpl> $this$toTypedArray$iv = list != null ? (Collection<IdeaPluginDescriptorImpl>)list : dependenciesList;
        boolean $i$f$toTypedArray = false;
        Collection<IdeaPluginDescriptorImpl> thisCollection$iv = $this$toTypedArray$iv;
        IdeaPluginDescriptorImpl[] dependencies = thisCollection$iv.toArray(new IdeaPluginDescriptorImpl[0]);
        ClassLoaderConfiguratorKt.sortDependenciesInPlace(dependencies);
        return dependencies;
    }

    private final ClassLoader configureMainPluginModule(IdeaPluginDescriptorImpl module) {
        List<Object> list;
        ClassLoader classLoader;
        if (module.useCoreClassLoader || Intrinsics.areEqual((Object)module.getPluginId(), (Object)PluginManagerCore.CORE_ID)) {
            this.setPluginClassLoaderForModuleAndOldSubDescriptors(module, this.coreLoader);
            return this.coreLoader;
        }
        MainInfo exisingMainInfo = this.mainToClassPath.get(module.getPluginId());
        if (exisingMainInfo != null) {
            return exisingMainInfo.mainClassLoader;
        }
        List mainModuleFiles = module.jarFiles;
        if (mainModuleFiles == null) {
            if (!module.isUseIdeaClassLoader) {
                ClassLoaderConfiguratorKt.access$getLog().error("jarFiles is not set for " + module);
            }
            mainModuleFiles = CollectionsKt.emptyList();
        }
        List allFiles = null;
        for (PluginContentDescriptor.ModuleItem contentModule : module.content.modules) {
            List<? extends Path> customJarFiles;
            if (contentModule.loadingRule != ModuleLoadingRule.REQUIRED || (customJarFiles = contentModule.requireDescriptor().jarFiles) == null) continue;
            if (allFiles == null) {
                allFiles = new ArrayList(mainModuleFiles);
            }
            allFiles.addAll((Collection)customJarFiles);
        }
        List<Object> libDirectories = Collections.emptyList();
        Path libDir = module.path.resolve("lib");
        if (Files.exists(libDir, new LinkOption[0])) {
            libDirectories = Collections.singletonList(libDir);
        }
        boolean mimicJarUrlConnection = !module.isBundled() && !Intrinsics.areEqual((Object)module.getVendor(), (Object)"JetBrains");
        List list2 = allFiles;
        if (list2 == null) {
            list2 = mainModuleFiles;
        }
        List files = list2;
        ClassPath pluginClassPath = new ClassPath(files, ClassLoaderConfiguratorKt.access$getDEFAULT_CLASSLOADER_CONFIGURATION$p(), this.resourceFileFactory, mimicJarUrlConnection);
        if (module.isUseIdeaClassLoader) {
            classLoader = ClassLoaderConfiguratorKt.access$configureUsingIdeaClassloader(files, module);
        } else {
            IdeaPluginDescriptorImpl[] ideaPluginDescriptorImplArray = this.getSortedDependencies(module);
            list = libDirectories;
            Intrinsics.checkNotNull(list);
            classLoader = this.createPluginClassLoader(module, ideaPluginDescriptorImplArray, pluginClassPath, list);
        }
        ClassLoader mainDependentClassLoader = classLoader;
        PluginId pluginId = module.getPluginId();
        list = libDirectories;
        Intrinsics.checkNotNull(list);
        this.mainToClassPath.put(pluginId, new MainInfo(pluginClassPath, list, mainDependentClassLoader));
        module.setPluginClassLoader(mainDependentClassLoader);
        this.configureDependenciesInOldFormat(module, mainDependentClassLoader);
        return mainDependentClassLoader;
    }

    private final void configureDependenciesInOldFormat(IdeaPluginDescriptorImpl module, ClassLoader mainDependentClassLoader) {
        for (PluginDependency dependency : module.pluginDependencies) {
            IdeaPluginDescriptorImpl subDescriptor;
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl;
            if (dependency.subDescriptor == null || !XmlReader.isKotlinPlugin(module.getPluginId()) && XmlReader.isKotlinPlugin(dependency.getPluginId()) && KotlinK2ModeCompatibilityCheckerKt.isIncompatibleWithKotlinPlugin(module)) continue;
            if (this.pluginSet.findEnabledPlugin(dependency.getPluginId()) != null) {
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl2;
                IdeaPluginDescriptorImpl it = ideaPluginDescriptorImpl2;
                boolean bl = false;
                ideaPluginDescriptorImpl = it != module ? ideaPluginDescriptorImpl2 : null;
            } else {
                ideaPluginDescriptorImpl = null;
            }
            if (ideaPluginDescriptorImpl == null) continue;
            subDescriptor.setPluginClassLoader(mainDependentClassLoader);
            this.configureDependenciesInOldFormat(subDescriptor, mainDependentClassLoader);
        }
    }

    private final void configureCorePluginModuleClassLoader(IdeaPluginDescriptorImpl module, IdeaPluginDescriptorImpl[] deps) {
        List<? extends Path> jarFiles = module.jarFiles;
        if (jarFiles != null) {
            ClassPath classPath = new ClassPath((Collection<Path>)jarFiles, ClassLoaderConfiguratorKt.access$getDEFAULT_CLASSLOADER_CONFIGURATION$p(), this.resourceFileFactory, false);
            PluginDescriptor pluginDescriptor = module;
            ClassLoader classLoader = module.isDependentOnCoreClassLoader ? this.coreLoader : this.coreLoader.getParent();
            Intrinsics.checkNotNull((Object)classLoader);
            module.setPluginClassLoader(new PluginClassLoader(classPath, deps, pluginDescriptor, classLoader, null, module.packagePrefix, new ArrayList()));
            return;
        }
        UrlClassLoader coreUrlClassLoader = this.getCoreUrlClassLoaderIfPossible();
        if (coreUrlClassLoader == null) {
            this.setPluginClassLoaderForModuleAndOldSubDescriptors(module, this.coreLoader);
            return;
        }
        ClassPath classPath = coreUrlClassLoader.getClassPath();
        Intrinsics.checkNotNullExpressionValue((Object)classPath, (String)"getClassPath(...)");
        module.setPluginClassLoader(new PluginClassLoader(classPath, deps, module, this.coreLoader, ClassLoaderConfiguratorKt.access$createModuleResolveScopeManager(), module.packagePrefix, new ArrayList()));
    }

    private final UrlClassLoader getCoreUrlClassLoaderIfPossible() {
        ClassLoader classLoader = this.coreLoader;
        UrlClassLoader urlClassLoader = classLoader instanceof UrlClassLoader ? (UrlClassLoader)classLoader : null;
        if (urlClassLoader == null) {
            return null;
        }
        UrlClassLoader coreUrlClassLoader = urlClassLoader;
        if (coreUrlClassLoader.resolveScopeManager == null) {
            IdeaPluginDescriptorImpl corePlugin = (IdeaPluginDescriptorImpl)CollectionsKt.first(this.pluginSet.enabledPlugins);
            boolean bl = Intrinsics.areEqual((Object)corePlugin.getPluginId(), (Object)PluginManagerCore.CORE_ID);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            ResolveScopeManager resolveScopeManager = ClassLoaderConfiguratorKt.createPluginDependencyAndContentBasedScope(corePlugin, this.pluginSet);
            if (resolveScopeManager != null) {
                coreUrlClassLoader.resolveScopeManager = (arg_0, arg_1) -> ClassLoaderConfigurator.getCoreUrlClassLoaderIfPossible$lambda$9(resolveScopeManager, arg_0, arg_1);
            }
        }
        return coreUrlClassLoader;
    }

    private final void setPluginClassLoaderForModuleAndOldSubDescriptors(IdeaPluginDescriptorImpl rootDescriptor, ClassLoader classLoader) {
        rootDescriptor.setPluginClassLoader(classLoader);
        for (PluginDependency dependency : rootDescriptor.pluginDependencies) {
            IdeaPluginDescriptorImpl subDescriptor = dependency.subDescriptor;
            if (subDescriptor == null || !this.pluginSet.isPluginEnabled(dependency.getPluginId())) continue;
            this.setPluginClassLoaderForModuleAndOldSubDescriptors(subDescriptor, classLoader);
        }
    }

    private final void checkPackagePrefixUniqueness(IdeaPluginDescriptorImpl module) {
        IdeaPluginDescriptorImpl old;
        String packagePrefix = module.packagePrefix;
        if (packagePrefix != null && (old = this.pluginPackagePrefixUniqueGuard.putIfAbsent(packagePrefix, module)) != null) {
            throw new PluginException("Package prefix " + packagePrefix + " is already used (second=" + module + ", first=" + old + ')', module.getPluginId());
        }
    }

    private final PluginClassLoader createPluginClassLoader(IdeaPluginDescriptorImpl module, IdeaPluginDescriptorImpl[] dependencies, ClassPath classPath, List<? extends Path> libDirectories) {
        ResolveScopeManager resolveScopeManager = null;
        resolveScopeManager = module.moduleName == null ? (Intrinsics.areEqual((Object)module.getPluginId().getIdString(), (Object)"com.intellij.diagram") ? ClassLoaderConfiguratorKt.access$createScopeWithExtraPackage("com.intellij.diagram.") : ClassLoaderConfiguratorKt.createPluginDependencyAndContentBasedScope(module, this.pluginSet)) : (module.content.modules.isEmpty() ? ClassLoaderConfiguratorKt.access$createModuleResolveScopeManager() : ClassLoaderConfiguratorKt.access$createModuleContentBasedScope(module));
        return new PluginClassLoader(classPath, dependencies, module, this.coreLoader, resolveScopeManager, module.packagePrefix, libDirectories);
    }

    private static final String getCoreUrlClassLoaderIfPossible$lambda$9(ResolveScopeManager $resolveScopeManager, String name, Boolean force) {
        Intrinsics.checkNotNull((Object)name);
        Intrinsics.checkNotNull((Object)force);
        return $resolveScopeManager.isDefinitelyAlienClass(name, "", force);
    }
}

