/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.ClassLoaderConfigurator;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.ModuleDependenciesDescriptor;
import com.intellij.ide.plugins.ModuleLoadingRule;
import com.intellij.ide.plugins.PluginContentDescriptor;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.ide.plugins.cl.ResolveScopeManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.lang.UrlClassLoader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a\b\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u001a\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007\u001a$\u0010\u0013\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00150\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001e\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001b\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100%H\u0007\u00a2\u0006\u0002\u0010&\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u001b\u0010\u0018\u001a\u00020\u00198@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006'"}, d2={"DEFAULT_CLASSLOADER_CONFIGURATION", "Lcom/intellij/util/lang/UrlClassLoader$Builder;", "Lorg/jetbrains/annotations/NotNull;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog$annotations", "()V", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "createModuleResolveScopeManager", "Lcom/intellij/ide/plugins/cl/ResolveScopeManager;", "createScopeWithExtraPackage", "customPackage", "", "createPluginDependencyAndContentBasedScope", "descriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "pluginSet", "Lcom/intellij/ide/plugins/PluginSet;", "getPackagePrefixesLoadedBySeparateClassLoaders", "", "Lkotlin/Pair;", "getDependencyPackagePrefixes", "createModuleContentBasedScope", "canExtendIdeaClassLoader", "", "getCanExtendIdeaClassLoader", "()Z", "canExtendIdeaClassLoader$delegate", "Lkotlin/Lazy;", "configureUsingIdeaClassloader", "Ljava/lang/ClassLoader;", "classPath", "Ljava/nio/file/Path;", "sortDependenciesInPlace", "", "dependencies", "", "([Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;)V", "intellij.platform.core.impl"})
public final class ClassLoaderConfiguratorKt {
    @NotNull
    private static final UrlClassLoader.Builder DEFAULT_CLASSLOADER_CONFIGURATION;
    @NotNull
    private static final Lazy canExtendIdeaClassLoader$delegate;

    private static final Logger getLog() {
        Logger logger = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private static /* synthetic */ void getLog$annotations() {
    }

    private static final ResolveScopeManager createModuleResolveScopeManager() {
        return new ResolveScopeManager(){

            public String isDefinitelyAlienClass(String name, String packagePrefix, boolean force) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)packagePrefix, (String)"packagePrefix");
                return !StringsKt.startsWith$default((String)name, (String)packagePrefix, (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"com.intellij.ultimate.PluginVerifier", (boolean)false, (int)2, null) ? "" : null;
            }
        };
    }

    private static final ResolveScopeManager createScopeWithExtraPackage(String customPackage) {
        return new ResolveScopeManager(customPackage){
            final /* synthetic */ String $customPackage;
            {
                this.$customPackage = $customPackage;
            }

            public String isDefinitelyAlienClass(String name, String packagePrefix, boolean force) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)packagePrefix, (String)"packagePrefix");
                if (!(force || StringsKt.startsWith$default((String)name, (String)packagePrefix, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"com.intellij.ultimate.PluginVerifier", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)this.$customPackage, (boolean)false, (int)2, null))) {
                    return "";
                }
                return null;
            }
        };
    }

    @VisibleForTesting
    @ApiStatus.Internal
    @Nullable
    public static final ResolveScopeManager createPluginDependencyAndContentBasedScope(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull PluginSet pluginSet) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)pluginSet, (String)"pluginSet");
        List<Pair<String, String>> contentPackagePrefixes = ClassLoaderConfiguratorKt.getPackagePrefixesLoadedBySeparateClassLoaders(descriptor2);
        List<String> dependencyPackagePrefixes = ClassLoaderConfiguratorKt.getDependencyPackagePrefixes(descriptor2, pluginSet);
        if (contentPackagePrefixes.isEmpty() && dependencyPackagePrefixes.isEmpty()) {
            return null;
        }
        String string = descriptor2.getPluginId().getIdString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdString(...)");
        String pluginId = string;
        return new ResolveScopeManager(contentPackagePrefixes, pluginId, dependencyPackagePrefixes){
            final /* synthetic */ List<Pair<String, String>> $contentPackagePrefixes;
            final /* synthetic */ String $pluginId;
            final /* synthetic */ List<String> $dependencyPackagePrefixes;
            {
                this.$contentPackagePrefixes = $contentPackagePrefixes;
                this.$pluginId = $pluginId;
                this.$dependencyPackagePrefixes = $dependencyPackagePrefixes;
            }

            public String isDefinitelyAlienClass(String name, String packagePrefix, boolean force) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)packagePrefix, (String)"packagePrefix");
                if (force) {
                    return null;
                }
                for (Pair<String, String> pair : this.$contentPackagePrefixes) {
                    String prefix = (String)pair.component1();
                    String moduleName = (String)pair.component2();
                    if (!StringsKt.startsWith$default((String)name, (String)prefix, (boolean)false, (int)2, null)) continue;
                    return "Class " + name + " must not be requested from main classloader of " + this.$pluginId + " plugin. Matches content module (packagePrefix=" + prefix + ", moduleName=" + moduleName + ").";
                }
                for (String prefix : this.$dependencyPackagePrefixes) {
                    if (!StringsKt.startsWith$default((String)name, (String)prefix, (boolean)false, (int)2, null)) continue;
                    return "";
                }
                return null;
            }
        };
    }

    private static final List<Pair<String, String>> getPackagePrefixesLoadedBySeparateClassLoaders(IdeaPluginDescriptorImpl descriptor2) {
        List<PluginContentDescriptor.ModuleItem> modules = descriptor2.content.modules;
        if (modules.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ArrayList<Pair> result2 = new ArrayList<Pair>(modules.size());
        for (PluginContentDescriptor.ModuleItem item : modules) {
            IdeaPluginDescriptorImpl module = item.requireDescriptor();
            Collection collection = module.jarFiles;
            if (!(collection == null || collection.isEmpty()) || module.moduleLoadingRule == ModuleLoadingRule.REQUIRED) continue;
            String packagePrefix = module.packagePrefix;
            if (packagePrefix == null) {
                if (module.getPluginClassLoader() == null) continue;
                throw new PluginException("Package is not specified (module=" + module + ')', module.getPluginId());
            }
            result2.add(TuplesKt.to((Object)(packagePrefix + '.'), (Object)module.moduleName));
        }
        return result2;
    }

    private static final List<String> getDependencyPackagePrefixes(IdeaPluginDescriptorImpl descriptor2, PluginSet pluginSet) {
        List<ModuleDependenciesDescriptor.ModuleReference> dependencies = descriptor2.dependencies.modules;
        if (dependencies.isEmpty()) {
            List<String> list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
            return list;
        }
        ArrayList<String> result2 = new ArrayList<String>(dependencies.size());
        for (ModuleDependenciesDescriptor.ModuleReference item : dependencies) {
            String packagePrefix;
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = pluginSet.findEnabledModule(item.name);
            if (ideaPluginDescriptorImpl == null || (packagePrefix = ideaPluginDescriptorImpl.packagePrefix) == null || Intrinsics.areEqual((Object)item.name, (Object)"intellij.platform.commercial.verifier")) continue;
            result2.add(packagePrefix + '.');
        }
        return result2;
    }

    private static final ResolveScopeManager createModuleContentBasedScope(IdeaPluginDescriptorImpl descriptor2) {
        ArrayList<String> packagePrefixes = new ArrayList<String>(descriptor2.content.modules.size());
        for (PluginContentDescriptor.ModuleItem item : descriptor2.content.modules) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = item.requireDescriptor().packagePrefix;
            Intrinsics.checkNotNull((Object)string);
            packagePrefixes.add(stringBuilder.append(string).append('.').toString());
        }
        return new ResolveScopeManager(packagePrefixes){
            final /* synthetic */ ArrayList<String> $packagePrefixes;
            {
                this.$packagePrefixes = $packagePrefixes;
            }

            public String isDefinitelyAlienClass(String name, String packagePrefix, boolean force) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)packagePrefix, (String)"packagePrefix");
                if (StringsKt.startsWith$default((String)name, (String)packagePrefix, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"com.intellij.ultimate.PluginVerifier", (boolean)false, (int)2, null)) {
                    return null;
                }
                Iterator<String> iterator2 = this.$packagePrefixes.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
                Iterator<String> iterator3 = iterator2;
                while (iterator3.hasNext()) {
                    String prefix;
                    Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
                    if (!StringsKt.startsWith$default((String)name, (String)prefix, (boolean)false, (int)2, null)) continue;
                    return null;
                }
                return "";
            }
        };
    }

    public static final boolean getCanExtendIdeaClassLoader() {
        Lazy lazy = canExtendIdeaClassLoader$delegate;
        return (Boolean)lazy.getValue();
    }

    private static final ClassLoader configureUsingIdeaClassloader(List<? extends Path> classPath, IdeaPluginDescriptorImpl descriptor2) {
        ClassLoaderConfiguratorKt.getLog().warn(descriptor2.getPluginId() + " uses deprecated `use-idea-classloader` attribute");
        ClassLoader loader = ClassLoaderConfigurator.class.getClassLoader();
        try {
            MethodHandle addFiles = MethodHandles.lookup().findVirtual(loader.getClass(), "addFiles", MethodType.methodType(Void.TYPE, List.class));
            addFiles.invoke(loader, classPath);
            Intrinsics.checkNotNull((Object)loader);
            return loader;
        }
        catch (Throwable e) {
            throw new IllegalStateException("An unexpected core classloader: " + loader, e);
        }
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public static final void sortDependenciesInPlace(@NotNull IdeaPluginDescriptorImpl[] dependencies) {
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        if (dependencies.length <= 1) {
            return;
        }
        ArraysKt.sortWith((Object[])dependencies, (arg_0, arg_1) -> ClassLoaderConfiguratorKt.sortDependenciesInPlace$lambda$3(ClassLoaderConfiguratorKt::sortDependenciesInPlace$lambda$2, arg_0, arg_1));
    }

    private static final boolean canExtendIdeaClassLoader_delegate$lambda$1() {
        Object object;
        try {
            boolean bl = false;
            object = Result.constructor-impl((Object)MethodHandles.lookup().findVirtual(ClassLoaderConfigurator.class.getClassLoader().getClass(), "addFiles", MethodType.methodType(Void.TYPE, List.class)));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return Result.isSuccess-impl((Object)object);
    }

    private static final int sortDependenciesInPlace$getWeight(IdeaPluginDescriptorImpl module) {
        return module.moduleName == null ? 1 : 0;
    }

    private static final int sortDependenciesInPlace$lambda$2(IdeaPluginDescriptorImpl o1, IdeaPluginDescriptorImpl o2) {
        int n;
        Intrinsics.checkNotNull((Object)o1);
        int n2 = ClassLoaderConfiguratorKt.sortDependenciesInPlace$getWeight(o1);
        Intrinsics.checkNotNull((Object)o2);
        int diff = n2 - ClassLoaderConfiguratorKt.sortDependenciesInPlace$getWeight(o2);
        if (diff == 0) {
            String string;
            String string2 = o2.packagePrefix;
            if (string2 == null) {
                string2 = "";
            }
            if ((string = o1.packagePrefix) == null) {
                string = "";
            }
            n = string2.compareTo(string);
        } else {
            n = diff;
        }
        return n;
    }

    private static final int sortDependenciesInPlace$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    public static final /* synthetic */ Logger access$getLog() {
        return ClassLoaderConfiguratorKt.getLog();
    }

    public static final /* synthetic */ ResolveScopeManager access$createModuleResolveScopeManager() {
        return ClassLoaderConfiguratorKt.createModuleResolveScopeManager();
    }

    public static final /* synthetic */ UrlClassLoader.Builder access$getDEFAULT_CLASSLOADER_CONFIGURATION$p() {
        return DEFAULT_CLASSLOADER_CONFIGURATION;
    }

    public static final /* synthetic */ ClassLoader access$configureUsingIdeaClassloader(List classPath, IdeaPluginDescriptorImpl descriptor2) {
        return ClassLoaderConfiguratorKt.configureUsingIdeaClassloader(classPath, descriptor2);
    }

    public static final /* synthetic */ ResolveScopeManager access$createScopeWithExtraPackage(String customPackage) {
        return ClassLoaderConfiguratorKt.createScopeWithExtraPackage(customPackage);
    }

    public static final /* synthetic */ ResolveScopeManager access$createModuleContentBasedScope(IdeaPluginDescriptorImpl descriptor2) {
        return ClassLoaderConfiguratorKt.createModuleContentBasedScope(descriptor2);
    }

    static {
        UrlClassLoader.Builder builder = UrlClassLoader.build().useCache();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"useCache(...)");
        DEFAULT_CLASSLOADER_CONFIGURATION = builder;
        canExtendIdeaClassLoader$delegate = LazyKt.lazy(ClassLoaderConfiguratorKt::canExtendIdeaClassLoader_delegate$lambda$1);
    }
}

