/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\b\u0012\u0004\u0012\u00020\u00060\u0007H\u0000\u001a\u001a\u0010\f\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u00060\u00072\u0006\u0010\u000e\u001a\u00020\rH\u0000\u001a\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0017\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "toPluginIdSet", "", "Lcom/intellij/openapi/extensions/PluginId;", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "toPluginDescriptors", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "joinedPluginIds", "", "operation", "pluginPathToUserString", "file", "Ljava/nio/file/Path;", "checkCycle", "", "descriptor", "configFile", "visitedFiles", "registryEpName", "extensionPointNameComparator", "Ljava/util/Comparator;", "intellij.platform.core.impl"})
@SourceDebugExtension(value={"SMAP\nIdeaPluginDescriptorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeaPluginDescriptorImpl.kt\ncom/intellij/ide/plugins/IdeaPluginDescriptorImplKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,697:1\n1628#2,3:698\n1611#2,9:701\n1863#2:710\n1864#2:712\n1620#2:713\n1#3:711\n*S KotlinDebug\n*F\n+ 1 IdeaPluginDescriptorImpl.kt\ncom/intellij/ide/plugins/IdeaPluginDescriptorImplKt\n*L\n28#1:698,3\n32#1:701,9\n32#1:710\n32#1:712\n32#1:713\n32#1:711\n*E\n"})
public final class IdeaPluginDescriptorImplKt {
    @NotNull
    private static final String registryEpName = "com.intellij.registryKey";
    @NotNull
    private static final Comparator<String> extensionPointNameComparator = IdeaPluginDescriptorImplKt::extensionPointNameComparator$lambda$3;

    private static final Logger getLOG() {
        return PluginManagerCore.getLogger();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<PluginId> toPluginIdSet(@NotNull Iterable<? extends IdeaPluginDescriptor> $this$toPluginIdSet) {
        void var2_2;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter($this$toPluginIdSet, (String)"<this>");
        Iterable<? extends IdeaPluginDescriptor> iterable = $this$toPluginIdSet;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            IdeaPluginDescriptor ideaPluginDescriptor = (IdeaPluginDescriptor)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getPluginId());
        }
        return (Set)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<IdeaPluginDescriptorImpl> toPluginDescriptors(@NotNull Iterable<PluginId> $this$toPluginDescriptors) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toPluginDescriptors, (String)"<this>");
        Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap = PluginManagerCore.INSTANCE.buildPluginIdMap();
        Iterable<PluginId> $this$mapNotNull$iv = $this$toPluginDescriptors;
        boolean $i$f$mapNotNull = false;
        Iterable<PluginId> iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IdeaPluginDescriptorImpl it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            PluginId it = (PluginId)element$iv$iv;
            boolean bl2 = false;
            if (pluginIdMap.get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final String joinedPluginIds(@NotNull Iterable<PluginId> $this$joinedPluginIds, @NotNull String operation) {
        Intrinsics.checkNotNullParameter($this$joinedPluginIds, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        return CollectionsKt.joinToString$default($this$joinedPluginIds, null, (CharSequence)("Plugins to " + operation + ": ["), (CharSequence)"]", (int)0, null, IdeaPluginDescriptorImplKt::joinedPluginIds$lambda$2, (int)25, null);
    }

    @NotNull
    public static final String pluginPathToUserString(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return StringsKt.replace$default((String)((Object)file).toString(), (String)(System.getProperty("user.home") + File.separatorChar), (String)("" + '~' + File.separatorChar), (boolean)false, (int)4, null);
    }

    private static final void checkCycle(IdeaPluginDescriptorImpl descriptor2, String configFile, List<String> visitedFiles) {
        int n = visitedFiles.size();
        for (int i = 0; i < n; ++i) {
            if (!Intrinsics.areEqual((Object)configFile, (Object)visitedFiles.get(i))) continue;
            List<String> cycle = visitedFiles.subList(i, visitedFiles.size());
            throw new RuntimeException("Plugin " + descriptor2 + " optional descriptors form a cycle: " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)cycle));
        }
    }

    private static final CharSequence joinedPluginIds$lambda$2(PluginId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getIdString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdString(...)");
        return string;
    }

    private static final int extensionPointNameComparator$lambda$3(String o1, String o2) {
        if (Intrinsics.areEqual((Object)o1, (Object)registryEpName)) {
            return Intrinsics.areEqual((Object)o2, (Object)registryEpName) ? 0 : -1;
        }
        if (Intrinsics.areEqual((Object)o2, (Object)registryEpName)) {
            return 1;
        }
        Intrinsics.checkNotNull((Object)o2);
        return o1.compareTo(o2);
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return IdeaPluginDescriptorImplKt.getLOG();
    }

    public static final /* synthetic */ void access$checkCycle(IdeaPluginDescriptorImpl descriptor2, String configFile, List visitedFiles) {
        IdeaPluginDescriptorImplKt.checkCycle(descriptor2, configFile, visitedFiles);
    }

    public static final /* synthetic */ Comparator access$getExtensionPointNameComparator$p() {
        return extensionPointNameComparator;
    }
}

