/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DataLoader;
import com.intellij.ide.plugins.FileItem;
import com.intellij.util.lang.ZipFilePool;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ide/plugins/MixedDirAndJarDataLoader;", "Lcom/intellij/ide/plugins/DataLoader;", "files", "", "Lcom/intellij/ide/plugins/FileItem;", "pool", "Lcom/intellij/util/lang/ZipFilePool;", "jarOnly", "", "<init>", "([Lcom/intellij/ide/plugins/FileItem;Lcom/intellij/util/lang/ZipFilePool;Z)V", "[Lcom/intellij/ide/plugins/FileItem;", "isExcludedFromSubSearch", "jarFile", "Ljava/nio/file/Path;", "emptyDescriptorIfCannotResolve", "getEmptyDescriptorIfCannotResolve", "()Z", "load", "Ljava/io/InputStream;", "path", "", "pluginDescriptorSourceOnly", "toString", "intellij.platform.core.impl"})
final class MixedDirAndJarDataLoader
implements DataLoader {
    @NotNull
    private final FileItem[] files;
    @NotNull
    private final ZipFilePool pool;
    private final boolean jarOnly;

    public MixedDirAndJarDataLoader(@NotNull FileItem[] files, @NotNull ZipFilePool pool, boolean jarOnly) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        this.files = files;
        this.pool = pool;
        this.jarOnly = jarOnly;
    }

    @Override
    public boolean isExcludedFromSubSearch(@NotNull Path jarFile) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        return true;
    }

    @Override
    public boolean getEmptyDescriptorIfCannotResolve() {
        return true;
    }

    @Override
    @Nullable
    public InputStream load(@NotNull String path, boolean pluginDescriptorSourceOnly) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (path.charAt(0) == '/') {
            String string2 = path.substring(1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = path;
        }
        String effectivePath = string;
        for (FileItem item : this.files) {
            if (this.jarOnly || StringsKt.endsWith$default((String)item.path, (String)".jar", (boolean)false, (int)2, null)) {
                ZipFilePool.EntryResolver resolver = item.resolver;
                if (resolver == null && !((resolver = this.pool.load(item.file)) instanceof Closeable)) {
                    item.resolver = resolver;
                }
                InputStream result2 = resolver.loadZipEntry(effectivePath);
                if (resolver instanceof Closeable) {
                    ((Closeable)((Object)resolver)).close();
                }
                if (result2 != null) {
                    return result2;
                }
            } else {
                try {
                    return Files.newInputStream(item.file.resolve(effectivePath), new OpenOption[0]);
                }
                catch (NoSuchFileException noSuchFileException) {
                    // empty catch block
                }
            }
            if (this.jarOnly && pluginDescriptorSourceOnly) break;
        }
        return null;
    }

    @Override
    @NotNull
    public String toString() {
        return "plugin-classpath.txt based data loader";
    }
}

