/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DataLoader;
import com.intellij.ide.plugins.PathResolver;
import com.intellij.ide.plugins.RawPluginDescriptor;
import com.intellij.ide.plugins.ReadModuleContext;
import com.intellij.ide.plugins.XmlReader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.lang.ZipFilePool;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ2\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J,\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J*\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J:\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0012H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/plugins/PluginXmlPathResolver;", "Lcom/intellij/ide/plugins/PathResolver;", "pluginJarFiles", "", "Ljava/nio/file/Path;", "pool", "Lcom/intellij/util/lang/ZipFilePool;", "<init>", "(Ljava/util/List;Lcom/intellij/util/lang/ZipFilePool;)V", "loadXIncludeReference", "", "readInto", "Lcom/intellij/ide/plugins/RawPluginDescriptor;", "readContext", "Lcom/intellij/ide/plugins/ReadModuleContext;", "dataLoader", "Lcom/intellij/ide/plugins/DataLoader;", "base", "", "relativePath", "resolvePath", "resolveModuleFile", "path", "findInJarFiles", "includeBase", "Companion", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class PluginXmlPathResolver
implements PathResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Path> pluginJarFiles;
    @Nullable
    private final ZipFilePool pool;
    @JvmField
    @NotNull
    public static final PathResolver DEFAULT_PATH_RESOLVER;

    public PluginXmlPathResolver(@NotNull List<? extends Path> pluginJarFiles, @Nullable ZipFilePool pool) {
        Intrinsics.checkNotNullParameter(pluginJarFiles, (String)"pluginJarFiles");
        this.pluginJarFiles = pluginJarFiles;
        this.pool = pool;
    }

    @Override
    public boolean loadXIncludeReference(@NotNull RawPluginDescriptor readInto, @NotNull ReadModuleContext readContext, @NotNull DataLoader dataLoader2, @Nullable String base, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)readInto, (String)"readInto");
        Intrinsics.checkNotNullParameter((Object)readContext, (String)"readContext");
        Intrinsics.checkNotNullParameter((Object)dataLoader2, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        String path = Companion.toLoadPath(relativePath, base);
        try {
            ZipFilePool zipFilePool;
            Object object = dataLoader2.load(path, false);
            if (object != null) {
                InputStream it = object;
                boolean bl = false;
                XmlReader.readModuleDescriptor(it, readContext, (PathResolver)this, dataLoader2, Companion.getChildBase$intellij_platform_core_impl(base, relativePath), readInto, null);
                return true;
            }
            if (this.pool != null && this.findInJarFiles(readInto, readContext, dataLoader2, zipFilePool = this.pool, path, (String)(object = Companion.getChildBase$intellij_platform_core_impl(base, relativePath)))) {
                return true;
            }
            if (StringsKt.startsWith$default((String)path, (String)"META-INF/", (boolean)false, (int)2, null) && (object = PluginXmlPathResolver.class.getClassLoader().getResourceAsStream(path)) != null) {
                Object it = object;
                boolean bl = false;
                XmlReader.readModuleDescriptor((InputStream)it, readContext, (PathResolver)this, dataLoader2, null, readInto, null);
                return true;
            }
        }
        catch (Throwable e) {
            throw new IOException("Exception " + e.getMessage() + " while loading " + path, e);
        }
        return false;
    }

    @Override
    @Nullable
    public RawPluginDescriptor resolvePath(@NotNull ReadModuleContext readContext, @NotNull DataLoader dataLoader2, @NotNull String relativePath, @Nullable RawPluginDescriptor readInto) {
        ZipFilePool zipFilePool;
        RawPluginDescriptor result2;
        Intrinsics.checkNotNullParameter((Object)readContext, (String)"readContext");
        Intrinsics.checkNotNullParameter((Object)dataLoader2, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        String path = com.intellij.ide.plugins.PluginXmlPathResolver$Companion.toLoadPath$default(Companion, relativePath, null, 2, null);
        InputStream inputStream = dataLoader2.load(path, false);
        if (inputStream != null) {
            InputStream it = inputStream;
            boolean bl = false;
            return XmlReader.readModuleDescriptor(it, readContext, (PathResolver)this, dataLoader2, null, readInto, null);
        }
        RawPluginDescriptor rawPluginDescriptor = readInto;
        if (rawPluginDescriptor == null) {
            rawPluginDescriptor = result2 = new RawPluginDescriptor();
        }
        if (this.pool != null && this.findInJarFiles(result2, readContext, dataLoader2, zipFilePool = this.pool, path, null)) {
            return result2;
        }
        if (StringsKt.startsWith$default((String)relativePath, (String)"intellij.", (boolean)false, (int)2, null)) {
            throw new RuntimeException("Cannot resolve " + path + " (dataLoader=" + dataLoader2 + ')');
        }
        return null;
    }

    @Override
    @NotNull
    public RawPluginDescriptor resolveModuleFile(@NotNull ReadModuleContext readContext, @NotNull DataLoader dataLoader2, @NotNull String path, @Nullable RawPluginDescriptor readInto) {
        Intrinsics.checkNotNullParameter((Object)readContext, (String)"readContext");
        Intrinsics.checkNotNullParameter((Object)dataLoader2, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        InputStream input = dataLoader2.load(path, true);
        if (input == null) {
            if (Intrinsics.areEqual((Object)path, (Object)"intellij.profiler.clion")) {
                RawPluginDescriptor descriptor2 = new RawPluginDescriptor();
                descriptor2.package = "com.intellij.profiler.clion";
                return descriptor2;
            }
            throw new RuntimeException("Cannot resolve " + path + " (dataLoader=" + dataLoader2 + ", pluginJarFiles=" + CollectionsKt.joinToString$default((Iterable)this.pluginJarFiles, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null) + ')');
        }
        RawPluginDescriptor descriptor3 = XmlReader.readModuleDescriptor(input, readContext, (PathResolver)this, dataLoader2, null, readInto, null);
        return descriptor3;
    }

    private final boolean findInJarFiles(RawPluginDescriptor readInto, ReadModuleContext readContext, DataLoader dataLoader2, ZipFilePool pool, String relativePath, String includeBase) {
        for (Path jarFile : this.pluginJarFiles) {
            RawPluginDescriptor rawPluginDescriptor;
            ZipFilePool.EntryResolver entryResolver;
            if (dataLoader2.isExcludedFromSubSearch(jarFile)) continue;
            try {
                entryResolver = pool.load(jarFile);
            }
            catch (IOException e) {
                Logger.getInstance(PluginXmlPathResolver.class).error("Corrupted jar file: " + jarFile, e);
                continue;
            }
            ZipFilePool.EntryResolver entryResolver2 = entryResolver;
            Intrinsics.checkNotNull((Object)entryResolver2);
            ZipFilePool.EntryResolver resolver = entryResolver2;
            if (resolver.loadZipEntry(relativePath) != null) {
                InputStream it;
                boolean bl = false;
                rawPluginDescriptor = XmlReader.readModuleDescriptor(it, readContext, (PathResolver)this, dataLoader2, includeBase, readInto, ((Object)jarFile).toString());
            } else {
                rawPluginDescriptor = null;
            }
            RawPluginDescriptor result2 = rawPluginDescriptor;
            Closeable closeable = resolver instanceof Closeable ? (Closeable)((Object)resolver) : null;
            if (closeable != null) {
                closeable.close();
            }
            if (result2 == null) continue;
            return true;
        }
        return false;
    }

    static {
        List list = Collections.emptyList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
        DEFAULT_PATH_RESOLVER = new PluginXmlPathResolver(list, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\tJ\u001a\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0007J!\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u000eR\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/plugins/PluginXmlPathResolver$Companion;", "", "<init>", "()V", "DEFAULT_PATH_RESOLVER", "Lcom/intellij/ide/plugins/PathResolver;", "getParentPath", "", "path", "getParentPath$intellij_platform_core_impl", "toLoadPath", "relativePath", "base", "getChildBase", "getChildBase$intellij_platform_core_impl", "intellij.platform.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getParentPath$intellij_platform_core_impl(@NotNull String path) {
            String string;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            int end = StringsKt.lastIndexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null);
            if (end == -1) {
                string = "";
            } else {
                String string2 = path.substring(0, end);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            }
            return string;
        }

        @NotNull
        public final String toLoadPath(@NotNull String relativePath, @Nullable String base) {
            String string;
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            if (relativePath.charAt(0) == '/') {
                String string2 = relativePath.substring(1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else if (StringsKt.startsWith$default((String)relativePath, (String)"intellij.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)relativePath, (String)"kotlin.", (boolean)false, (int)2, null)) {
                string = relativePath;
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                String string3 = base;
                if (string3 == null) {
                    string3 = "META-INF";
                }
                string = stringBuilder.append(string3).append('/').append(relativePath).toString();
            }
            return string;
        }

        public static /* synthetic */ String toLoadPath$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return companion.toLoadPath(string, string2);
        }

        @Nullable
        public final String getChildBase$intellij_platform_core_impl(@Nullable String base, @NotNull String relativePath) {
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            int end = StringsKt.lastIndexOf$default((CharSequence)relativePath, (char)'/', (int)0, (boolean)false, (int)6, null);
            if (end <= 0 || StringsKt.startsWith$default((String)relativePath, (String)"/META-INF/", (boolean)false, (int)2, null)) {
                return base;
            }
            String string = relativePath.substring(0, end);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String childBase = string;
            return base == null ? childBase : base + '/' + childBase;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

