/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.concurrency.ThreadContext;
import com.intellij.diagnostic.EventWatcher;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.BulkArrayQueue;
import com.intellij.openapi.application.impl.InvocationUtil;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.ThrottledLogger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class FlushQueue {
    private static final Logger LOG = Logger.getInstance(FlushQueue.class);
    private static final ThrottledLogger THROTTLED_LOG = new ThrottledLogger(LOG, TimeUnit.MINUTES.toMillis(1L));
    private ObjectArrayList<RunnableInfo> mySkippedItems = new ObjectArrayList(100);
    private final BulkArrayQueue<RunnableInfo> myQueue = new BulkArrayQueue();
    private boolean FLUSHER_SCHEDULED;
    private final Runnable FLUSH_NOW = this::flushNow;

    FlushQueue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushNow() {
        block14: {
            try (AccessToken ignored = ThreadContext.resetThreadContext();){
                ThreadingAssertions.assertEventDispatchThread();
                Object object = this.getQueueLock();
                synchronized (object) {
                    this.FLUSHER_SCHEDULED = false;
                }
                long startTime = System.currentTimeMillis();
                do {
                    RunnableInfo info;
                    if ((info = this.pollNextEvent()) == null) {
                        break block14;
                    }
                    FlushQueue.runNextEvent(info);
                } while (!InvocationUtil.priorityEventPending() && System.currentTimeMillis() - startTime <= 5L);
                Object object2 = this.getQueueLock();
                synchronized (object2) {
                    this.requestFlush();
                }
            }
        }
    }

    private Object getQueueLock() {
        return this.myQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void push(@NotNull ModalityState modalityState, @NotNull Condition<?> expired, @NotNull Runnable runnable) {
        if (modalityState == null) {
            FlushQueue.$$$reportNull$$$0(0);
        }
        if (expired == null) {
            FlushQueue.$$$reportNull$$$0(1);
        }
        if (runnable == null) {
            FlushQueue.$$$reportNull$$$0(2);
        }
        Object object = this.getQueueLock();
        synchronized (object) {
            int queueSize = this.myQueue.size();
            RunnableInfo info = new RunnableInfo(runnable, modalityState, expired, queueSize);
            this.myQueue.enqueue(info);
            this.requestFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @TestOnly
    @NotNull
    Object getQueue() {
        Object object = this.getQueueLock();
        // MONITORENTER : object
        BulkArrayQueue<RunnableInfo> bulkArrayQueue = this.myQueue;
        // MONITOREXIT : object
        if (bulkArrayQueue != null) return bulkArrayQueue;
        FlushQueue.$$$reportNull$$$0(3);
        return bulkArrayQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.getQueueLock();
        synchronized (object) {
            return "LaterInvocator.FlushQueue size=" + this.myQueue.size() + "; FLUSHER_SCHEDULED=" + this.FLUSHER_SCHEDULED;
        }
    }

    @Nullable
    private RunnableInfo pollNextEvent() {
        Object object = this.getQueueLock();
        synchronized (object) {
            ModalityStateEx currentModality = LaterInvocator.getCurrentModalityState();
            while (true) {
                RunnableInfo info;
                if ((info = this.myQueue.pollFirst()) == null) {
                    return null;
                }
                if (info.expired.value(null)) continue;
                if (!((ModalityState)currentModality).dominates(info.modalityState)) {
                    this.requestFlush();
                    return info;
                }
                this.mySkippedItems.add(info.wasSkipped());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void runNextEvent(@NotNull RunnableInfo info) {
        if (info == null) {
            FlushQueue.$$$reportNull$$$0(4);
        }
        EventWatcher watcher = EventWatcher.getInstanceOrNull();
        long waitingFinishedNs = System.nanoTime();
        try {
            info.runnable.run();
            if (watcher == null) return;
        }
        catch (ProcessCanceledException runnable) {
            if (watcher == null) return;
            Runnable runnable2 = info.runnable;
            long executionFinishedNs = System.nanoTime();
            long waitedInQueueNs = waitingFinishedNs - info.queuedTimeNs;
            long executionDurationNs = executionFinishedNs - waitingFinishedNs;
            long waitedTimeInQueueNs_safe = waitedInQueueNs >= 0L ? waitedInQueueNs : 0L;
            long executionDurationNs_safe = executionDurationNs >= 0L ? executionDurationNs : 0L;
            watcher.runnableTaskFinished(runnable2, waitedTimeInQueueNs_safe, info.queueSize, executionDurationNs_safe, info.wasInSkippedItems);
            if (waitedInQueueNs >= 0L && executionDurationNs >= 0L) return;
            THROTTLED_LOG.info("waitedInQueueNs(" + waitedInQueueNs + ") | executionDurationNs(" + executionDurationNs + ") is negative -> unexpected state");
            return;
        }
        catch (Throwable t) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ExceptionUtil.rethrow(t);
            }
            LOG.error(t);
            if (watcher == null) return;
            {
                catch (Throwable throwable) {
                    if (watcher == null) throw throwable;
                    Runnable runnable3 = info.runnable;
                    long executionFinishedNs2 = System.nanoTime();
                    long waitedInQueueNs2 = waitingFinishedNs - info.queuedTimeNs;
                    long executionDurationNs2 = executionFinishedNs2 - waitingFinishedNs;
                    long waitedTimeInQueueNs_safe2 = waitedInQueueNs2 >= 0L ? waitedInQueueNs2 : 0L;
                    long executionDurationNs_safe2 = executionDurationNs2 >= 0L ? executionDurationNs2 : 0L;
                    watcher.runnableTaskFinished(runnable3, waitedTimeInQueueNs_safe2, info.queueSize, executionDurationNs_safe2, info.wasInSkippedItems);
                    if (waitedInQueueNs2 >= 0L && executionDurationNs2 >= 0L) throw throwable;
                    THROTTLED_LOG.info("waitedInQueueNs(" + waitedInQueueNs2 + ") | executionDurationNs(" + executionDurationNs2 + ") is negative -> unexpected state");
                    throw throwable;
                }
            }
            Runnable runnable4 = info.runnable;
            long executionFinishedNs = System.nanoTime();
            long waitedInQueueNs = waitingFinishedNs - info.queuedTimeNs;
            long executionDurationNs = executionFinishedNs - waitingFinishedNs;
            long waitedTimeInQueueNs_safe = waitedInQueueNs >= 0L ? waitedInQueueNs : 0L;
            long executionDurationNs_safe = executionDurationNs >= 0L ? executionDurationNs : 0L;
            watcher.runnableTaskFinished(runnable4, waitedTimeInQueueNs_safe, info.queueSize, executionDurationNs_safe, info.wasInSkippedItems);
            if (waitedInQueueNs >= 0L && executionDurationNs >= 0L) return;
            THROTTLED_LOG.info("waitedInQueueNs(" + waitedInQueueNs + ") | executionDurationNs(" + executionDurationNs + ") is negative -> unexpected state");
            return;
        }
        Runnable runnable = info.runnable;
        long executionFinishedNs = System.nanoTime();
        long waitedInQueueNs = waitingFinishedNs - info.queuedTimeNs;
        long executionDurationNs = executionFinishedNs - waitingFinishedNs;
        long waitedTimeInQueueNs_safe = waitedInQueueNs >= 0L ? waitedInQueueNs : 0L;
        long executionDurationNs_safe = executionDurationNs >= 0L ? executionDurationNs : 0L;
        watcher.runnableTaskFinished(runnable, waitedTimeInQueueNs_safe, info.queueSize, executionDurationNs_safe, info.wasInSkippedItems);
        if (waitedInQueueNs >= 0L && executionDurationNs >= 0L) return;
        THROTTLED_LOG.info("waitedInQueueNs(" + waitedInQueueNs + ") | executionDurationNs(" + executionDurationNs + ") is negative -> unexpected state");
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reincludeSkippedItems() {
        ThreadingAssertions.assertEventDispatchThread();
        Object object = this.getQueueLock();
        synchronized (object) {
            int size = this.mySkippedItems.size();
            if (size != 0) {
                this.myQueue.bulkEnqueueFirst(this.mySkippedItems);
                if (size < 100) {
                    this.mySkippedItems.clear();
                } else {
                    this.mySkippedItems = new ObjectArrayList(100);
                }
            }
            this.requestFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void purgeExpiredItems() {
        ThreadingAssertions.assertEventDispatchThread();
        Object object = this.getQueueLock();
        synchronized (object) {
            this.reincludeSkippedItems();
            this.myQueue.removeAll(info -> ((RunnableInfo)info).expired.value(null));
            this.requestFlush();
        }
    }

    private void requestFlush() {
        boolean shouldSchedule;
        boolean bl = shouldSchedule = !this.FLUSHER_SCHEDULED && !this.myQueue.isEmpty();
        if (shouldSchedule) {
            this.FLUSHER_SCHEDULED = true;
            SwingUtilities.invokeLater(this.FLUSH_NOW);
        }
    }

    boolean isFlushNow(@NotNull Runnable runnable) {
        if (runnable == null) {
            FlushQueue.$$$reportNull$$$0(5);
        }
        return runnable == this.FLUSH_NOW;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expired";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/FlushQueue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/FlushQueue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runNextEvent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFlushNow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RunnableInfo {
        @NotNull
        private final Runnable runnable;
        @NotNull
        private final ModalityState modalityState;
        @NotNull
        private final Condition<?> expired;
        private final long queuedTimeNs;
        private final int queueSize;
        private final boolean wasInSkippedItems;

        @Async.Schedule
        RunnableInfo(@NotNull Runnable runnable, @NotNull ModalityState modalityState, @NotNull Condition<?> expired, int queueSize) {
            if (runnable == null) {
                RunnableInfo.$$$reportNull$$$0(0);
            }
            if (modalityState == null) {
                RunnableInfo.$$$reportNull$$$0(1);
            }
            if (expired == null) {
                RunnableInfo.$$$reportNull$$$0(2);
            }
            this(runnable, modalityState, expired, queueSize, System.nanoTime(), false);
        }

        /*
         * WARNING - void declaration
         */
        @Async.Schedule
        private RunnableInfo(@NotNull Runnable runnable, @NotNull ModalityState modalityState, @NotNull Condition<?> expired, int queueSize, long queuedTimeNs, boolean bl) {
            void wasInSkippedItems;
            if (runnable == null) {
                RunnableInfo.$$$reportNull$$$0(3);
            }
            if (modalityState == null) {
                RunnableInfo.$$$reportNull$$$0(4);
            }
            if (expired == null) {
                RunnableInfo.$$$reportNull$$$0(5);
            }
            this.runnable = runnable;
            this.modalityState = modalityState;
            this.expired = expired;
            this.queuedTimeNs = queuedTimeNs;
            this.queueSize = queueSize;
            this.wasInSkippedItems = wasInSkippedItems;
        }

        public RunnableInfo wasSkipped() {
            return new RunnableInfo(this.runnable, this.modalityState, this.expired, this.queueSize, this.queuedTimeNs, true);
        }

        @NonNls
        public String toString() {
            return "[runnable: " + this.runnable + "; state=" + this.modalityState + (this.expired.value(null) ? "; expired" : "") + "]{queued at: " + this.queuedTimeNs + " ns, " + this.queueSize + " items were in front of}{wasSkipped: " + this.wasInSkippedItems + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "runnable";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "modalityState";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expired";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/application/impl/FlushQueue$RunnableInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

